/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.pmd;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.rubypeople.rdt.internal.core.pmd.CPDListener;
import org.rubypeople.rdt.internal.core.pmd.CPDNullListener;
import org.rubypeople.rdt.internal.core.pmd.Language;
import org.rubypeople.rdt.internal.core.pmd.Match;
import org.rubypeople.rdt.internal.core.pmd.MatchAlgorithm;
import org.rubypeople.rdt.internal.core.pmd.RubyLanguage;
import org.rubypeople.rdt.internal.core.pmd.SourceCode;
import org.rubypeople.rdt.internal.core.pmd.TokenEntry;
import org.rubypeople.rdt.internal.core.pmd.Tokens;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPD {
    private Map<String, SourceCode> source = new HashMap<String, SourceCode>();
    private int minimumTileSize;
    private Language language = new RubyLanguage();
    private MatchAlgorithm matchAlgorithm;
    private Tokens tokens = new Tokens();
    private CPDListener listener = new CPDNullListener();
    private Set<String> current = new HashSet<String>();

    private CPD(int minimumTileSize) {
        this.minimumTileSize = minimumTileSize;
    }

    public static Iterator<Match> findMatches(List<IFile> files) throws IOException {
        int minimumTokens = 5;
        CPD cpd = new CPD(minimumTokens);
        cpd.add(files);
        cpd.go();
        return cpd.getMatches();
    }

    private void go() {
        TokenEntry.clearImages();
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.minimumTileSize, this.listener);
        this.matchAlgorithm.findMatches();
    }

    private Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    private void add(List<IFile> files) throws IOException {
        for (IFile file : files) {
            this.add(files.size(), file);
        }
    }

    private void add(int fileCount, IFile file) throws IOException {
        File realFile = file.getLocation().toFile();
        String signature = String.valueOf(realFile.getName()) + '_' + realFile.length();
        if (this.current.contains(signature)) {
            return;
        }
        this.current.add(signature);
        if (!realFile.getCanonicalPath().equals(realFile.getAbsolutePath())) {
            return;
        }
        this.listener.addedFile(fileCount, realFile);
        SourceCode sourceCode = new SourceCode(new SourceCode.FileCodeLoader(realFile));
        this.language.getTokenizer().tokenize(sourceCode, this.tokens);
        this.source.put(sourceCode.getFileName(), sourceCode);
    }
}

