/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser.warnings;

import java.util.List;
import org.jruby.ast.HashNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public class Ruby19HashCommaSyntax
extends RubyLintVisitor {
    public Ruby19HashCommaSyntax(String contents) {
        super(contents);
    }

    protected String getOptionKey() {
        return "org.rubypeople.rdt.core.compiler.problem.ruby19HashCommaSyntax";
    }

    protected String getSeverity() {
        return super.getSeverity();
    }

    public Instruction visitHashNode(HashNode iVisited) {
        ListNode list = iVisited.getListNode();
        List children = list.childNodes();
        int i = 0;
        while (i < children.size()) {
            ISourcePosition pos;
            String between;
            Node value;
            if (children.size() <= i + 1) break;
            Node key = (Node)children.get(i);
            if (key != null && (value = (Node)children.get(i + 1)) != null && (between = this.getSource((pos = key.getPosition()).getEndOffset(), value.getPosition().getStartOffset())) != null && between.trim().equals(",")) {
                int start = pos.getEndOffset() + between.indexOf(",");
                this.createProblem((ISourcePosition)new IDESourcePosition("", pos.getEndLine(), pos.getEndLine(), start, start + 1), "',' not allowed to separate keys and values in hashes for Ruby 1.9. Please use '=>'.");
            }
            i += 2;
        }
        return super.visitHashNode(iVisited);
    }

    protected int getProblemID() {
        return 0x40000003;
    }
}

