/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.hierarchy.HierarchyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws RubyModelException {
        super(hierarchy);
    }

    public void build(boolean computeSubtypes) {
        if (this.hierarchy.focusType == null || computeSubtypes) {
            SubProgressMonitor typeInRegionMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 30);
            HashMap allOpenablesInRegion = this.determineOpenablesInRegion((IProgressMonitor)typeInRegionMonitor);
            this.hierarchy.initialize(allOpenablesInRegion.size());
            SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 70);
            this.createTypeHierarchyBasedOnRegion(allOpenablesInRegion, (IProgressMonitor)buildMonitor);
            ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
        } else {
            this.hierarchy.initialize(1);
            this.buildSupertypes();
        }
    }

    private void createTypeHierarchyBasedOnRegion(HashMap allOpenablesInRegion, IProgressMonitor monitor) {
        int size = allOpenablesInRegion.size();
        if (size == 0) {
            if (monitor != null) {
                monitor.done();
            }
            return;
        }
        this.infoToHandle = new HashMap(size);
        for (RubyProject project : allOpenablesInRegion.keySet()) {
            ArrayList allOpenables = (ArrayList)allOpenablesInRegion.get(project);
            Openable[] openables = new Openable[allOpenables.size()];
            allOpenables.toArray(openables);
            try {
                if (monitor != null) {
                    monitor.beginTask("", size * 2);
                }
                this.hierarchyResolver.resolve(openables, null, monitor);
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private HashMap determineOpenablesInRegion(IProgressMonitor monitor) {
        try {
            HashMap allOpenables = new HashMap();
            IRubyElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).region.getElements();
            int length = roots.length;
            if (monitor != null) {
                monitor.beginTask("", length);
            }
            int i = 0;
            while (i < length) {
                IRubyElement root = roots[i];
                IRubyProject javaProject = root.getRubyProject();
                ArrayList<IRubyElement> openables = (ArrayList<IRubyElement>)allOpenables.get(javaProject);
                if (openables == null) {
                    openables = new ArrayList<IRubyElement>();
                    allOpenables.put(javaProject, openables);
                }
                switch (root.getElementType()) {
                    case 1: {
                        this.injectAllOpenablesForRubyProject((IRubyProject)root, openables);
                        break;
                    }
                    case 2: {
                        this.injectAllOpenablesForSourceFolderRoot((ISourceFolderRoot)root, openables);
                        break;
                    }
                    case 3: {
                        this.injectAllOpenablesForSourceFolder((ISourceFolder)root, openables);
                        break;
                    }
                    case 4: {
                        openables.add(root);
                        break;
                    }
                    case 5: {
                        IType type = (IType)root;
                        openables.add(type.getRubyScript());
                        break;
                    }
                }
                this.worked(monitor, 1);
                ++i;
            }
            HashMap hashMap = allOpenables;
            return hashMap;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void injectAllOpenablesForRubyProject(IRubyProject project, ArrayList openables) {
        try {
            ISourceFolderRoot[] devPathRoots = ((RubyProject)project).getSourceFolderRoots();
            if (devPathRoots == null) {
                return;
            }
            int j = 0;
            while (j < devPathRoots.length) {
                ISourceFolderRoot root = devPathRoots[j];
                this.injectAllOpenablesForSourceFolderRoot(root, openables);
                ++j;
            }
        }
        catch (RubyModelException rubyModelException) {}
    }

    private void injectAllOpenablesForSourceFolder(ISourceFolder packFrag, ArrayList openables) {
        try {
            IRubyScript[] cus = packFrag.getRubyScripts();
            int i = 0;
            int length = cus.length;
            while (i < length) {
                openables.add(cus[i]);
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
    }

    private void injectAllOpenablesForSourceFolderRoot(ISourceFolderRoot root, ArrayList openables) {
        try {
            IRubyElement[] packFrags = root.getChildren();
            int k = 0;
            while (k < packFrags.length) {
                ISourceFolder packFrag = (ISourceFolder)packFrags[k];
                this.injectAllOpenablesForSourceFolder(packFrag, openables);
                ++k;
            }
        }
        catch (RubyModelException rubyModelException) {
            return;
        }
    }
}

