/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.codeassist.RubyElementRequestor;
import org.rubypeople.rdt.internal.core.LogicalType;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.hierarchy.HierarchyBuilder;

public class HierarchyResolver {
    private boolean superTypesOnly;
    private HierarchyBuilder builder;
    private HashSet<String> visitedTypes;

    public HierarchyResolver(Map options, HierarchyBuilder builder) {
        this.builder = builder;
    }

    public void resolve(Openable[] openables, HashSet localTypes, IProgressMonitor monitor) {
        try {
            try {
                int openablesLength = openables.length;
                IType focus = this.builder.getType();
                int i = 0;
                while (i < openablesLength) {
                    Openable openable = openables[i];
                    if (openable instanceof IRubyScript) {
                        IRubyScript cu = (IRubyScript)((Object)openable);
                        IType[] types = cu.getAllTypes();
                        int j = 0;
                        while (j < types.length) {
                            IType type = types[j];
                            if (this.focusIsInHierarchy(focus, type)) {
                                try {
                                    this.visitedTypes = new HashSet();
                                    this.reportHierarchy(type);
                                    this.visitedTypes.clear();
                                }
                                catch (RubyModelException rubyModelException) {}
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (ClassCastException classCastException) {
                this.reset();
            }
            catch (RubyModelException rubyModelException) {
                this.reset();
            }
        }
        finally {
            this.reset();
        }
    }

    private boolean focusIsInHierarchy(IType focus, IType type) throws RubyModelException {
        if (focus == null || type == null) {
            return false;
        }
        if (type.getFullyQualifiedName().equals(focus.getFullyQualifiedName())) {
            return true;
        }
        return this.focusIsInHierarchy(focus, this.findSuperClass(type));
    }

    private void reportHierarchy(IType type) throws RubyModelException {
        this.visitedTypes.add(type.getFullyQualifiedName());
        IType superclass = type.isModule() ? null : this.findSuperClass(type);
        IType[] superinterfaces = this.findSuperInterfaces(type);
        this.builder.connect(type, superclass, superinterfaces);
        if (type.isClass() && superclass != null) {
            if (this.visitedTypes.contains(superclass.getFullyQualifiedName())) {
                throw new IllegalStateException("Invalid type hierarchy: Loop in tree. Class: " + type.getFullyQualifiedName() + ", superclass: " + superclass.getFullyQualifiedName());
            }
            this.reportHierarchy(superclass);
        }
    }

    private IType[] findSuperInterfaces(IType type) throws RubyModelException {
        String[] names = type.getIncludedModuleNames();
        ArrayList<IType> types = new ArrayList<IType>();
        int i = 0;
        while (i < names.length) {
            String namespace;
            IType logical = this.getLogicalType(type, names[i]);
            if (logical != null || (logical = this.getLogicalType(type, String.valueOf(namespace = type.getFullyQualifiedName().substring(0, type.getFullyQualifiedName().length() - type.getElementName().length())) + names[i])) != null) {
                types.add(logical);
            }
            ++i;
        }
        return types.toArray(new IType[types.size()]);
    }

    private IType findSuperClass(IType type) throws RubyModelException {
        String name = type.getSuperclassName();
        if (name == null) {
            return null;
        }
        return this.getLogicalType(type, name);
    }

    private IType getLogicalType(IType type, String name) {
        RubyElementRequestor requestor = new RubyElementRequestor(type.getRubyScript());
        IType[] types = requestor.findType(name);
        if (types == null || types.length == 0) {
            return null;
        }
        return new LogicalType(types);
    }

    private void reset() {
        this.superTypesOnly = false;
    }

    public void resolve(IType type) {
        IRubyScript cu = type.getRubyScript();
        HashSet<String> localTypes = new HashSet<String>();
        localTypes.add(cu.getPath().toString());
        this.superTypesOnly = true;
        this.resolve(new Openable[]{(Openable)((Object)cu)}, localTypes, null);
    }
}

