/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.internal.core.parser.Error;

public class SyntaxExceptionHandler {
    public static CategorizedProblem handle(SyntaxException e, String contents) {
        Pattern p;
        Matcher m;
        String restOfSource = contents.substring(e.getPosition().getStartOffset());
        if (restOfSource != null && e.getMessage().trim().endsWith("but found '=' instead") && restOfSource.startsWith("begin")) {
            int endIndex = restOfSource.indexOf("=end");
            endIndex = endIndex == -1 ? contents.length() : (endIndex += e.getPosition().getStartOffset() + 3);
            IDESourcePosition pos = new IDESourcePosition(e.getPosition().getFile(), e.getPosition().getStartLine(), e.getPosition().getEndLine(), e.getPosition().getStartOffset() - 1, endIndex);
            Error problem = new Error((ISourcePosition)pos, "Multine Comment must start at beginning of line", 0x40000001);
            return problem;
        }
        if (e.getMessage().trim().endsWith("unexpected end-of-file") && (m = (p = Pattern.compile("[@+|$|:]?\\w+\\.[;|\\s]")).matcher(contents)).find()) {
            int startLine = SyntaxExceptionHandler.getLineOfOffset(m.start(), contents);
            int endLine = SyntaxExceptionHandler.getLineOfOffset(m.end(), contents);
            IDESourcePosition pos = new IDESourcePosition(e.getPosition().getFile(), startLine, endLine, m.start(), m.end());
            return new Error((ISourcePosition)pos, "Method invocation without method name", 0x40000000);
        }
        return SyntaxExceptionHandler.grabPrecedingPrefixForPosition(e, contents);
    }

    private static CategorizedProblem grabPrecedingPrefixForPosition(SyntaxException e, String contents) {
        int offset = e.getPosition().getStartOffset();
        String prefix = SyntaxExceptionHandler.getLeadingPrefix(contents, offset);
        IDESourcePosition pos = new IDESourcePosition(e.getPosition().getFile(), e.getPosition().getStartLine(), e.getPosition().getEndLine(), offset - prefix.length() - 1, offset - 1);
        return new Error((ISourcePosition)pos, e.getMessage(), 0x40000000);
    }

    private static int getLineOfOffset(int offset, String contents) {
        String[] lines = contents.split("\\r|\\n|\\r\\n");
        int lineDelimeterLength = SyntaxExceptionHandler.getLineDelimeterLength(contents);
        int start = 0;
        int i = 0;
        while (i < lines.length) {
            int end = start + lines[i].length();
            if (offset <= end) {
                return i + 1;
            }
            start = end + lineDelimeterLength;
            ++i;
        }
        return 1;
    }

    private static int getLineDelimeterLength(String string) {
        int index = string.indexOf(10);
        if (index == -1) {
            return 1;
        }
        if (index == 0) {
            return 1;
        }
        char c = string.charAt(index - 1);
        if (c == '\r') {
            return 2;
        }
        return 1;
    }

    private static String getLeadingPrefix(String contents, int offset) {
        StringBuffer buffer = new StringBuffer();
        int i = offset - 1;
        while (i >= 0) {
            char c = contents.charAt(i);
            if (Character.isWhitespace(c)) break;
            buffer.insert(0, c);
            --i;
        }
        return buffer.toString();
    }
}

