/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.rubypeople.rdt.core.RubyCore;

public class IoUtils {
    public static void closeQuietly(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            RubyCore.log(e);
        }
    }

    public static void closeQuietly(InputStream contents) {
        try {
            if (contents != null) {
                contents.close();
            }
        }
        catch (IOException e) {
            RubyCore.log(e);
        }
    }

    public static String readAll(Reader reader) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[1024];
        int bytesRead;
        while ((bytesRead = reader.read(buffer)) > 0) {
            result.append(buffer, 0, bytesRead);
        }
        return result.toString();
    }

    public static String readAllQuietly(Reader reader) {
        try {
            return IoUtils.readAll(reader);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }
}

