/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.builder.IMarkerManager;

public abstract class AbstractRdtCompiler {
    protected final IProject project;
    protected final IMarkerManager markerManager;
    protected CompilationParticipant[] fParticipants;
    private IRubyProject fRubyProject;

    public AbstractRdtCompiler(IProject project, IMarkerManager markerManager) {
        this.project = project;
        this.markerManager = markerManager;
        this.fRubyProject = this.getRubyProject();
        this.fParticipants = RubyModelManager.getRubyModelManager().compilationParticipants.getCompilationParticipants(this.fRubyProject);
    }

    protected abstract void removeMarkers(IMarkerManager var1);

    public void compile(IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < this.fParticipants.length) {
            this.fParticipants[i].aboutToBuild(this.fRubyProject);
            ++i;
        }
        BuildContext[] files = this.getBuildContexts();
        int taskCount = files.length * (this.fParticipants.length + 1);
        monitor.beginTask("Building " + this.project.getName() + "...", taskCount);
        monitor.subTask("Removing Markers...");
        this.removeMarkers(this.markerManager);
        monitor.worked(files.length);
        monitor.subTask("Analyzing Files...");
        this.compileFiles(files, monitor);
        monitor.done();
    }

    private void compileFiles(BuildContext[] contexts, IProgressMonitor monitor) throws CoreException {
        int i;
        if (this.fParticipants != null) {
            i = 0;
            while (i < this.fParticipants.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.fParticipants[i].buildStarting(contexts, true);
                ++i;
            }
        }
        i = 0;
        while (i < contexts.length) {
            CategorizedProblem[] problems = contexts[i].getProblems();
            if (problems != null && problems.length != 0) {
                int j = 0;
                while (j < problems.length) {
                    this.markerManager.addProblem(contexts[i].getFile(), problems[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected abstract BuildContext[] getBuildContexts() throws CoreException;

    private IRubyProject getRubyProject() {
        return RubyCore.create(this.project);
    }

    public void aboutToBuild() {
        if (this.fParticipants != null) {
            int i = 0;
            while (i < this.fParticipants.length) {
                this.fParticipants[i].aboutToBuild(this.fRubyProject);
                ++i;
            }
        }
    }
}

