/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.YieldNode;
import org.jruby.evaluator.Instruction;
import org.jruby.runtime.Visibility;
import org.rubypeople.rdt.internal.compiler.ISourceElementRequestor;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.util.ASTUtil;

public class SourceElementParser
extends InOrderVisitor {
    private static final String MODULE_FUNCTION = "module_function";
    private static final String PROTECTED = "protected";
    private static final String PRIVATE = "private";
    private static final String PUBLIC = "public";
    private static final String INCLUDE = "include";
    private static final String LOAD = "load";
    private static final String REQUIRE = "require";
    private static final String ALIAS = "alias :";
    private static final String MODULE = "Module";
    private static final String CONSTRUCTOR_NAME = "initialize";
    private static final String OBJECT = "Object";
    private List<Visibility> visibilities = new ArrayList<Visibility>();
    private boolean inSingletonClass;
    public ISourceElementRequestor requestor;
    private boolean inModuleFunction;
    private char[] source;
    private String typeName;

    public SourceElementParser(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        this.pushVisibility(Visibility.PUBLIC);
        ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
        typeInfo.name = ASTUtil.getFullyQualifiedName((Node)iVisited.getCPath());
        typeInfo.declarationStart = iVisited.getPosition().getStartOffset();
        typeInfo.nameSourceStart = iVisited.getCPath().getPosition().getStartOffset();
        typeInfo.nameSourceEnd = iVisited.getCPath().getPosition().getEndOffset() - 1;
        if (!typeInfo.name.equals(OBJECT)) {
            String superClass;
            typeInfo.superclass = superClass = ASTUtil.getSuperClassName(iVisited.getSuperNode());
        }
        typeInfo.isModule = false;
        typeInfo.modules = new String[0];
        typeInfo.secondary = false;
        this.typeName = typeInfo.name;
        this.requestor.enterType(typeInfo);
        Instruction ins = super.visitClassNode(iVisited);
        this.popVisibility();
        this.requestor.exitType(iVisited.getPosition().getEndOffset() - 2);
        return ins;
    }

    public Instruction visitConstNode(ConstNode iVisited) {
        this.requestor.acceptTypeReference(iVisited.getName(), iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset());
        return super.visitConstNode(iVisited);
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.pushVisibility(Visibility.PUBLIC);
        ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
        typeInfo.name = ASTUtil.getFullyQualifiedName((Node)iVisited.getCPath());
        typeInfo.declarationStart = iVisited.getPosition().getStartOffset();
        typeInfo.nameSourceStart = iVisited.getCPath().getPosition().getStartOffset();
        typeInfo.nameSourceEnd = iVisited.getCPath().getPosition().getEndOffset() - 1;
        typeInfo.superclass = MODULE;
        typeInfo.isModule = true;
        typeInfo.modules = new String[0];
        typeInfo.secondary = false;
        this.typeName = typeInfo.name;
        this.requestor.enterType(typeInfo);
        Instruction ins = super.visitModuleNode(iVisited);
        this.popVisibility();
        this.requestor.exitType(iVisited.getPosition().getEndOffset() - 2);
        this.inModuleFunction = false;
        return ins;
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        Visibility visibility = this.getCurrentVisibility();
        ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
        methodInfo.declarationStart = iVisited.getPosition().getStartOffset();
        methodInfo.name = iVisited.getName();
        methodInfo.nameSourceStart = iVisited.getNameNode().getPosition().getStartOffset();
        methodInfo.nameSourceEnd = iVisited.getNameNode().getPosition().getEndOffset() - 1;
        if (methodInfo.name.equals(CONSTRUCTOR_NAME)) {
            visibility = Visibility.PROTECTED;
            methodInfo.isConstructor = true;
        } else {
            methodInfo.isConstructor = false;
        }
        methodInfo.isClassLevel = this.inSingletonClass || this.inModuleFunction;
        methodInfo.visibility = this.convertVisibility(visibility);
        methodInfo.parameterNames = ASTUtil.getArgs((Node)iVisited.getArgsNode(), iVisited.getScope());
        if (methodInfo.isConstructor) {
            this.requestor.enterConstructor(methodInfo);
        } else {
            this.requestor.enterMethod(methodInfo);
        }
        Instruction ins = super.visitDefnNode(iVisited);
        int end = iVisited.getPosition().getEndOffset() - 2;
        if (methodInfo.isConstructor) {
            this.requestor.exitConstructor(end);
        } else {
            this.requestor.exitMethod(end);
        }
        return ins;
    }

    public Instruction visitArgsNode(ArgsNode iVisited) {
        ArgumentNode arg;
        ListNode list = iVisited.getArgs();
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                Node arg2 = list.get(i);
                ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
                field.declarationStart = arg2.getPosition().getStartOffset();
                field.nameSourceStart = arg2.getPosition().getStartOffset();
                String name = ASTUtil.getNameReflectively(arg2);
                field.nameSourceEnd = arg2.getPosition().getStartOffset() + name.length() - 1;
                field.name = name;
                this.requestor.enterField(field);
                this.requestor.exitField(arg2.getPosition().getEndOffset() - 1);
                ++i;
            }
        }
        if ((arg = iVisited.getRestArgNode()) != null) {
            ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
            field.declarationStart = arg.getPosition().getStartOffset() + 1;
            field.nameSourceStart = arg.getPosition().getStartOffset() + 1;
            String name = ASTUtil.getNameReflectively((Node)arg);
            field.nameSourceEnd = arg.getPosition().getStartOffset() + name.length();
            field.name = name;
            this.requestor.enterField(field);
            this.requestor.exitField(arg.getPosition().getEndOffset());
        }
        return super.visitArgsNode(iVisited);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
        methodInfo.declarationStart = iVisited.getPosition().getStartOffset();
        methodInfo.name = iVisited.getName();
        methodInfo.nameSourceStart = iVisited.getNameNode().getPosition().getStartOffset();
        methodInfo.nameSourceEnd = iVisited.getNameNode().getPosition().getEndOffset() - 1;
        methodInfo.isConstructor = false;
        methodInfo.isClassLevel = true;
        methodInfo.visibility = this.convertVisibility(this.getCurrentVisibility());
        methodInfo.parameterNames = ASTUtil.getArgs((Node)iVisited.getArgsNode(), iVisited.getScope());
        this.requestor.enterMethod(methodInfo);
        Instruction ins = super.visitDefsNode(iVisited);
        this.requestor.exitMethod(iVisited.getPosition().getEndOffset() - 2);
        return ins;
    }

    private int convertVisibility(Visibility visibility) {
        if (visibility == Visibility.PUBLIC) {
            return 1;
        }
        if (visibility == Visibility.PROTECTED) {
            return 4;
        }
        return 2;
    }

    public Instruction visitRootNode(RootNode iVisited) {
        this.requestor.enterScript();
        this.pushVisibility(Visibility.PUBLIC);
        Instruction ins = super.visitRootNode(iVisited);
        this.popVisibility();
        this.requestor.exitScript(iVisited.getPosition().getEndOffset());
        return ins;
    }

    private void popVisibility() {
        this.visibilities.remove(this.visibilities.size() - 1);
    }

    public Instruction visitConstDeclNode(ConstDeclNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitConstDeclNode(iVisited);
    }

    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitClassVarAsgnNode(iVisited);
    }

    public Instruction visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitClassVarDeclNode(iVisited);
    }

    public Instruction visitClassVarNode(ClassVarNode iVisited) {
        this.requestor.acceptFieldReference(iVisited.getName(), iVisited.getPosition().getStartOffset());
        return super.visitClassVarNode(iVisited);
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitLocalAsgnNode(iVisited);
    }

    public Instruction visitInstAsgnNode(InstAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitInstAsgnNode(iVisited);
    }

    public Instruction visitInstVarNode(InstVarNode iVisited) {
        this.requestor.acceptFieldReference(iVisited.getName(), iVisited.getPosition().getStartOffset());
        return super.visitInstVarNode(iVisited);
    }

    public Instruction visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitGlobalAsgnNode(iVisited);
    }

    public Instruction visitGlobalVarNode(GlobalVarNode iVisited) {
        this.requestor.acceptFieldReference(iVisited.getName(), iVisited.getPosition().getStartOffset());
        return super.visitGlobalVarNode(iVisited);
    }

    private void exitField(AssignableNode iVisited) {
        this.requestor.exitField(iVisited.getPosition().getEndOffset() - 1);
    }

    private ISourceElementRequestor.FieldInfo createFieldInfo(AssignableNode iVisited) {
        ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
        field.declarationStart = iVisited.getPosition().getStartOffset();
        field.nameSourceStart = iVisited.getPosition().getStartOffset();
        String name = ASTUtil.getNameReflectively((Node)iVisited);
        field.nameSourceEnd = iVisited.getPosition().getStartOffset() + name.length() - 1;
        return field;
    }

    public Instruction visitIterNode(IterNode iVisited) {
        this.requestor.acceptBlock(iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset() - 1);
        return super.visitIterNode(iVisited);
    }

    public Instruction visitDAsgnNode(DAsgnNode iVisited) {
        ISourceElementRequestor.FieldInfo field = this.createFieldInfo((AssignableNode)iVisited);
        field.name = iVisited.getName();
        field.isDynamic = true;
        this.requestor.enterField(field);
        this.exitField((AssignableNode)iVisited);
        return super.visitDAsgnNode(iVisited);
    }

    public Instruction visitSClassNode(SClassNode iVisited) {
        Node receiver = iVisited.getReceiverNode();
        if (receiver instanceof SelfNode) {
            this.inSingletonClass = true;
        }
        this.pushVisibility(Visibility.PUBLIC);
        Instruction ins = super.visitSClassNode(iVisited);
        this.popVisibility();
        if (receiver instanceof SelfNode) {
            this.inSingletonClass = false;
        }
        return ins;
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        List<Node> nodes;
        String name = iVisited.getName();
        List<String> arguments = this.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
        if (name.equals(REQUIRE) || name.equals(LOAD)) {
            this.addImport(iVisited);
        } else if (name.equals(INCLUDE)) {
            this.includeModule(iVisited);
        }
        if (name.equals(PUBLIC)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, this.convertVisibility(Visibility.PUBLIC));
            }
        } else if (name.equals(PRIVATE)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, this.convertVisibility(Visibility.PRIVATE));
            }
        } else if (name.equals(PROTECTED)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, this.convertVisibility(Visibility.PROTECTED));
            }
        } else if (name.equals(MODULE_FUNCTION)) {
            for (String methodName : arguments) {
                this.requestor.acceptModuleFunction(methodName);
            }
        }
        if (name.equals("alias_method")) {
            String newName = arguments.get(0).substring(1);
            int nameStart = iVisited.getPosition().getStartOffset() + "alias_method :".length();
            this.addAliasMethod(newName, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset(), nameStart);
        }
        if (name.equals("attr")) {
            nodes = ASTUtil.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            this.generateReadMethod(arguments.get(0), nodes.get(0));
            if (arguments.size() == 2 && arguments.get(1).equals("true")) {
                Node node = nodes.get(0);
                int start = node.getPosition().getEndOffset() + 2;
                this.generateWriteMethod(arguments.get(0), start, start + arguments.get(1).length() - 1);
            }
        }
        if (name.equals("attr_reader") || name.equals("attr_accessor")) {
            nodes = ASTUtil.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            int i = 0;
            while (i < arguments.size()) {
                this.generateReadMethod(arguments.get(i), nodes.get(i));
                ++i;
            }
        }
        if (name.equals("attr_writer") || name.equals("attr_accessor")) {
            nodes = ASTUtil.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            int i = 0;
            while (i < arguments.size()) {
                this.generateWriteMethod(arguments.get(i), nodes.get(i));
                ++i;
            }
        }
        if (name.equals("attr") || name.equals("attr_accessor") || name.equals("attr_reader") || name.equals("attr_writer")) {
            nodes = ASTUtil.getArgumentNodesFromFunctionCall((IArgumentNode)iVisited);
            int i = 0;
            while (i < arguments.size()) {
                ISourceElementRequestor.FieldInfo field = new ISourceElementRequestor.FieldInfo();
                Node node = nodes.get(i);
                field.declarationStart = node.getPosition().getStartOffset() + 1;
                field.name = "@" + arguments.get(i);
                field.nameSourceStart = node.getPosition().getStartOffset() + 1;
                field.nameSourceEnd = node.getPosition().getEndOffset() - 1;
                this.requestor.enterField(field);
                this.requestor.exitField(node.getPosition().getEndOffset() - 1);
                ++i;
            }
        }
        this.requestor.acceptMethodReference(name, arguments.size(), iVisited.getPosition().getStartOffset());
        return super.visitFCallNode(iVisited);
    }

    private void addAliasMethod(String name, int start, int end, int nameStart) {
        ISourceElementRequestor.MethodInfo method = new ISourceElementRequestor.MethodInfo();
        Visibility visibility = this.getCurrentVisibility();
        if (name.equals(CONSTRUCTOR_NAME)) {
            visibility = Visibility.PROTECTED;
            method.isConstructor = true;
        } else {
            method.isConstructor = false;
        }
        method.declarationStart = start;
        method.isClassLevel = this.inSingletonClass;
        method.name = name;
        method.visibility = this.convertVisibility(visibility);
        method.nameSourceStart = nameStart;
        method.nameSourceEnd = nameStart + name.length() - 1;
        method.parameterNames = new String[0];
        this.requestor.enterMethod(method);
        this.requestor.exitMethod(end);
    }

    private void generateWriteMethod(String argument, Node node) {
        this.generateWriteMethod(argument, node.getPosition().getStartOffset(), node.getPosition().getEndOffset() - 1);
    }

    private void generateWriteMethod(String argument, int start, int end) {
        if (argument.startsWith(":")) {
            argument = argument.substring(1);
        }
        ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
        info.declarationStart = start;
        info.isClassLevel = false;
        info.isConstructor = false;
        info.name = String.valueOf(argument) + "=";
        info.nameSourceStart = start;
        info.nameSourceEnd = end;
        info.visibility = 1;
        info.parameterNames = new String[]{"new_value"};
        this.requestor.enterMethod(info);
        this.requestor.exitMethod(end);
    }

    private void generateReadMethod(String argument, Node node) {
        if (argument.startsWith(":")) {
            argument = argument.substring(1);
        }
        ISourceElementRequestor.MethodInfo info = new ISourceElementRequestor.MethodInfo();
        info.declarationStart = node.getPosition().getStartOffset();
        info.isClassLevel = false;
        info.isConstructor = false;
        info.name = argument;
        info.nameSourceStart = node.getPosition().getStartOffset();
        info.nameSourceEnd = node.getPosition().getEndOffset() - 1;
        info.visibility = 1;
        info.parameterNames = new String[0];
        this.requestor.enterMethod(info);
        this.requestor.exitMethod(node.getPosition().getEndOffset() - 1);
    }

    private void addImport(FCallNode iVisited) {
        ArrayNode node = (ArrayNode)iVisited.getArgsNode();
        String arg = this.getString(node);
        if (arg != null) {
            this.requestor.acceptImport(arg, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset());
        }
    }

    private String getString(ArrayNode node) {
        Object tmp = node.childNodes().iterator().next();
        if (tmp instanceof DStrNode) {
            DStrNode dstrNode = (DStrNode)tmp;
            tmp = dstrNode.childNodes().iterator().next();
        }
        if (tmp instanceof StrNode) {
            StrNode strNode = (StrNode)tmp;
            return strNode.getValue().toString();
        }
        return null;
    }

    private void includeModule(FCallNode iVisited) {
        LinkedList<String> mixins = new LinkedList<String>();
        Node argsNode = iVisited.getArgsNode();
        Iterator iter = null;
        if (argsNode instanceof SplatNode) {
            SplatNode splat = (SplatNode)argsNode;
            iter = splat.childNodes().iterator();
        } else if (argsNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)iVisited.getArgsNode();
            iter = arrayNode.childNodes().iterator();
        }
        while (iter.hasNext()) {
            Node next;
            Node mixinNameNode = (Node)iter.next();
            if (mixinNameNode instanceof StrNode) {
                mixins.add(((StrNode)mixinNameNode).getValue().toString());
            }
            if (mixinNameNode instanceof DStrNode && (next = (Node)((DStrNode)mixinNameNode).childNodes().iterator().next()) instanceof StrNode) {
                mixins.add(((StrNode)next).getValue().toString());
            }
            if (mixinNameNode instanceof ConstNode) {
                mixins.add(((ConstNode)mixinNameNode).getName());
            }
            if (!(mixinNameNode instanceof Colon2Node)) continue;
            mixins.add(ASTUtil.getFullyQualifiedName((Colon2Node)mixinNameNode));
        }
        for (String string : mixins) {
            this.requestor.acceptMixin(string);
        }
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        String functionName = iVisited.getName();
        if (functionName.equals(PUBLIC)) {
            this.setVisibility(Visibility.PUBLIC);
        } else if (functionName.equals(PRIVATE)) {
            this.setVisibility(Visibility.PRIVATE);
        } else if (functionName.equals(PROTECTED)) {
            this.setVisibility(Visibility.PROTECTED);
        } else if (functionName.equals(MODULE_FUNCTION)) {
            this.inModuleFunction = true;
        }
        this.requestor.acceptMethodReference(functionName, 0, iVisited.getPosition().getStartOffset());
        return super.visitVCallNode(iVisited);
    }

    private void setVisibility(Visibility visibility) {
        this.popVisibility();
        this.pushVisibility(visibility);
    }

    private void pushVisibility(Visibility visibility) {
        this.visibilities.add(visibility);
    }

    public Instruction visitCallNode(CallNode iVisited) {
        Node receiver;
        String name = iVisited.getName();
        List<String> arguments = this.getArgumentsFromFunctionCall((IArgumentNode)iVisited);
        if (name.equals(PUBLIC)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, this.convertVisibility(Visibility.PUBLIC));
            }
        } else if (name.equals(PRIVATE)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, this.convertVisibility(Visibility.PRIVATE));
            }
        } else if (name.equals(PROTECTED)) {
            for (String methodName : arguments) {
                this.requestor.acceptMethodVisibilityChange(methodName, this.convertVisibility(Visibility.PROTECTED));
            }
        } else if (name.equals(MODULE_FUNCTION)) {
            for (String methodName : arguments) {
                this.requestor.acceptModuleFunction(methodName);
            }
        } else if (name.equals("class_eval") && ((receiver = iVisited.getReceiverNode()) instanceof ConstNode || receiver instanceof Colon2Node)) {
            String receiverName = null;
            receiverName = receiver instanceof Colon2Node ? ASTUtil.getFullyQualifiedName((Colon2Node)receiver) : ASTUtil.getNameReflectively(receiver);
            this.requestor.acceptMethodReference(name, arguments.size(), iVisited.getPosition().getStartOffset());
            this.pushVisibility(Visibility.PUBLIC);
            ISourceElementRequestor.TypeInfo typeInfo = new ISourceElementRequestor.TypeInfo();
            typeInfo.name = receiverName;
            typeInfo.declarationStart = iVisited.getPosition().getStartOffset();
            typeInfo.nameSourceStart = receiver.getPosition().getStartOffset();
            typeInfo.nameSourceEnd = receiver.getPosition().getEndOffset() - 1;
            typeInfo.isModule = false;
            typeInfo.modules = new String[0];
            typeInfo.secondary = false;
            this.requestor.enterType(typeInfo);
            Instruction ins = super.visitCallNode(iVisited);
            this.popVisibility();
            this.requestor.exitType(iVisited.getPosition().getEndOffset() - 2);
            return ins;
        }
        this.requestor.acceptMethodReference(name, arguments.size(), iVisited.getPosition().getStartOffset());
        return super.visitCallNode(iVisited);
    }

    public Instruction visitAliasNode(AliasNode iVisited) {
        String name = iVisited.getNewName();
        int nameStart = iVisited.getPosition().getStartOffset() + ALIAS.length() - 1;
        this.addAliasMethod(name, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset(), nameStart);
        return super.visitAliasNode(iVisited);
    }

    private Visibility getCurrentVisibility() {
        return this.visibilities.get(this.visibilities.size() - 1);
    }

    public void parse(char[] source, char[] name) {
        RubyParser p = new RubyParser();
        this.source = source;
        if (name == null) {
            name = new char[]{};
        }
        Node ast = p.parse(new String(name), new String(source)).getAST();
        this.acceptNode(ast);
    }

    public Instruction visitYieldNode(YieldNode iVisited) {
        Node argsNode = iVisited.getArgsNode();
        if (argsNode instanceof LocalVarNode) {
            this.requestor.acceptYield(((LocalVarNode)argsNode).getName());
        } else if (argsNode instanceof SelfNode) {
            String name = null;
            if (this.typeName == null) {
                name = "var";
            } else {
                name = this.typeName.toLowerCase();
                if (name.indexOf("::") > -1) {
                    name = name.substring(name.lastIndexOf("::") + 2);
                }
            }
            this.requestor.acceptYield(name);
        }
        return super.visitYieldNode(iVisited);
    }
}

