/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyModelStatusConstants;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.util.Messages;

public class RubyModelStatus
extends Status
implements IRubyModelStatus,
IRubyModelStatusConstants,
IResourceStatus {
    protected IRubyElement[] elements = new IRubyElement[0];
    protected IPath path;
    protected String string;
    protected static final IStatus[] NO_CHILDREN = new IStatus[0];
    protected IStatus[] children = NO_CHILDREN;
    public static final IRubyModelStatus VERIFIED_OK = new RubyModelStatus(0, 0, Messages.bind(Messages.status_OK));

    public RubyModelStatus() {
        super(4, "org.rubypeople.rdt.core", 0, "RubyModelStatus", null);
    }

    public RubyModelStatus(int code) {
        super(4, "org.rubypeople.rdt.core", code, "RubyModelStatus", null);
        this.elements = RubyElement.NO_ELEMENTS;
    }

    public RubyModelStatus(int code, IRubyElement[] elements) {
        super(4, "org.rubypeople.rdt.core", code, "RubyModelStatus", null);
        this.elements = elements;
        this.path = null;
    }

    public RubyModelStatus(int code, String string) {
        this(4, code, string);
    }

    public RubyModelStatus(int severity, int code, String string) {
        super(severity, "org.rubypeople.rdt.core", code, "RubyModelStatus", null);
        this.elements = RubyElement.NO_ELEMENTS;
        this.path = null;
        this.string = string;
    }

    public RubyModelStatus(int code, Throwable throwable) {
        super(4, "org.rubypeople.rdt.core", code, "RubyModelStatus", throwable);
        this.elements = RubyElement.NO_ELEMENTS;
    }

    public RubyModelStatus(int code, IPath path) {
        super(4, "org.rubypeople.rdt.core", code, "RubyModelStatus", null);
        this.elements = RubyElement.NO_ELEMENTS;
        this.path = path;
    }

    public RubyModelStatus(int code, IRubyElement element) {
        this(code, new IRubyElement[]{element});
    }

    public RubyModelStatus(int code, IRubyElement element, String string) {
        this(code, new IRubyElement[]{element});
        this.string = string;
    }

    public RubyModelStatus(int code, IRubyElement element, IPath path) {
        this(code, new IRubyElement[]{element});
        this.path = path;
    }

    public RubyModelStatus(int code, IRubyElement element, IPath path, String string) {
        this(code, new IRubyElement[]{element});
        this.path = path;
        this.string = string;
    }

    public RubyModelStatus(CoreException coreException) {
        super(4, "org.rubypeople.rdt.core", 966, "RubyModelStatus", (Throwable)coreException);
        this.elements = RubyElement.NO_ELEMENTS;
    }

    protected int getBits() {
        int severity = 1 << this.getCode() % 100 / 33;
        int category = 1 << this.getCode() / 100 + 3;
        return severity | category;
    }

    public IStatus[] getChildren() {
        return this.children;
    }

    public IRubyElement[] getElements() {
        return this.elements;
    }

    public String getMessage() {
        Throwable exception = this.getException();
        if (exception == null) {
            switch (this.getCode()) {
                case 966: {
                    return Messages.bind(Messages.status_coreException);
                }
                case 990: {
                    return Messages.bind(Messages.build_initializationError);
                }
                case 991: {
                    return Messages.bind(Messages.build_serializationError);
                }
                case 973: {
                    return Messages.bind(Messages.status_cannotUseDeviceOnPath, this.getPath().toString());
                }
                case 986: {
                    return Messages.bind(Messages.status_JDOMError);
                }
                case 969: {
                    return Messages.bind(Messages.element_doesNotExist, ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 1006: {
                    return Messages.bind(Messages.element_notOnClasspath, ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 992: {
                    return Messages.bind(Messages.status_evaluationError, this.string);
                }
                case 980: {
                    return Messages.bind(Messages.status_indexOutOfBounds);
                }
                case 984: {
                    return Messages.bind(Messages.status_invalidContents);
                }
                case 978: {
                    return Messages.bind(Messages.status_invalidDestination, ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 967: {
                    StringBuffer buff = new StringBuffer(Messages.bind(Messages.operation_notSupported));
                    int i = 0;
                    while (i < this.elements.length) {
                        if (i > 0) {
                            buff.append(", ");
                        }
                        buff.append(((RubyElement)this.elements[i]).toStringWithAncestors());
                        ++i;
                    }
                    return buff.toString();
                }
                case 983: {
                    return Messages.bind(Messages.status_invalidName, this.string);
                }
                case 998: {
                    return Messages.bind(Messages.status_invalidPackage, this.string);
                }
                case 979: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Messages.bind(Messages.status_invalidPath, this.getPath() == null ? "null" : this.getPath().toString());
                }
                case 997: {
                    return Messages.bind(Messages.status_invalidProject, this.string);
                }
                case 995: {
                    return Messages.bind(Messages.status_invalidResource, this.string);
                }
                case 996: {
                    return Messages.bind(Messages.status_invalidResourceType, this.string);
                }
                case 993: {
                    if (this.string != null) {
                        return Messages.bind(Messages.status_invalidSibling, this.string);
                    }
                    return Messages.bind(Messages.status_invalidSibling, ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 985: {
                    return Messages.bind(Messages.status_IOException);
                }
                case 977: {
                    if (this.string != null) {
                        return this.string;
                    }
                    return Messages.bind(Messages.status_nameCollision, "");
                }
                case 968: {
                    return Messages.bind(Messages.operation_needElements);
                }
                case 982: {
                    return Messages.bind(Messages.operation_needName);
                }
                case 970: {
                    return Messages.bind(Messages.operation_needPath);
                }
                case 974: {
                    return Messages.bind(Messages.operation_needString);
                }
                case 971: {
                    return Messages.bind(Messages.operation_pathOutsideProject, this.string, ((RubyElement)this.elements[0]).toStringWithAncestors());
                }
                case 976: {
                    IRubyElement element = this.elements[0];
                    String name = element.getElementName();
                    return Messages.bind(Messages.status_readOnly, name);
                }
                case 972: {
                    return Messages.bind(Messages.operation_needAbsolutePath, this.getPath().toString());
                }
                case 987: {
                    return Messages.bind(Messages.status_targetException);
                }
                case 981: {
                    return Messages.bind(Messages.status_updateConflict);
                }
                case 999: {
                    return Messages.bind(Messages.status_noLocalContents, this.getPath().toString());
                }
                case 965: {
                    IRubyProject javaProject = (IRubyProject)this.elements[0];
                    return Messages.bind(Messages.classpath_unboundVariablePath, this.path.makeRelative().toString(), javaProject.getElementName());
                }
                case 1001: {
                    IRubyProject javaProject = (IRubyProject)this.elements[0];
                    return Messages.bind(Messages.classpath_cycle, javaProject.getElementName());
                }
                case 1002: {
                    IRubyProject javaProject = (IRubyProject)this.elements[0];
                    String projectName = javaProject.getElementName();
                    IPath newPath = this.path;
                    if (this.path.segment(0).toString().equals(projectName)) {
                        newPath = this.path.removeFirstSegments(1);
                    }
                    return Messages.bind(Messages.classpath_disabledInclusionExclusionPatterns, newPath.makeRelative().toString(), projectName);
                }
                case 1003: {
                    IRubyProject javaProject = (IRubyProject)this.elements[0];
                    String projectName = javaProject.getElementName();
                    IPath newPath = this.path;
                    if (this.path.segment(0).toString().equals(projectName)) {
                        newPath = this.path.removeFirstSegments(1);
                    }
                    return Messages.bind(Messages.classpath_disabledMultipleOutputLocations, newPath.makeRelative().toString(), projectName);
                }
                case 1007: {
                    IRubyProject javaProject = (IRubyProject)this.elements[0];
                    String projectName = javaProject.getElementName();
                    return Messages.bind(Messages.project_has_no_ruby_nature, projectName);
                }
            }
            if (this.string != null) {
                return this.string;
            }
            return "";
        }
        String message = exception.getMessage();
        if (message != null) {
            return message;
        }
        return exception.toString();
    }

    public IPath getPath() {
        return this.path;
    }

    public int getSeverity() {
        if (this.children == NO_CHILDREN) {
            return super.getSeverity();
        }
        int severity = -1;
        int i = 0;
        int max = this.children.length;
        while (i < max) {
            int childrenSeverity = this.children[i].getSeverity();
            if (childrenSeverity > severity) {
                severity = childrenSeverity;
            }
            ++i;
        }
        return severity;
    }

    public String getString() {
        return this.string;
    }

    public boolean isDoesNotExist() {
        int code = this.getCode();
        return code == 969 || code == 1006;
    }

    public boolean isMultiStatus() {
        return this.children != NO_CHILDREN;
    }

    public boolean isOK() {
        return this.getCode() == 0;
    }

    public boolean matches(int mask) {
        if (!this.isMultiStatus()) {
            return this.matches(this, mask);
        }
        int i = 0;
        int max = this.children.length;
        while (i < max) {
            if (this.matches((RubyModelStatus)this.children[i], mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matches(RubyModelStatus status, int mask) {
        int severityMask = mask & 7;
        int categoryMask = mask & 0xFFFFFFF8;
        int bits = status.getBits();
        return !(severityMask != 0 && (bits & severityMask) == 0 || categoryMask != 0 && (bits & categoryMask) == 0);
    }

    public static IRubyModelStatus newMultiStatus(IRubyModelStatus[] children) {
        RubyModelStatus jms = new RubyModelStatus();
        jms.children = children;
        return jms;
    }

    public String toString() {
        if (this == VERIFIED_OK) {
            return "RubyModelStatus[OK]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Ruby Model Status [");
        buffer.append(this.getMessage());
        buffer.append("]");
        return buffer.toString();
    }
}

