/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.rubypeople.rdt.core.ILoadpathAttribute;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.compiler.CompilationParticipant;
import org.rubypeople.rdt.core.compiler.IProblem;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.compiler.util.HashtableOfObjectToInt;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.DeltaProcessingState;
import org.rubypeople.rdt.internal.core.DeltaProcessor;
import org.rubypeople.rdt.internal.core.LoadpathAttribute;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.ReconcileWorkingCopyOperation;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelCache;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.SetLoadpathOperation;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;
import org.rubypeople.rdt.internal.core.builder.RubyBuilder;
import org.rubypeople.rdt.internal.core.hierarchy.TypeHierarchy;
import org.rubypeople.rdt.internal.core.parser.MarkerUtility;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.search.AbstractSearchScope;
import org.rubypeople.rdt.internal.core.search.RubyWorkspaceScope;
import org.rubypeople.rdt.internal.core.search.indexing.IndexManager;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;
import org.rubypeople.rdt.internal.core.util.WeakHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyModelManager
implements IContentTypeManager.IContentTypeChangeListener,
ISaveParticipant {
    private static final String BUFFER_MANAGER_DEBUG = "org.rubypeople.rdt.core/debug/buffermanager";
    private static final String TYPE_HIERARCHY_DEBUG = "org.rubypeople.rdt.core/debug/typehierarchy";
    private static final String RUBYMODEL_DEBUG = "org.rubypeople.rdt.core/debug/rubymodel";
    private static final String DELTA_DEBUG = "org.rubypeople.rdt.core/debug/rubydelta";
    private static final String DELTA_DEBUG_VERBOSE = "org.rubypeople.rdt.core/debug/rubydelta/verbose";
    private static final String POST_ACTION_DEBUG = "org.rubypeople.rdt.core/debug/postaction";
    private static final String BUILDER_DEBUG = "org.rubypeople.rdt.core/debug/builder";
    private static final String RUBY_PARSER_DEBUG_OPTION = "org.rubypeople.rdt.core/rubyparser";
    private static final String MODEL_MANAGER_VERBOSE_OPTION = "org.rubypeople.rdt.core/modelmanager";
    private static final String BUILDER_VERBOSE_OPTION = "org.rubypeople.rdt.core/rubyBuilder";
    private static final String ENABLE_NEW_FORMATTER = "org.rubypeople.rdt.core/formatter/enable_new";
    public static final String DELTA_LISTENER_PERF = "org.rubypeople.rdt.core/perf/rubydeltalistener";
    public static final String RECONCILE_PERF = "org.rubypeople.rdt.core/perf/reconcile";
    private static final String INDEXED_SECONDARY_TYPES = "#@*_indexing secondary cache_*@#";
    public static final String CPVARIABLE_INITIALIZER_EXTPOINT_ID = "loadpathVariableInitializer";
    public static final String CPCONTAINER_INITIALIZER_EXTPOINT_ID = "loadpathContainerInitializer";
    public HashMap<String, IPath[]> variables = new HashMap(5);
    public HashSet<String> variablesWithInitializer = new HashSet(5);
    public HashMap<String, IPath[]> previousSessionVariables = new HashMap(5);
    private ThreadLocal<HashSet<String>> variableInitializationInProgress = new ThreadLocal();
    public HashMap<IRubyProject, Map> containers = new HashMap(5);
    public HashMap previousSessionContainers = new HashMap(5);
    private ThreadLocal<Map> containerInitializationInProgress = new ThreadLocal();
    public boolean batchContainerInitializations = false;
    public HashMap<String, LoadpathContainerInitializer> containerInitializersCache = new HashMap(5);
    private static final RubyModelManager MANAGER = new RubyModelManager();
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    public IndexManager indexManager = null;
    final RubyModel rubyModel = new RubyModel();
    private ThreadLocal<HashMap> temporaryCache = new ThreadLocal();
    protected HashSet elementsOutOfSynchWithBuffers = new HashSet(11);
    private ThreadLocal<HashSet<IRubyProject>> classpathsBeingResolved = new ThreadLocal();
    public RubyWorkspaceScope workspaceScope;
    protected RubyModelCache cache = new RubyModelCache();
    protected Map<IProject, PerProjectInfo> perProjectInfos = new HashMap<IProject, PerProjectInfo>(5);
    protected Map<WorkingCopyOwner, Map> perWorkingCopyInfos = new HashMap<WorkingCopyOwner, Map>(5);
    protected WeakHashMap searchScopes = new WeakHashMap();
    public static boolean CP_RESOLVE_VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    public static boolean VERBOSE = false;
    HashSet<String> optionNames = new HashSet(20);
    Hashtable<String, String> optionsCache;
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    private WeakHashSet stringSymbols = new WeakHashSet(5);
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    public static final IRubyScript[] NO_WORKING_COPY = new IRubyScript[0];
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = "org.rubypeople.rdt.core.loadpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = "org.rubypeople.rdt.core.loadpathContainer.";
    public static final IPath[] VARIABLE_INITIALIZATION_IN_PROGRESS = new Path[]{new Path("Variable Initialization In Progress")};
    public static final ILoadpathContainer CONTAINER_INITIALIZATION_IN_PROGRESS = new ILoadpathContainer(){

        public ILoadpathEntry[] getLoadpathEntries() {
            return null;
        }

        public String getDescription() {
            return "Container Initialization In Progress";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return null;
        }

        public String toString() {
            return this.getDescription();
        }
    };
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static final IPath[] CP_ENTRY_IGNORE_PATH = new Path[]{new Path("##<cp entry ignore>##")};
    private static final int VARIABLES_AND_CONTAINERS_FILE_VERSION = 2;
    public static boolean PERF_VARIABLE_INITIALIZER = false;
    public static boolean PERF_CONTAINER_INITIALIZER = false;
    private static final Object[] NO_PARTICIPANTS = new Object[0];
    public static final String COMPILATION_PARTICIPANT_EXTPOINT_ID = "compilationParticipant";
    public final CompilationParticipants compilationParticipants = new CompilationParticipants();

    private RubyModelManager() {
        if (Platform.isRunning()) {
            this.indexManager = new IndexManager();
        }
    }

    public static final RubyModelManager getRubyModelManager() {
        return MANAGER;
    }

    public void initializePreferences() {
        this.preferencesLookup[0] = new InstanceScope().getNode("org.rubypeople.rdt.core");
        this.preferencesLookup[1] = new DefaultScope().getNode("org.rubypeople.rdt.core");
        Object listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == RubyModelManager.this.preferencesLookup[0]) {
                    RubyModelManager.this.preferencesLookup[0] = new InstanceScope().getNode("org.rubypeople.rdt.core");
                    RubyModelManager.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(listener);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
        listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == RubyModelManager.this.preferencesLookup[1]) {
                    RubyModelManager.this.preferencesLookup[1] = new DefaultScope().getNode("org.rubypeople.rdt.core");
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(listener);
    }

    public synchronized Object getInfo(IRubyElement element) {
        Object result;
        HashMap tempCache = this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.getInfo(element);
    }

    public void rememberScope(AbstractSearchScope scope) {
        this.searchScopes.put(scope, null);
    }

    public synchronized Object removeInfoAndChildren(RubyElement element) throws RubyModelException {
        Object info = this.cache.peekAtInfo(element);
        if (info != null) {
            element.closing(info);
            if (element instanceof IParent && info instanceof RubyElementInfo) {
                IRubyElement[] children = ((RubyElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    RubyElement child = (RubyElement)children[i];
                    child.close();
                    ++i;
                }
            }
            this.cache.removeInfo(element);
            return info;
        }
        return null;
    }

    protected synchronized Object peekAtInfo(IRubyElement element) {
        Object result;
        HashMap tempCache = this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.peekAtInfo(element);
    }

    protected synchronized void putInfos(IRubyElement openedElement, Map newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof RubyElementInfo) {
            IRubyElement[] children = ((RubyElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                RubyElement child = (RubyElement)children[i];
                try {
                    child.close();
                }
                catch (RubyModelException rubyModelException) {}
                ++i;
            }
        }
        for (IRubyElement element : newElements.keySet()) {
            Object info = newElements.get(element);
            this.cache.putInfo(element, info);
        }
    }

    public HashMap getTemporaryCache() {
        HashMap result = this.temporaryCache.get();
        if (result == null) {
            result = new HashMap();
            this.temporaryCache.set(result);
        }
        return result;
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectOptions(RubyProject rubyProject) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            IProject project = rubyProject.getProject();
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info != null) {
                info.options = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectPreferences(RubyProject rubyProject) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            IProject project = rubyProject.getProject();
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info != null) {
                info.preferences = null;
            }
        }
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public final RubyModel getRubyModel() {
        return this.rubyModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerWorkingCopyInfo getPerWorkingCopyInfo(RubyScript workingCopy, boolean create, boolean recordUsage, IProblemRequestor problemRequestor) {
        Map<WorkingCopyOwner, Map> map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info;
            WorkingCopyOwner owner = workingCopy.owner;
            HashMap<RubyScript, PerWorkingCopyInfo> workingCopyToInfos = this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null && create) {
                workingCopyToInfos = new HashMap<RubyScript, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(owner, workingCopyToInfos);
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info = workingCopyToInfos == null ? null : (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy, problemRequestor);
                workingCopyToInfos.put(workingCopy, info);
            }
            if (info != null && recordUsage) {
                ++info.useCount;
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discardPerWorkingCopyInfo(RubyScript workingCopy) throws RubyModelException {
        PerWorkingCopyInfo info = null;
        Map<WorkingCopyOwner, Map> map = this.perWorkingCopyInfos;
        synchronized (map) {
            Map workingCopyToInfos;
            WorkingCopyOwner owner;
            block9: {
                block8: {
                    owner = workingCopy.owner;
                    workingCopyToInfos = this.perWorkingCopyInfos.get(owner);
                    if (workingCopyToInfos != null) break block8;
                    return -1;
                }
                info = (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
                if (info != null) break block9;
                return -1;
            }
            if (--info.useCount == 0) {
                workingCopyToInfos.remove(workingCopy);
                if (workingCopyToInfos.isEmpty()) {
                    this.perWorkingCopyInfos.remove(owner);
                }
            }
        }
        if (info.useCount == 0) {
            this.removeInfoAndChildren(workingCopy);
            workingCopy.closeBuffer();
        }
        return info.useCount;
    }

    protected HashSet getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfos.put(project, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(RubyProject rubyProject) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            IProject project = rubyProject.getProject();
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info != null) {
                this.perProjectInfos.remove(project);
            }
        }
    }

    public boolean isLoadpathBeingResolved(IRubyProject project) {
        return this.getLoadpathBeingResolved().contains(project);
    }

    private HashSet<IRubyProject> getLoadpathBeingResolved() {
        HashSet<IRubyProject> result = this.classpathsBeingResolved.get();
        if (result == null) {
            result = new HashSet();
            this.classpathsBeingResolved.set(result);
        }
        return result;
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws RubyModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!RubyProject.hasRubyNature(project)) {
                throw ((RubyProject)RubyCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    public void setLoadpathBeingResolved(IRubyProject project, boolean classpathIsResolved) {
        if (classpathIsResolved) {
            this.getLoadpathBeingResolved().add(project);
        } else {
            this.getLoadpathBeingResolved().remove(project);
        }
    }

    public String getOption(String optionName) {
        if ("org.rubypeople.rdt.core.encoding".equals(optionName)) {
            return RubyCore.getEncoding();
        }
        String propertyName = optionName;
        if (this.optionNames.contains(propertyName)) {
            IPreferencesService service = Platform.getPreferencesService();
            String value = service.get(optionName, null, (Preferences[])this.preferencesLookup);
            return value == null ? null : value.trim();
        }
        return null;
    }

    public Hashtable<String, String> getOptions() {
        if (this.optionsCache != null) {
            return new Hashtable<String, String>(this.optionsCache);
        }
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        IPreferencesService service = Platform.getPreferencesService();
        for (String propertyName : this.optionNames) {
            String propertyValue = service.get(propertyName, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(propertyName, propertyValue);
        }
        options.put("org.rubypeople.rdt.core.encoding", RubyCore.getEncoding());
        this.optionsCache = new Hashtable(options);
        return options;
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    public void startup() throws CoreException {
        try {
            this.configurePluginDebugOptions();
            this.cache = new RubyModelCache();
            RubyCore.getPlugin().getStateLocation();
            this.initializePreferences();
            Preferences.IPropertyChangeListener propertyListener = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    RubyModelManager.this.optionsCache = null;
                }
            };
            RubyCore.getPlugin().getPluginPreferences().addPropertyChangeListener(propertyListener);
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
            Job job = new Job("Loading variables and containers"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        long start = -1L;
                        if (VERBOSE) {
                            start = System.currentTimeMillis();
                        }
                        RubyModelManager.this.loadVariablesAndContainers();
                        if (VERBOSE) {
                            RubyModelManager.this.traceVariableAndContainers("Loaded", start);
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(20);
            job.schedule();
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.deltaState, 31);
            job = new Job("Start Ruby Indexing"){

                protected IStatus run(IProgressMonitor monitor) {
                    RubyModelManager.this.startIndexing();
                    Job processSavedState = new Job(Messages.savedState_jobName){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                workspace.run(new IWorkspaceRunnable(){

                                    public void run(IProgressMonitor progress) throws CoreException {
                                        ISavedState savedState = workspace.addSaveParticipant((Plugin)RubyCore.getRubyCore(), (ISaveParticipant)RubyModelManager.this);
                                        if (savedState != null) {
                                            ((this).this).RubyModelManager.this.deltaState.getDeltaProcessor().overridenEventType = 1;
                                            savedState.processResourceChangeEvents((IResourceChangeListener)((this).this).RubyModelManager.this.deltaState);
                                        }
                                    }
                                }, monitor);
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    processSavedState.setSystem(true);
                    processSavedState.setPriority(20);
                    processSavedState.schedule();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(20);
            job.schedule();
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    private void startIndexing() {
        this.getIndexManager().reset();
    }

    /*
     * Unable to fully structure code
     */
    public void loadVariablesAndContainers() throws CoreException {
        block23: {
            this.loadVariablesAndContainers(this.getDefaultPreferences());
            this.loadVariablesAndContainers(this.getInstancePreferences());
            file = this.getVariableAndContainersFile();
            in = null;
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                switch (in.readInt()) {
                    case 2: {
                        new VariablesAndContainersLoadHelper((DataInputStream)in).load();
                    }
                }
            }
            catch (IOException e) {
                if (file.exists()) {
                    Util.log(e, "Unable to read variable and containers file");
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException v0) {}
                }
                break block23;
            }
            catch (RuntimeException e) {
                try {
                    if (file.exists()) {
                        Util.log(e, "Unable to read variable and containers file (file is corrupt)");
                    }
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var4_6) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var4_6;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block23;
                }
            }
            if (in == null) break block23;
            try {
                in.close();
            }
            catch (IOException v3) {}
        }
        registeredVariables = RubyModelManager.getRegisteredVariableNames();
        i = 0;
        while (i < registeredVariables.length) {
            varName = registeredVariables[i];
            this.variables.put(varName, null);
            ++i;
        }
        this.containersReset(RubyModelManager.getRegisteredContainerIDs());
    }

    public static void recreatePersistedContainer(String propertyName, String containerString, boolean addToContainerValues) {
        int containerPrefixLength = CP_CONTAINER_PREFERENCES_PREFIX.length();
        int index = propertyName.indexOf(124, containerPrefixLength);
        if (containerString != null) {
            containerString = containerString.trim();
        }
        if (index > 0) {
            String projectName = propertyName.substring(containerPrefixLength, index).trim();
            IRubyProject project = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProject(projectName);
            Path containerPath = new Path(propertyName.substring(index + 1).trim());
            RubyModelManager.recreatePersistedContainer(project, (IPath)containerPath, containerString, addToContainerValues);
        }
    }

    private static void recreatePersistedContainer(final IRubyProject project, final IPath containerPath, String containerString, boolean addToContainerValues) {
        if (!project.getProject().isAccessible()) {
            return;
        }
        if (containerString == null) {
            RubyModelManager.getRubyModelManager().containerPut(project, containerPath, null);
        } else {
            final ILoadpathEntry[] containerEntries = ((RubyProject)project).decodeLoadpath(containerString, false, false);
            if (containerEntries != null && containerEntries != RubyProject.INVALID_LOADPATH) {
                HashMap<IPath, 7> projectContainers;
                ILoadpathContainer container = new ILoadpathContainer(){

                    public ILoadpathEntry[] getLoadpathEntries() {
                        return containerEntries;
                    }

                    public String getDescription() {
                        return "Persisted container [" + containerPath + " for project [" + project.getElementName() + "]";
                    }

                    public int getKind() {
                        return 0;
                    }

                    public IPath getPath() {
                        return containerPath;
                    }

                    public String toString() {
                        return this.getDescription();
                    }
                };
                if (addToContainerValues) {
                    RubyModelManager.getRubyModelManager().containerPut(project, containerPath, container);
                }
                if ((projectContainers = (HashMap<IPath, 7>)RubyModelManager.getRubyModelManager().previousSessionContainers.get(project)) == null) {
                    projectContainers = new HashMap<IPath, 7>(1);
                    RubyModelManager.getRubyModelManager().previousSessionContainers.put(project, projectContainers);
                }
                projectContainers.put(containerPath, container);
            }
        }
    }

    private File getVariableAndContainersFile() {
        return RubyCore.getPlugin().getStateLocation().append("variablesAndContainers.dat").toFile();
    }

    private synchronized void containersReset(String[] containerIDs) {
        int i = 0;
        while (i < containerIDs.length) {
            String containerID = containerIDs[i];
            for (IRubyProject project : this.containers.keySet()) {
                Map projectContainers = this.containers.get(project);
                if (projectContainers == null) continue;
                for (IPath containerPath : projectContainers.keySet()) {
                    if (!containerPath.segment(0).equals(containerID)) continue;
                    projectContainers.put(containerPath, null);
                }
            }
            ++i;
        }
    }

    public static String[] getRegisteredVariableNames() {
        RubyCore jdtCorePlugin = RubyCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> variableList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.core", CPVARIABLE_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String varAttribute = configElements[j].getAttribute("variable");
                    if (varAttribute != null) {
                        variableList.add(varAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] variableNames = new String[variableList.size()];
        variableList.toArray(variableNames);
        return variableNames;
    }

    private void loadVariablesAndContainers(IEclipsePreferences preferences) {
        try {
            String[] propertyNames = preferences.keys();
            int variablePrefixLength = CP_VARIABLE_PREFERENCES_PREFIX.length();
            int i = 0;
            while (i < propertyNames.length) {
                String propertyValue;
                String propertyName = propertyNames[i];
                if (propertyName.startsWith(CP_VARIABLE_PREFERENCES_PREFIX)) {
                    String varName = propertyName.substring(variablePrefixLength);
                    String propertyValue2 = preferences.get(propertyName, null);
                    if (propertyValue2 != null) {
                        String pathString = propertyValue2.trim();
                        if (CP_ENTRY_IGNORE.equals(pathString)) {
                            preferences.remove(propertyName);
                        } else {
                            String[] pathStrings = pathString.split(";");
                            IPath[] paths = new IPath[pathStrings.length];
                            int x = 0;
                            while (x < paths.length) {
                                paths[x] = new Path(pathStrings[x]);
                                ++x;
                            }
                            this.variables.put(varName, paths);
                            this.previousSessionVariables.put(varName, paths);
                        }
                    }
                } else if (propertyName.startsWith(CP_CONTAINER_PREFERENCES_PREFIX) && (propertyValue = preferences.get(propertyName, null)) != null) {
                    preferences.remove(propertyName);
                    RubyModelManager.recreatePersistedContainer(propertyName, propertyValue, true);
                }
                ++i;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public IEclipsePreferences getDefaultPreferences() {
        return this.preferencesLookup[1];
    }

    public static String[] getRegisteredContainerIDs() {
        RubyCore jdtCorePlugin = RubyCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.core", CPCONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String idAttribute = configElements[j].getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    public void shutdown() {
        RubyCore javaCore = RubyCore.getRubyCore();
        javaCore.savePluginPreferences();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.deltaState);
        workspace.removeSaveParticipant((Plugin)javaCore);
        if (this.indexManager != null) {
            this.indexManager.shutdown();
        }
        try {
            Job.getJobManager().join((Object)"org.rubypeople.rdt.core", null);
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saving(ISaveContext context) throws CoreException {
        IProject savedProject;
        this.saveVariablesAndContainers();
        if (context.getKind() == 1) {
            context.needDelta();
            IndexManager manager = this.indexManager;
            if (manager != null && this.workspaceScope != null) {
                manager.cleanUpIndexes();
            }
        }
        if ((savedProject = context.getProject()) != null) {
            if (!RubyProject.hasRubyNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            info.rememberExternalLibTimestamps();
            return;
        }
        ArrayList<IStatus> vStats = null;
        ArrayList<PerProjectInfo> values = null;
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            values = new ArrayList<PerProjectInfo>(this.perProjectInfos.values());
        }
        if (values != null) {
            Iterator<PerProjectInfo> iterator = values.iterator();
            while (iterator.hasNext()) {
                try {
                    PerProjectInfo info = iterator.next();
                    this.saveState(info, context);
                    info.rememberExternalLibTimestamps();
                }
                catch (CoreException e) {
                    if (vStats == null) {
                        vStats = new ArrayList<IStatus>();
                    }
                    vStats.add(e.getStatus());
                }
            }
        }
        if (vStats != null) {
            IStatus[] stats = new IStatus[vStats.size()];
            vStats.toArray(stats);
            throw new CoreException((IStatus)new MultiStatus("org.rubypeople.rdt.core", 4, stats, Messages.build_cannotSaveStates, null));
        }
        this.deltaState.saveExternalLibTimeStamps();
    }

    private void saveVariablesAndContainers() throws CoreException {
        File file = this.getVariableAndContainersFile();
        FilterOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                ((DataOutputStream)out).writeInt(2);
                new VariablesAndContainersSaveHelper((DataOutputStream)out).save();
            }
            catch (IOException e) {
                Status status = new Status(4, "org.rubypeople.rdt.core", 4, "Problems while saving variables and containers", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            this.saveBuiltState(info);
        }
    }

    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (RubyBuilder.DEBUG) {
            System.out.println(Messages.bind(Messages.build_saveStateProgress, info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("org.rubypeople.rdt.core");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    RubyBuilder.writeState(info.savedState, out);
                }
            }
            finally {
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.rubypeople.rdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "org.rubypeople.rdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        if (RubyBuilder.DEBUG) {
            t = System.currentTimeMillis() - t;
            System.out.println(Messages.bind(Messages.build_saveStateComplete, String.valueOf(t)));
        }
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.rubypeople.rdt.core");
        return workingLocation.append("state.dat").toFile();
    }

    public void configurePluginDebugOptions() {
        if (RubyCore.getPlugin().isDebugging()) {
            String option = Platform.getDebugOption((String)BUFFER_MANAGER_DEBUG);
            if (option != null) {
                BufferManager.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)TYPE_HIERARCHY_DEBUG)) != null) {
                TypeHierarchy.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)BUILDER_DEBUG)) != null) {
                RubyBuilder.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                DeltaProcessor.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG_VERBOSE)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)RUBYMODEL_DEBUG)) != null) {
                VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)POST_ACTION_DEBUG)) != null) {
                RubyModelOperation.POST_ACTION_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)RUBY_PARSER_DEBUG_OPTION)) != null) {
                RubyParser.setDebugging(option.equalsIgnoreCase("true"));
            }
            if ((option = Platform.getDebugOption((String)MODEL_MANAGER_VERBOSE_OPTION)) != null) {
                VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)BUILDER_VERBOSE_OPTION)) != null) {
                RubyBuilder.setVerbose(option.equalsIgnoreCase("true"));
            }
            if (PerformanceStats.ENABLED) {
                DeltaProcessor.PERF = PerformanceStats.isEnabled((String)DELTA_LISTENER_PERF);
                ReconcileWorkingCopyOperation.PERF = PerformanceStats.isEnabled((String)RECONCILE_PERF);
            }
        }
    }

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
        Util.resetRubyLikeExtensions();
    }

    public static IRubyElement create(IResource resource, IRubyProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return RubyCore.create((IProject)resource);
            }
            case 1: {
                return RubyModelManager.create((IFile)resource, project);
            }
            case 2: {
                return RubyModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return RubyCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IRubyElement create(IFolder folder, IRubyProject project) {
        IRubyElement element;
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = RubyCore.create(folder.getProject());
            element = RubyModelManager.determineIfOnLoadpath((IResource)folder, project);
            if (element == null) {
                IRubyProject[] projects;
                try {
                    projects = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProjects();
                }
                catch (RubyModelException rubyModelException) {
                    return null;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    project = projects[i];
                    element = RubyModelManager.determineIfOnLoadpath((IResource)folder, project);
                    if (element == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            element = RubyModelManager.determineIfOnLoadpath((IResource)folder, project);
        }
        return element;
    }

    private static IRubyElement determineIfOnLoadpath(IResource resource, IRubyProject project) {
        IPath resourcePath = resource.getFullPath();
        IPath rootPath = project.getPath();
        if (rootPath.equals((Object)resourcePath)) {
            return project.getSourceFolderRoot(resource);
        }
        if (rootPath.isPrefixOf(resourcePath)) {
            SourceFolderRoot root = (SourceFolderRoot)((RubyProject)project).getFolderSourceFolderRoot(rootPath);
            if (root == null) {
                return null;
            }
            IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
            if (resource.getType() == 1) {
                pkgPath = pkgPath.removeLastSegments(1);
            }
            String[] pkgName = pkgPath.segments();
            return root.getSourceFolder(pkgName);
        }
        return null;
    }

    public static IRubyScript create(IFile file, IRubyProject project) {
        String name;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = RubyCore.create(file.getProject());
        }
        if (Util.isRubyLikeFileName(name = file.getName()) || Util.isERBLikeFileName(name)) {
            return RubyModelManager.createRubyScriptFrom(file, project);
        }
        return null;
    }

    public static IRubyScript createRubyScriptFrom(IFile file, IRubyProject project) {
        ISourceFolder pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = RubyCore.create(file.getProject());
        }
        if ((pkg = (ISourceFolder)RubyModelManager.determineIfOnLoadpath((IResource)file, project)) == null) {
            ISourceFolderRoot root = project.getSourceFolderRoot((IResource)file.getParent());
            pkg = root.getSourceFolder("");
            if (VERBOSE) {
                System.out.println("WARNING : creating unit element outside loadpath (" + Thread.currentThread() + "): " + file.getFullPath());
            }
        }
        return pkg.getRubyScript(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyScript[] getWorkingCopies(WorkingCopyOwner owner, boolean addPrimary) {
        Map<WorkingCopyOwner, Map> map = this.perWorkingCopyInfos;
        synchronized (map) {
            IRubyScript[] primaryWCs = addPrimary && owner != DefaultWorkingCopyOwner.PRIMARY ? this.getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false) : null;
            Map workingCopyToInfos = this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null) {
                return primaryWCs;
            }
            int primaryLength = primaryWCs == null ? 0 : primaryWCs.length;
            int size = workingCopyToInfos.size();
            IRubyScript[] result = new IRubyScript[primaryLength + size];
            int index = 0;
            if (primaryWCs != null) {
                int i = 0;
                while (i < primaryLength) {
                    IRubyScript primaryWorkingCopy = primaryWCs[i];
                    RubyScript workingCopy = new RubyScript((SourceFolder)primaryWorkingCopy.getParent(), primaryWorkingCopy.getElementName(), owner);
                    if (!workingCopyToInfos.containsKey(workingCopy)) {
                        result[index++] = primaryWorkingCopy;
                    }
                    ++i;
                }
                if (index != primaryLength) {
                    IRubyScript[] iRubyScriptArray = result;
                    result = new IRubyScript[index + size];
                    System.arraycopy(iRubyScriptArray, 0, result, 0, index);
                }
            }
            Iterator iterator = workingCopyToInfos.values().iterator();
            while (iterator.hasNext()) {
                result[index++] = ((PerWorkingCopyInfo)iterator.next()).getWorkingCopy();
            }
            return result;
        }
    }

    public synchronized String intern(String s) {
        return (String)this.stringSymbols.add(new String(s));
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public synchronized IPath[] variableGet(String variableName) {
        HashSet<String> initializations = this.variableInitializationInProgress();
        if (initializations.contains(variableName)) {
            return VARIABLE_INITIALIZATION_IN_PROGRESS;
        }
        IPath[] variablePath = this.variables.get(variableName);
        if (variablePath == null) {
            return null;
        }
        IPath[] copy = new IPath[variablePath.length];
        System.arraycopy(variablePath, 0, copy, 0, variablePath.length);
        return copy;
    }

    private HashSet<String> variableInitializationInProgress() {
        HashSet<String> initializations = this.variableInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashSet();
            this.variableInitializationInProgress.set(initializations);
        }
        return initializations;
    }

    public IPath[] getPreviousSessionVariable(String variableName) {
        IPath[] previousPath = this.previousSessionVariables.get(variableName);
        if (previousPath != null) {
            if (CP_RESOLVE_VERBOSE) {
                Util.verbose("CPVariable INIT - reentering access to variable during its initialization, will see previous value\n\tvariable: " + variableName + '\n' + "\tprevious value: " + previousPath);
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousPath;
        }
        return null;
    }

    public synchronized void variablePut(String variableName, IPath[] variablePath) {
        HashSet<String> initializations = this.variableInitializationInProgress();
        if (variablePath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
            initializations.add(variableName);
            return;
        }
        initializations.remove(variableName);
        if (variablePath == null) {
            this.variables.put(variableName, CP_ENTRY_IGNORE_PATH);
        } else {
            this.variables.put(variableName, variablePath);
        }
        this.previousSessionVariables.remove(variableName);
    }

    public ILoadpathContainer getLoadpathContainer(IPath containerPath, IRubyProject project) throws RubyModelException {
        ILoadpathContainer container = this.containerGet(project, containerPath);
        if (container == null) {
            if (this.batchContainerInitializations) {
                this.batchContainerInitializations = false;
                return this.initializeAllContainers(project, containerPath);
            }
            return this.initializeContainer(project, containerPath);
        }
        return container;
    }

    ILoadpathContainer initializeContainer(IRubyProject project, IPath containerPath) throws RubyModelException {
        ILoadpathContainer container = null;
        LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer(containerPath.segment(0));
        if (initializer != null) {
            if (CP_RESOLVE_VERBOSE) {
                Util.verbose("CPContainer INIT - triggering initialization\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer + '\n' + "\tinvocation stack trace:");
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            this.containerPut(project, containerPath, CONTAINER_INITIALIZATION_IN_PROGRESS);
            boolean ok = false;
            try {
                initializer.initialize(containerPath, project);
                container = this.containerGet(project, containerPath);
                if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                    return null;
                }
                try {
                    ok = true;
                }
                catch (CoreException e) {
                    if (e instanceof RubyModelException) {
                        throw (RubyModelException)e;
                    }
                    throw new RubyModelException(e);
                }
                catch (RuntimeException e) {
                    if (CP_RESOLVE_VERBOSE) {
                        e.printStackTrace();
                    }
                    throw e;
                }
                catch (Error e) {
                    if (CP_RESOLVE_VERBOSE) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
            finally {
                if (!ok) {
                    this.containerRemoveInitializationInProgress(project, containerPath);
                    if (CP_RESOLVE_VERBOSE) {
                        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                            Util.verbose("CPContainer INIT - FAILED (initializer did not initialize container)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                        } else {
                            Util.verbose("CPContainer INIT - FAILED (see exception above)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                        }
                    }
                }
            }
            if (CP_RESOLVE_VERBOSE) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("CPContainer INIT - after resolution\n");
                buffer.append("\tproject: " + project.getElementName() + '\n');
                buffer.append("\tcontainer path: " + containerPath + '\n');
                if (container != null) {
                    buffer.append("\tcontainer: " + container.getDescription() + " {\n");
                    ILoadpathEntry[] entries = container.getLoadpathEntries();
                    if (entries != null) {
                        int i = 0;
                        while (i < entries.length) {
                            buffer.append("\t\t" + entries[i] + '\n');
                            ++i;
                        }
                    }
                    buffer.append("\t}");
                } else {
                    buffer.append("\tcontainer: {unbound}");
                }
                Util.verbose(buffer.toString());
            }
        } else if (CP_RESOLVE_VERBOSE) {
            Util.verbose("CPContainer INIT - no initializer found\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath);
        }
        return container;
    }

    private void containerRemoveInitializationInProgress(IRubyProject project, IPath containerPath) {
        HashSet<IPath> projectInitializations = this.containerInitializationInProgress(project);
        projectInitializations.remove(containerPath);
        if (projectInitializations.size() == 0) {
            Map initializations = this.containerInitializationInProgress.get();
            initializations.remove(project);
        }
    }

    public synchronized void containerPut(IRubyProject project, IPath containerPath, ILoadpathContainer container) {
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            HashSet<IPath> projectInitializations = this.containerInitializationInProgress(project);
            projectInitializations.add(containerPath);
            return;
        }
        this.containerRemoveInitializationInProgress(project, containerPath);
        HashMap<IPath, ILoadpathContainer> projectContainers = this.containers.get(project);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, ILoadpathContainer>(1);
            this.containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
        } else {
            projectContainers.put(containerPath, container);
        }
        Map previousContainers = (Map)this.previousSessionContainers.get(project);
        if (previousContainers != null) {
            previousContainers.remove(containerPath);
        }
    }

    private ILoadpathContainer initializeAllContainers(IRubyProject javaProjectToInit, IPath containerToInit) throws RubyModelException {
        block17: {
            if (CP_RESOLVE_VERBOSE) {
                Util.verbose("CPContainer INIT - batching containers initialization\n\tproject to init: " + javaProjectToInit.getElementName() + '\n' + "\tcontainer path to init: " + containerToInit);
            }
            final HashMap allContainerPaths = new HashMap();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IProject project = projects[i];
                if (RubyProject.hasRubyNature(project)) {
                    RubyProject javaProject = new RubyProject(project, this.getRubyModel());
                    HashSet<IPath> paths = null;
                    ILoadpathEntry[] rawClasspath = javaProject.getRawLoadpath();
                    int j = 0;
                    int length2 = rawClasspath.length;
                    while (j < length2) {
                        ILoadpathEntry entry = rawClasspath[j];
                        IPath path = entry.getPath();
                        if (entry.getEntryKind() == 5 && this.containerGet(javaProject, path) == null) {
                            if (paths == null) {
                                paths = new HashSet<IPath>();
                                allContainerPaths.put(javaProject, paths);
                            }
                            paths.add(path);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            HashSet<IPath> containerPaths = (HashSet<IPath>)allContainerPaths.get(javaProjectToInit);
            if (containerPaths == null) {
                containerPaths = new HashSet<IPath>();
                allContainerPaths.put(javaProjectToInit, containerPaths);
            }
            containerPaths.add(containerToInit);
            this.containerInitializationInProgress.set(allContainerPaths);
            boolean ok = false;
            try {
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            Set keys = allContainerPaths.keySet();
                            int length = keys.size();
                            IRubyProject[] javaProjects = new IRubyProject[length];
                            keys.toArray(javaProjects);
                            int i = 0;
                            while (i < length) {
                                IRubyProject javaProject = javaProjects[i];
                                HashSet pathSet = (HashSet)allContainerPaths.get(javaProject);
                                if (pathSet != null) {
                                    int length2 = pathSet.size();
                                    IPath[] paths = new IPath[length2];
                                    pathSet.toArray(paths);
                                    int j = 0;
                                    while (j < length2) {
                                        IPath path = paths[j];
                                        RubyModelManager.this.initializeContainer(javaProject, path);
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                    };
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (workspace.isTreeLocked()) {
                        runnable.run(null);
                    } else {
                        workspace.run(runnable, null, 1, null);
                    }
                    ok = true;
                }
                catch (CoreException e) {
                    Util.log(e, "Exception while initializing all containers");
                    if (!ok) {
                        this.containerInitializationInProgress.set(null);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.containerInitializationInProgress.set(null);
                }
                throw throwable;
            }
            if (!ok) {
                this.containerInitializationInProgress.set(null);
            }
        }
        return this.containerGet(javaProjectToInit, containerToInit);
    }

    public synchronized ILoadpathContainer containerGet(IRubyProject project, IPath containerPath) {
        HashSet<IPath> projectInitializations = this.containerInitializationInProgress(project);
        if (projectInitializations.contains(containerPath)) {
            return CONTAINER_INITIALIZATION_IN_PROGRESS;
        }
        Map projectContainers = this.containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        ILoadpathContainer container = (ILoadpathContainer)projectContainers.get(containerPath);
        return container;
    }

    private HashSet<IPath> containerInitializationInProgress(IRubyProject project) {
        HashSet projectInitializations;
        HashMap initializations = this.containerInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashMap();
            this.containerInitializationInProgress.set(initializations);
        }
        if ((projectInitializations = (HashSet)initializations.get(project)) == null) {
            projectInitializations = new HashSet();
            initializations.put(project, projectInitializations);
        }
        return projectInitializations;
    }

    public ILoadpathContainer getPreviousSessionContainer(IPath containerPath, IRubyProject project) {
        ILoadpathContainer previousContainer;
        Map previousContainerValues = (Map)this.previousSessionContainers.get(project);
        if (previousContainerValues != null && (previousContainer = (ILoadpathContainer)previousContainerValues.get(containerPath)) != null) {
            if (CP_RESOLVE_VERBOSE) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("CPContainer INIT - reentering access to project container during its initialization, will see previous value\n");
                buffer.append("\tproject: " + project.getElementName() + '\n');
                buffer.append("\tcontainer path: " + containerPath + '\n');
                buffer.append("\tprevious value: ");
                buffer.append(previousContainer.getDescription());
                buffer.append(" {\n");
                ILoadpathEntry[] entries = previousContainer.getLoadpathEntries();
                if (entries != null) {
                    int j = 0;
                    while (j < entries.length) {
                        buffer.append(" \t\t");
                        buffer.append(entries[j]);
                        buffer.append('\n');
                        ++j;
                    }
                }
                buffer.append(" \t}");
                Util.verbose(buffer.toString());
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousContainer;
        }
        return null;
    }

    public void containerRemove(IRubyProject project) {
        Map initializations = this.containerInitializationInProgress.get();
        if (initializations != null) {
            initializations.remove(project);
        }
        this.containers.remove(project);
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (RubyProject.hasRubyNature(project)) {
            PerProjectInfo info = this.getPerProjectInfo(project, true);
            info.triedRead = true;
            info.savedState = state;
        }
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    public boolean containerPutIfInitializingWithSameEntries(IPath containerPath, IRubyProject[] projects, ILoadpathContainer[] respectiveContainers) {
        int projectLength = projects.length;
        if (projectLength != 1) {
            return false;
        }
        final ILoadpathContainer container = respectiveContainers[0];
        if (container == null) {
            return false;
        }
        IRubyProject project = projects[0];
        if (!this.containerInitializationInProgress(project).contains(containerPath)) {
            return false;
        }
        ILoadpathContainer previousSessionContainer = this.getPreviousSessionContainer(containerPath, project);
        final ILoadpathEntry[] newEntries = container.getLoadpathEntries();
        if (previousSessionContainer == null) {
            if (newEntries.length == 0) {
                this.containerPut(project, containerPath, container);
                return true;
            }
            return false;
        }
        final ILoadpathEntry[] oldEntries = previousSessionContainer.getLoadpathEntries();
        if (oldEntries.length != newEntries.length) {
            return false;
        }
        int i = 0;
        int length = newEntries.length;
        while (i < length) {
            if (!newEntries[i].equals(oldEntries[i])) {
                if (CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPContainer SET  - missbehaving container\n\tcontainer path: " + containerPath + '\n' + "\tprojects: {" + org.rubypeople.rdt.core.util.Util.toString(projects, new Util.Displayable(){

                        public String displayString(Object o) {
                            return ((IRubyProject)o).getElementName();
                        }
                    }) + "}\n\tvalues on previous session: {\n" + org.rubypeople.rdt.core.util.Util.toString(respectiveContainers, new Util.Displayable(){

                        public String displayString(Object o) {
                            StringBuffer buffer = new StringBuffer("\t\t");
                            if (o == null) {
                                buffer.append("<null>");
                                return buffer.toString();
                            }
                            buffer.append(container.getDescription());
                            buffer.append(" {\n");
                            int j = 0;
                            while (j < oldEntries.length) {
                                buffer.append(" \t\t\t");
                                buffer.append(oldEntries[j]);
                                buffer.append('\n');
                                ++j;
                            }
                            buffer.append(" \t\t}");
                            return buffer.toString();
                        }
                    }) + "}\n\tnew values: {\n" + org.rubypeople.rdt.core.util.Util.toString(respectiveContainers, new Util.Displayable(){

                        public String displayString(Object o) {
                            StringBuffer buffer = new StringBuffer("\t\t");
                            if (o == null) {
                                buffer.append("<null>");
                                return buffer.toString();
                            }
                            buffer.append(container.getDescription());
                            buffer.append(" {\n");
                            int j = 0;
                            while (j < newEntries.length) {
                                buffer.append(" \t\t\t");
                                buffer.append(newEntries[j]);
                                buffer.append('\n');
                                ++j;
                            }
                            buffer.append(" \t\t}");
                            return buffer.toString();
                        }
                    }) + "\n\t}");
                }
                return false;
            }
            ++i;
        }
        this.containerPut(project, containerPath, container);
        return true;
    }

    public void updateVariableValues(String[] variableNames, IPath[][] variablePaths, boolean updatePreferences, IProgressMonitor monitor) throws RubyModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (CP_RESOLVE_VERBOSE) {
            Util.verbose("CPVariable SET  - setting variables\n\tvariables: " + org.rubypeople.rdt.core.util.Util.toString(variableNames) + '\n' + "\tvalues: " + org.rubypeople.rdt.core.util.Util.toString((Object[])variablePaths));
        }
        if (this.variablePutIfInitializingWithSameValue(variableNames, variablePaths)) {
            return;
        }
        int varLength = variableNames.length;
        final HashMap<RubyProject, ILoadpathEntry[]> affectedProjectClasspaths = new HashMap<RubyProject, ILoadpathEntry[]>(5);
        RubyModel model = this.getRubyModel();
        int discardCount = 0;
        int i = 0;
        while (i < varLength) {
            String variableName = variableNames[i];
            IPath[] oldPath = this.variableGet(variableName);
            if (oldPath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
                oldPath = null;
            }
            if (oldPath != null && oldPath.equals(variablePaths[i])) {
                variableNames[i] = null;
                ++discardCount;
            }
            ++i;
        }
        if (discardCount > 0) {
            if (discardCount == varLength) {
                return;
            }
            int changedLength = varLength - discardCount;
            String[] changedVariableNames = new String[changedLength];
            IPath[][] changedVariablePaths = new IPath[changedLength][];
            int i2 = 0;
            int index = 0;
            while (i2 < varLength) {
                if (variableNames[i2] != null) {
                    changedVariableNames[index] = variableNames[i2];
                    changedVariablePaths[index] = variablePaths[i2];
                    ++index;
                }
                ++i2;
            }
            variableNames = changedVariableNames;
            variablePaths = changedVariablePaths;
            varLength = changedLength;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (model != null) {
            IRubyProject[] projects = model.getRubyProjects();
            int i3 = 0;
            int projectLength = projects.length;
            while (i3 < projectLength) {
                RubyProject project = (RubyProject)projects[i3];
                ILoadpathEntry[] classpath = project.getRawLoadpath();
                int j = 0;
                int cpLength = classpath.length;
                block5: while (j < cpLength) {
                    ILoadpathEntry entry = classpath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = variableNames[k];
                        if (entry.getEntryKind() == 4 && variableName.equals(entry.getPath().segment(0))) {
                            affectedProjectClasspaths.put(project, project.getResolvedLoadpath(true, false, false));
                            break block5;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        i = 0;
        while (i < varLength) {
            this.variablePut(variableNames[i], variablePaths[i]);
            if (updatePreferences) {
                this.variablePreferencesPut(variableNames[i], variablePaths[i]);
            }
            ++i;
        }
        Object[] dbgVariableNames = variableNames;
        if (!affectedProjectClasspaths.isEmpty()) {
            try {
                boolean canChangeResources = !ResourcesPlugin.getWorkspace().isTreeLocked();
                RubyCore.run(new IWorkspaceRunnable((String[])dbgVariableNames, canChangeResources){
                    private final /* synthetic */ String[] val$dbgVariableNames;
                    private final /* synthetic */ boolean val$canChangeResources;
                    {
                        this.val$dbgVariableNames = stringArray;
                        this.val$canChangeResources = bl;
                    }

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        Iterator projectsToUpdate = affectedProjectClasspaths.keySet().iterator();
                        while (projectsToUpdate.hasNext()) {
                            if (progressMonitor != null && progressMonitor.isCanceled()) {
                                return;
                            }
                            RubyProject affectedProject = (RubyProject)projectsToUpdate.next();
                            if (CP_RESOLVE_VERBOSE) {
                                Util.verbose("CPVariable SET  - updating affected project due to setting variables\n\tproject: " + affectedProject.getElementName() + '\n' + "\tvariables: " + org.rubypeople.rdt.core.util.Util.toString(this.val$dbgVariableNames));
                            }
                            affectedProject.setRawLoadpath(affectedProject.getRawLoadpath(), SetLoadpathOperation.DO_NOT_SET_OUTPUT, null, this.val$canChangeResources, (ILoadpathEntry[])affectedProjectClasspaths.get(affectedProject), false, false);
                        }
                    }
                }, null, monitor);
            }
            catch (CoreException e) {
                if (CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPVariable SET  - FAILED DUE TO EXCEPTION\n\tvariables: " + org.rubypeople.rdt.core.util.Util.toString(dbgVariableNames), System.err);
                    e.printStackTrace();
                }
                if (e instanceof RubyModelException) {
                    throw (RubyModelException)e;
                }
                throw new RubyModelException(e);
            }
        }
    }

    private void variablePreferencesPut(String variableName, IPath[] variablePath) {
        String variableKey = CP_VARIABLE_PREFERENCES_PREFIX + variableName;
        if (variablePath == null) {
            this.variablesWithInitializer.remove(variableName);
            this.getInstancePreferences().remove(variableKey);
        } else {
            String string = "";
            int i = 0;
            while (i < variablePath.length) {
                if (i != 0) {
                    string = String.valueOf(string) + ";";
                }
                string = String.valueOf(string) + variablePath[i].toString();
                ++i;
            }
            this.getInstancePreferences().put(variableKey, string);
        }
        try {
            this.getInstancePreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public IEclipsePreferences getInstancePreferences() {
        return this.preferencesLookup[0];
    }

    public boolean variablePutIfInitializingWithSameValue(String[] variableNames, IPath[][] variablePaths) {
        if (variableNames.length != 1) {
            return false;
        }
        String variableName = variableNames[0];
        IPath[] oldPath = this.getPreviousSessionVariable(variableName);
        if (oldPath == null) {
            return false;
        }
        IPath[] newPath = variablePaths[0];
        if (!oldPath.equals(newPath)) {
            return false;
        }
        this.variablePut(variableName, newPath);
        return true;
    }

    public IRubySearchScope getWorkspaceScope() {
        if (this.workspaceScope == null) {
            this.workspaceScope = new RubyWorkspaceScope();
        }
        return this.workspaceScope;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public void secondaryTypesRemoving(IFile file, boolean cleanIndexCache) {
        PerProjectInfo projectInfo;
        if (VERBOSE) {
            StringBuffer buffer = new StringBuffer("RubyModelManager.removeFromSecondaryTypesCache(");
            buffer.append(file.getName());
            buffer.append(')');
            Util.verbose(buffer.toString());
        }
        if (file != null && (projectInfo = this.getPerProjectInfo(file.getProject(), false)) != null && projectInfo.secondaryTypes != null) {
            if (VERBOSE) {
                Util.verbose("-> remove file from cache of project: " + file.getProject().getName());
            }
            this.secondaryTypesRemoving(projectInfo.secondaryTypes, file);
            if (!cleanIndexCache) {
                return;
            }
            HashMap indexingCache = (HashMap)projectInfo.secondaryTypes.get(INDEXED_SECONDARY_TYPES);
            if (indexingCache != null) {
                Set keys = indexingCache.keySet();
                int filesSize = keys.size();
                int filesCount = 0;
                IFile[] removed = null;
                for (IFile cachedFile : keys) {
                    if (!file.equals((Object)cachedFile)) continue;
                    if (removed == null) {
                        removed = new IFile[filesSize];
                    }
                    --filesSize;
                    removed[filesCount++] = cachedFile;
                }
                if (removed != null) {
                    int i = 0;
                    while (i < filesCount) {
                        indexingCache.remove(removed[i]);
                        ++i;
                    }
                }
            }
        }
    }

    private void secondaryTypesRemoving(Hashtable secondaryTypesMap, IFile file) {
        if (VERBOSE) {
            StringBuffer buffer = new StringBuffer("RubyModelManager.removeSecondaryTypesFromMap(");
            for (String qualifiedName : secondaryTypesMap.keySet()) {
                buffer.append(String.valueOf(qualifiedName) + ':' + secondaryTypesMap.get(qualifiedName));
            }
            buffer.append(',');
            buffer.append(file.getFullPath());
            buffer.append(')');
            Util.verbose(buffer.toString());
        }
        Set packageKeys = secondaryTypesMap.keySet();
        int packagesSize = packageKeys.size();
        int removedPackagesCount = 0;
        String[] removedPackages = null;
        for (String packName : packageKeys) {
            if (packName == INDEXED_SECONDARY_TYPES) continue;
            HashMap types = (HashMap)secondaryTypesMap.get(packName);
            Set nameKeys = types.keySet();
            int namesSize = nameKeys.size();
            int removedNamesCount = 0;
            String[] removedNames = null;
            for (String typeName : nameKeys) {
                IType type = (IType)types.get(typeName);
                if (!file.equals((Object)type.getResource())) continue;
                if (removedNames == null) {
                    removedNames = new String[namesSize];
                }
                --namesSize;
                removedNames[removedNamesCount++] = typeName;
            }
            if (removedNames != null) {
                int i = 0;
                while (i < removedNamesCount) {
                    types.remove(removedNames[i]);
                    ++i;
                }
            }
            if (types.size() != 0) continue;
            if (removedPackages == null) {
                removedPackages = new String[packagesSize];
            }
            --packagesSize;
            removedPackages[removedPackagesCount++] = packName;
        }
        if (removedPackages != null) {
            int i = 0;
            while (i < removedPackagesCount) {
                secondaryTypesMap.remove(removedPackages[i]);
                ++i;
            }
        }
        if (VERBOSE) {
            Util.verbose("\t- new secondary types map:");
            for (String qualifiedName : secondaryTypesMap.keySet()) {
                Util.verbose("\t\t+ " + qualifiedName + ':' + secondaryTypesMap.get(qualifiedName));
            }
        }
    }

    private void traceVariableAndContainers(String action, long start) {
        Long delta = new Long(System.currentTimeMillis() - start);
        Long length = new Long(this.getVariableAndContainersFile().length());
        String pattern = "{0} {1} bytes in variablesAndContainers.dat in {2}ms";
        String message = MessageFormat.format(pattern, action, length, delta);
        System.out.println(message);
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public synchronized String[] variableNames() {
        int length = this.variables.size();
        String[] result = new String[length];
        Iterator<String> vars = this.variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = vars.next();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CompilationParticipants {
        private Object[] registeredParticipants = null;
        private HashSet<String> managedMarkerTypes;

        public CompilationParticipant[] getCompilationParticipants(IRubyProject project) {
            Object[] participants = this.getRegisteredParticipants();
            if (participants == NO_PARTICIPANTS) {
                return null;
            }
            int length = participants.length;
            final ArrayList<CompilationParticipant> result = new ArrayList<CompilationParticipant>();
            int i = 0;
            while (i < length) {
                if (participants[i] instanceof IConfigurationElement) {
                    final IConfigurationElement configElement = (IConfigurationElement)participants[i];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Util.log(exception, "Exception occurred while creating compilation participant");
                        }

                        public void run() throws Exception {
                            Object executableExtension = configElement.createExecutableExtension("class");
                            CompilationParticipant participant = (CompilationParticipant)executableExtension;
                            result.add(participant);
                        }
                    });
                } else {
                    CompilationParticipant participant = (CompilationParticipant)participants[i];
                    result.add(participant);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return null;
            }
            ArrayList<CompilationParticipant> finalResult = new ArrayList<CompilationParticipant>();
            for (CompilationParticipant participant : result) {
                if (participant == null || !participant.isActive(project)) continue;
                finalResult.add(participant);
            }
            return finalResult.toArray(new CompilationParticipant[finalResult.size()]);
        }

        public HashSet<String> managedMarkerTypes() {
            if (this.managedMarkerTypes == null) {
                this.getRegisteredParticipants();
            }
            return this.managedMarkerTypes;
        }

        private synchronized Object[] getRegisteredParticipants() {
            Object[] configElements;
            if (this.registeredParticipants != null) {
                return this.registeredParticipants;
            }
            this.managedMarkerTypes = new HashSet();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.core", RubyModelManager.COMPILATION_PARTICIPANT_EXTPOINT_ID);
            if (extension == null) {
                this.registeredParticipants = NO_PARTICIPANTS;
                return this.registeredParticipants;
            }
            ArrayList<IConfigurationElement> modifyingEnv = new ArrayList<IConfigurationElement>();
            ArrayList<IConfigurationElement> creatingProblems = new ArrayList<IConfigurationElement>();
            ArrayList<IConfigurationElement> others = new ArrayList<IConfigurationElement>();
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    String elementName = configElement.getName();
                    if (RubyModelManager.COMPILATION_PARTICIPANT_EXTPOINT_ID.equals(elementName)) {
                        if ("true".equals(configElement.getAttribute("modifiesEnvironment"))) {
                            modifyingEnv.add(configElement);
                        } else if ("true".equals(configElement.getAttribute("createsProblems"))) {
                            creatingProblems.add(configElement);
                        } else {
                            others.add(configElement);
                        }
                        IConfigurationElement[] managedMarkers = configElement.getChildren("managedMarker");
                        int k = 0;
                        int length = managedMarkers.length;
                        while (k < length) {
                            IConfigurationElement element = managedMarkers[k];
                            String markerType = element.getAttribute("markerType");
                            if (markerType != null) {
                                this.managedMarkerTypes.add(markerType);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            int size = modifyingEnv.size() + creatingProblems.size() + others.size();
            if (size == 0) {
                this.registeredParticipants = NO_PARTICIPANTS;
                return this.registeredParticipants;
            }
            configElements = new IConfigurationElement[size];
            int index = 0;
            index = this.sortParticipants(modifyingEnv, (IConfigurationElement[])configElements, index);
            index = this.sortParticipants(creatingProblems, (IConfigurationElement[])configElements, index);
            index = this.sortParticipants(others, (IConfigurationElement[])configElements, index);
            this.registeredParticipants = configElements;
            return configElements;
        }

        private int sortParticipants(ArrayList group, IConfigurationElement[] configElements, int index) {
            int size = group.size();
            if (size == 0) {
                return index;
            }
            Object[] elements = group.toArray();
            Util.sort(elements, new Util.Comparer(){

                public int compare(Object a, Object b) {
                    if (a == b) {
                        return 0;
                    }
                    String id = ((IConfigurationElement)a).getAttribute("id");
                    if (id == null) {
                        return -1;
                    }
                    IConfigurationElement[] requiredElements = ((IConfigurationElement)b).getChildren("requires");
                    int i = 0;
                    int length = requiredElements.length;
                    while (i < length) {
                        IConfigurationElement required = requiredElements[i];
                        if (id.equals(required.getAttribute("id"))) {
                            return 1;
                        }
                        ++i;
                    }
                    return -1;
                }
            });
            int i = 0;
            while (i < size) {
                configElements[index + i] = (IConfigurationElement)elements[i];
                ++i;
            }
            return index + size;
        }
    }

    public static class EclipsePreferencesListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        }
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public ILoadpathEntry[] rawLoadpath;
        public ILoadpathEntry[] resolvedLoadpath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public Hashtable secondaryTypes;
        public IEclipsePreferences preferences;
        public Hashtable<String, String> options;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }

        public synchronized void updateLoadpathInformation(ILoadpathEntry[] newRawLoadpath) {
            this.rawLoadpath = newRawLoadpath;
            this.resolvedLoadpath = null;
            this.resolvedPathToRawEntries = null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(this.project.getFullPath());
            buffer.append("\nRaw classpath:\n");
            if (this.rawLoadpath == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = this.rawLoadpath.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(this.rawLoadpath[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Resolved classpath:\n");
            ILoadpathEntry[] resolvedCP = this.resolvedLoadpath;
            if (resolvedCP == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = resolvedCP.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(resolvedCP[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Output location:\n  ");
            if (this.outputLocation == null) {
                buffer.append("<null>");
            } else {
                buffer.append(this.outputLocation);
            }
            return buffer.toString();
        }

        public void rememberExternalLibTimestamps() {
            ILoadpathEntry[] classpath = this.resolvedLoadpath;
            if (classpath == null) {
                return;
            }
            Hashtable<IPath, Long> externalTimeStamps = RubyModelManager.getRubyModelManager().deltaState.getExternalLibTimeStamps();
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                Object target;
                IPath path;
                ILoadpathEntry entry = classpath[i];
                if (entry.getEntryKind() == 1 && externalTimeStamps.get(path = entry.getPath()) == null && (target = RubyModel.getTarget(path, true)) instanceof File) {
                    long timestamp = DeltaProcessor.getTimeStamp((File)target);
                    externalTimeStamps.put(path, new Long(timestamp));
                }
                ++i;
            }
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IRubyScript workingCopy;
        private IProblemRequestor problemRequestor;

        public PerWorkingCopyInfo(IRubyScript workingCopy, IProblemRequestor problemRequestor) {
            this.workingCopy = workingCopy;
            this.problemRequestor = problemRequestor;
        }

        public IRubyScript getWorkingCopy() {
            return this.workingCopy;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(((RubyElement)((Object)this.workingCopy)).toString());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            buffer.append("\nProblem requestor:\n  ");
            buffer.append(this.problemRequestor);
            return buffer.toString();
        }

        public void acceptProblem(IProblem problem) {
            try {
                IResource resource = this.workingCopy.getUnderlyingResource();
                String markerType = "org.rubypeople.rdt.core.problem";
                if (problem.isTask()) {
                    markerType = "org.rubypeople.rdt.core.task";
                }
                if (MarkerUtility.markerExists(resource, problem.getID(), problem.getSourceStart(), problem.getSourceEnd(), markerType)) {
                    return;
                }
            }
            catch (RubyModelException rubyModelException) {
            }
            catch (CoreException coreException) {}
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.acceptProblem(problem);
        }

        public void beginReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.beginReporting();
        }

        public void endReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.endReporting();
        }

        public boolean isActive() {
            return this.problemRequestor != null && this.problemRequestor.isActive();
        }
    }

    private static final class PersistedLoadpathContainer
    implements ILoadpathContainer {
        private final IPath containerPath;
        private final ILoadpathEntry[] entries;
        private final IRubyProject project;

        PersistedLoadpathContainer(IRubyProject project, IPath containerPath, ILoadpathEntry[] entries) {
            this.containerPath = containerPath;
            this.entries = entries;
            this.project = project;
        }

        public ILoadpathEntry[] getLoadpathEntries() {
            return this.entries;
        }

        public String getDescription() {
            return "Persisted container [" + this.containerPath + " for project [" + this.project.getElementName() + "]]";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return this.containerPath;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    private final class VariablesAndContainersLoadHelper {
        private static final int ARRAY_INCREMENT = 200;
        private ILoadpathEntry[] allLoadpathEntries = null;
        private int allLoadpathEntryCount = 0;
        private final Map allPaths = new HashMap();
        private String[] allStrings = null;
        private int allStringsCount = 0;
        private final DataInputStream in;

        VariablesAndContainersLoadHelper(DataInputStream in) {
            this.in = in;
        }

        void load() throws IOException {
            this.loadProjects(RubyModelManager.this.getRubyModel());
            this.loadVariables();
        }

        private boolean loadBoolean() throws IOException {
            return this.in.readBoolean();
        }

        private ILoadpathEntry[] loadLoadpathEntries() throws IOException {
            int count = this.loadInt();
            ILoadpathEntry[] entries = new ILoadpathEntry[count];
            int i = 0;
            while (i < count) {
                entries[i] = this.loadLoadpathEntry();
                ++i;
            }
            return entries;
        }

        private ILoadpathEntry loadLoadpathEntry() throws IOException {
            int id = this.loadInt();
            if (id < 0 || id > this.allLoadpathEntryCount) {
                throw new IOException("Unexpected loadpathentry id");
            }
            if (id < this.allLoadpathEntryCount) {
                return this.allLoadpathEntries[id];
            }
            int entryKind = this.loadInt();
            IPath path = this.loadPath();
            IPath[] inclusionPatterns = this.loadPaths();
            IPath[] exclusionPatterns = this.loadPaths();
            boolean isExported = this.loadBoolean();
            ILoadpathAttribute[] extraAttributes = this.loadAttributes();
            LoadpathEntry entry = new LoadpathEntry(entryKind, path, inclusionPatterns, exclusionPatterns, extraAttributes, isExported);
            ILoadpathEntry[] array = this.allLoadpathEntries;
            if (array == null || id == array.length) {
                array = new ILoadpathEntry[id + 200];
                if (id != 0) {
                    System.arraycopy(this.allLoadpathEntries, 0, array, 0, id);
                }
                this.allLoadpathEntries = array;
            }
            array[id] = entry;
            this.allLoadpathEntryCount = id + 1;
            return entry;
        }

        private ILoadpathAttribute[] loadAttributes() throws IOException {
            int count = this.loadInt();
            if (count == 0) {
                return LoadpathEntry.NO_EXTRA_ATTRIBUTES;
            }
            ILoadpathAttribute[] attributes = new ILoadpathAttribute[count];
            int i = 0;
            while (i < count) {
                attributes[i] = this.loadAttribute();
                ++i;
            }
            return attributes;
        }

        private ILoadpathAttribute loadAttribute() throws IOException {
            String name = this.loadString();
            String value = this.loadString();
            return new LoadpathAttribute(name, value);
        }

        private void loadContainers(IRubyProject project) throws IOException {
            boolean projectIsAccessible = project.getProject().isAccessible();
            int count = this.loadInt();
            int i = 0;
            while (i < count) {
                IPath path = this.loadPath();
                ILoadpathEntry[] entries = this.loadLoadpathEntries();
                if (projectIsAccessible) {
                    PersistedLoadpathContainer container = new PersistedLoadpathContainer(project, path, entries);
                    RubyModelManager.this.containerPut(project, path, container);
                    HashMap<IPath, PersistedLoadpathContainer> oldContainers = (HashMap<IPath, PersistedLoadpathContainer>)RubyModelManager.this.previousSessionContainers.get(project);
                    if (oldContainers == null) {
                        oldContainers = new HashMap<IPath, PersistedLoadpathContainer>();
                        RubyModelManager.this.previousSessionContainers.put(project, oldContainers);
                    }
                    oldContainers.put(path, container);
                }
                ++i;
            }
        }

        private int loadInt() throws IOException {
            return this.in.readInt();
        }

        private IPath loadPath() throws IOException {
            if (this.loadBoolean()) {
                return null;
            }
            String portableString = this.loadString();
            IPath path = (IPath)this.allPaths.get(portableString);
            if (path == null) {
                path = Path.fromPortableString((String)portableString);
                this.allPaths.put(portableString, path);
            }
            return path;
        }

        private IPath[] loadPaths() throws IOException {
            int count = this.loadInt();
            IPath[] pathArray = new IPath[count];
            int i = 0;
            while (i < count) {
                pathArray[i] = this.loadPath();
                ++i;
            }
            return pathArray;
        }

        private void loadProjects(IRubyModel model) throws IOException {
            int count = this.loadInt();
            int i = 0;
            while (i < count) {
                String projectName = this.loadString();
                this.loadContainers(model.getRubyProject(projectName));
                ++i;
            }
        }

        private String loadString() throws IOException {
            int id = this.loadInt();
            if (id < 0 || id > this.allStringsCount) {
                throw new IOException("Unexpected string id");
            }
            if (id < this.allStringsCount) {
                return this.allStrings[id];
            }
            String string = this.in.readUTF();
            String[] array = this.allStrings;
            if (array == null || id == array.length) {
                array = new String[id + 200];
                if (id != 0) {
                    System.arraycopy(this.allStrings, 0, array, 0, id);
                }
                this.allStrings = array;
            }
            array[id] = string;
            this.allStringsCount = id + 1;
            return string;
        }

        private void loadVariables() throws IOException {
            int size = this.loadInt();
            HashMap<String, IPath[]> loadedVars = new HashMap<String, IPath[]>(size);
            int i = 0;
            while (i < size) {
                String varName = this.loadString();
                IPath[] varPath = this.loadPaths();
                if (varPath != null) {
                    loadedVars.put(varName, varPath);
                }
                ++i;
            }
            RubyModelManager.this.previousSessionVariables.putAll(loadedVars);
            RubyModelManager.this.variables.putAll(loadedVars);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VariablesAndContainersSaveHelper {
        private final HashtableOfObjectToInt loadpathEntryIds = new HashtableOfObjectToInt();
        private final DataOutputStream out;
        private final HashtableOfObjectToInt stringIds;

        VariablesAndContainersSaveHelper(DataOutputStream out) {
            this.out = out;
            this.stringIds = new HashtableOfObjectToInt();
        }

        void save() throws IOException, RubyModelException {
            this.saveProjects(RubyModelManager.this.getRubyModel().getRubyProjects());
            HashMap<String, IPath[]> varsToSave = null;
            Iterator<Map.Entry<String, IPath[]>> iterator = RubyModelManager.this.variables.entrySet().iterator();
            IEclipsePreferences defaultPreferences = RubyModelManager.this.getDefaultPreferences();
            while (iterator.hasNext()) {
                Map.Entry<String, IPath[]> entry = iterator.next();
                String varName = entry.getKey();
                if (defaultPreferences.get(RubyModelManager.CP_VARIABLE_PREFERENCES_PREFIX + varName, null) == null && !CP_ENTRY_IGNORE_PATH.equals(entry.getValue())) continue;
                if (varsToSave == null) {
                    varsToSave = new HashMap<String, IPath[]>(RubyModelManager.this.variables);
                }
                varsToSave.remove(varName);
            }
            this.saveVariables(varsToSave != null ? varsToSave : RubyModelManager.this.variables);
        }

        private void saveLoadpathEntries(ILoadpathEntry[] entries) throws IOException {
            int count = entries == null ? 0 : entries.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.saveLoadpathEntry(entries[i]);
                ++i;
            }
        }

        private void saveLoadpathEntry(ILoadpathEntry entry) throws IOException {
            if (this.saveNewId(entry, this.loadpathEntryIds)) {
                this.saveInt(entry.getEntryKind());
                this.savePath(entry.getPath());
                this.savePaths(entry.getInclusionPatterns());
                this.savePaths(entry.getExclusionPatterns());
                this.out.writeBoolean(entry.isExported());
                this.saveAttributes(entry.getExtraAttributes());
            }
        }

        private void saveAttribute(ILoadpathAttribute attribute) throws IOException {
            this.saveString(attribute.getName());
            this.saveString(attribute.getValue());
        }

        private void saveAttributes(ILoadpathAttribute[] attributes) throws IOException {
            int count = attributes == null ? 0 : attributes.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.saveAttribute(attributes[i]);
                ++i;
            }
        }

        private void saveContainers(IRubyProject project, Map containerMap) throws IOException {
            this.saveInt(containerMap.size());
            for (Map.Entry entry : containerMap.entrySet()) {
                IPath path = (IPath)entry.getKey();
                ILoadpathContainer container = (ILoadpathContainer)entry.getValue();
                ILoadpathEntry[] cpEntries = null;
                if (container == null) {
                    container = RubyModelManager.this.getPreviousSessionContainer(path, project);
                }
                if (container != null) {
                    cpEntries = container.getLoadpathEntries();
                }
                this.savePath(path);
                this.saveLoadpathEntries(cpEntries);
            }
        }

        private void saveInt(int value) throws IOException {
            this.out.writeInt(value);
        }

        private boolean saveNewId(Object key, HashtableOfObjectToInt map) throws IOException {
            int id = map.get(key);
            if (id == -1) {
                int newId = map.size();
                map.put(key, newId);
                this.saveInt(newId);
                return true;
            }
            this.saveInt(id);
            return false;
        }

        private void savePath(IPath path) throws IOException {
            if (path == null) {
                this.out.writeBoolean(true);
            } else {
                this.out.writeBoolean(false);
                this.saveString(path.toPortableString());
            }
        }

        private void savePaths(IPath[] paths) throws IOException {
            int count = paths == null ? 0 : paths.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.savePath(paths[i]);
                ++i;
            }
        }

        private void saveProjects(IRubyProject[] projects) throws IOException, RubyModelException {
            int count = projects.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                IRubyProject project = projects[i];
                this.saveString(project.getElementName());
                Map containerMap = RubyModelManager.this.containers.get(project);
                containerMap = containerMap == null ? Collections.EMPTY_MAP : new HashMap(containerMap);
                this.saveContainers(project, containerMap);
                ++i;
            }
        }

        private void saveString(String string) throws IOException {
            if (this.saveNewId(string, this.stringIds)) {
                this.out.writeUTF(string);
            }
        }

        private void saveVariables(Map<String, IPath[]> map) throws IOException {
            this.saveInt(map.size());
            for (String varName : map.keySet()) {
                IPath[] varPath = map.get(varName);
                this.saveString(varName);
                this.savePaths(varPath);
            }
        }
    }
}

