/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRegion;
import org.rubypeople.rdt.core.IRubyElement;

public class Region
implements IRegion {
    protected ArrayList fRootElements = new ArrayList(1);

    public void add(IRubyElement element) {
        if (!this.contains(element)) {
            this.removeAllChildren(element);
            this.fRootElements.add(element);
            this.fRootElements.trimToSize();
        }
    }

    public boolean contains(IRubyElement element) {
        int size = this.fRootElements.size();
        ArrayList parents = this.getAncestors(element);
        int i = 0;
        while (i < size) {
            IRubyElement aTop = (IRubyElement)this.fRootElements.get(i);
            if (aTop.equals(element)) {
                return true;
            }
            int j = 0;
            int pSize = parents.size();
            while (j < pSize) {
                if (aTop.equals(parents.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private ArrayList getAncestors(IRubyElement element) {
        ArrayList<IRubyElement> parents = new ArrayList<IRubyElement>();
        IRubyElement parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    public IRubyElement[] getElements() {
        int size = this.fRootElements.size();
        IRubyElement[] roots = new IRubyElement[size];
        int i = 0;
        while (i < size) {
            roots[i] = (IRubyElement)this.fRootElements.get(i);
            ++i;
        }
        return roots;
    }

    public boolean remove(IRubyElement element) {
        this.removeAllChildren(element);
        return this.fRootElements.remove(element);
    }

    protected void removeAllChildren(IRubyElement element) {
        if (element instanceof IParent) {
            ArrayList<IRubyElement> newRootElements = new ArrayList<IRubyElement>();
            int i = 0;
            int size = this.fRootElements.size();
            while (i < size) {
                IRubyElement currentRoot = (IRubyElement)this.fRootElements.get(i);
                IRubyElement parent = currentRoot.getParent();
                boolean isChild = false;
                while (parent != null) {
                    if (parent.equals(element)) {
                        isChild = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!isChild) {
                    newRootElements.add(currentRoot);
                }
                ++i;
            }
            this.fRootElements = newRootElements;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        IRubyElement[] roots = this.getElements();
        buffer.append('[');
        int i = 0;
        while (i < roots.length) {
            buffer.append(roots[i].getElementName());
            if (i < roots.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

