/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.rubypeople.rdt.core.BufferChangedEvent;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.IBufferChangedListener;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.codeassist.SelectionEngine;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;
import org.rubypeople.rdt.internal.core.util.Util;

public abstract class Openable
extends RubyElement
implements IOpenable,
IBufferChangedListener {
    public Openable(RubyElement parent) {
        super(parent);
    }

    public SourceFolderRoot getSourceFolderRoot() {
        return (SourceFolderRoot)this.getAncestor(2);
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        IResource parentResource = this.parent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.getElementName());
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    public IBuffer getBuffer() throws RubyModelException {
        if (this.hasBuffer()) {
            Object info = this.getElementInfo();
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(null, info);
            }
            return buffer;
        }
        return null;
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws RubyModelException {
        return null;
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        return !buffer.hasUnsavedChanges();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean isOpen() {
        return RubyModelManager.getRubyModelManager().getInfo(this) != null;
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws RubyModelException {
        return this.getUnderlyingResource();
    }

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isStructureKnown() throws RubyModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    public boolean hasUnsavedChanges() throws RubyModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        int elementType = this.getElementType();
        if (elementType == 1 || elementType == 0) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IRubyElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (IRubyElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    protected void closing(Object info) {
        this.closeBuffer();
    }

    public boolean exists() {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        if (manager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        SourceFolderRoot root = this.getSourceFolderRoot();
        if (!(root == null || root != this && root.isExternal())) {
            return this.resourceExists();
        }
        return super.exists();
    }

    protected boolean parentExists() {
        IRubyElement parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor monitor) throws RubyModelException {
        if (RubyModelManager.isVerbose()) {
            String element;
            switch (this.getElementType()) {
                case 1: {
                    element = "project";
                    break;
                }
                case 4: {
                    element = "script";
                    break;
                }
                default: {
                    element = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + element + " " + this.toString());
        }
        this.openParent(info, newElements, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        newElements.put(this, info);
        try {
            OpenableElementInfo openableElementInfo = (OpenableElementInfo)info;
            boolean isStructureKnown = this.buildStructure(openableElementInfo, monitor, newElements, this.getResource());
            openableElementInfo.setIsStructureKnown(isStructureKnown);
        }
        catch (RubyModelException e) {
            newElements.remove(this);
            throw e;
        }
        RubyModelManager.getRubyModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (RubyModelManager.isVerbose()) {
            System.out.println(RubyModelManager.getRubyModelManager().cache.toStringFillingRation("-> "));
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws RubyModelException;

    protected void openParent(Object info, HashMap newElements, IProgressMonitor pm) throws RubyModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    public void makeConsistent(IProgressMonitor monitor) throws RubyModelException {
    }

    public void save(IProgressMonitor pm, boolean force) throws RubyModelException {
        if (this.isReadOnly()) {
            throw new RubyModelException(new RubyModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    protected boolean resourceExists() {
        return RubyModel.getTarget(this.getPath().makeRelative(), true) != null;
    }

    public void open(IProgressMonitor pm) throws RubyModelException {
        this.getElementInfo(pm);
    }

    protected IRubyElement[] codeSelect(IRubyScript cu, int offset, int length, WorkingCopyOwner owner) throws RubyModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return new IRubyElement[0];
        }
        int end = buffer.getLength();
        if (offset < 0 || length < 0 || offset + length > end) {
            throw new RubyModelException(new RubyModelStatus(980));
        }
        SelectionEngine engine = new SelectionEngine();
        return engine.select(cu, offset, offset + length - 1);
    }

    public String findRecommendedLineSeparator() throws RubyModelException {
        IBuffer buffer = this.getBuffer();
        String source = buffer == null ? null : buffer.getContents();
        return Util.getLineSeparator(source, this.getRubyProject());
    }
}

