/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashSet;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.RubyScript;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                RubyElementInfo info = (RubyElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (RubyModelException rubyModelException) {}
    }

    protected void elementAdded(Openable element) {
        int elementType = element.getElementType();
        if (elementType == 1) {
            this.addToParentInfo(element);
            this.projectsToUpdate.add(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
        switch (elementType) {
            case 2: {
                this.projectsToUpdate.add(element.getRubyProject());
                break;
            }
            case 3: {
                RubyProject project = (RubyProject)element.getRubyProject();
                project.resetCaches();
            }
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        switch (elementType) {
            case 0: {
                break;
            }
            case 1: {
                RubyModelManager manager = RubyModelManager.getRubyModelManager();
                RubyProject javaProject = (RubyProject)element;
                manager.removePerProjectInfo(javaProject);
                manager.containerRemove(javaProject);
                break;
            }
            case 2: {
                this.projectsToUpdate.add(element.getRubyProject());
                break;
            }
            case 3: {
                RubyProject project = (RubyProject)element.getRubyProject();
                project.resetCaches();
            }
        }
    }

    public void processRubyDelta(IRubyElementDelta delta) {
        try {
            this.traverseDelta(delta, null, null);
            for (RubyProject project : this.projectsToUpdate) {
                project.updateSourceFolderRoots();
            }
        }
        finally {
            this.projectsToUpdate = new HashSet();
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                RubyElementInfo info = (RubyElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    protected void traverseDelta(IRubyElementDelta delta, ISourceFolderRoot root, IRubyProject project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                project = (IRubyProject)((Object)element);
                break;
            }
            case 2: {
                root = (ISourceFolderRoot)((Object)element);
                break;
            }
            case 4: {
                RubyScript cu = (RubyScript)element;
                if (!cu.isWorkingCopy() || cu.isPrimary()) break;
                return;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IRubyElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IRubyElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, root, project);
                ++i;
            }
        }
    }
}

