/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.core.IBuffer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.core.ExternalSourceFolder;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.RubyScriptElementInfo;
import org.rubypeople.rdt.internal.core.RubyScriptStructureBuilder;
import org.rubypeople.rdt.internal.core.SourceElementParser;
import org.rubypeople.rdt.internal.core.buffer.BufferManager;

public class ExternalRubyScript
extends RubyScript {
    public ExternalRubyScript(ExternalSourceFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws RubyModelException {
        RubyScriptElementInfo unitInfo = (RubyScriptElementInfo)info;
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            buffer = this.openBuffer(pm, unitInfo);
        }
        char[] contents = buffer == null ? null : buffer.getCharacters();
        try {
            RubyScriptStructureBuilder visitor = new RubyScriptStructureBuilder(this, unitInfo, newElements);
            SourceElementParser sp = new SourceElementParser(visitor);
            sp.parse(contents, null);
            unitInfo.setIsStructureKnown(true);
        }
        catch (SyntaxException e) {
            unitInfo.setIsStructureKnown(false);
            unitInfo.setSyntaxException(e);
        }
        catch (Exception e) {
            RubyCore.log(e);
        }
        return unitInfo.isStructureKnown();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws RubyModelException {
        char[] contents = this.findSource();
        if (contents != null) {
            IBuffer buffer = this.getBufferManager().createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            return buffer;
        }
        return null;
    }

    public File getFile() {
        ExternalSourceFolder parent = (ExternalSourceFolder)this.getParent();
        IPath parentPath = parent.getPath();
        return parentPath.append(this.name).toFile();
    }

    private char[] findSource() {
        String source = null;
        try {
            source = this.getSource();
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
        if (source == null) {
            return new char[0];
        }
        return source.toCharArray();
    }

    public IResource getResource() {
        return null;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getElementName());
    }

    public String getSource() throws RubyModelException {
        byte[] bytes;
        File file = this.getFile();
        if (!file.exists()) {
            return null;
        }
        try {
            bytes = Util.getFileByteContent(file);
        }
        catch (IOException e) {
            RubyCore.log(e);
            return null;
        }
        return new String(bytes);
    }
}

