/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.internal.core.RubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.RubyScriptElementInfo;
import org.rubypeople.rdt.internal.core.SourceFolder;
import org.rubypeople.rdt.internal.core.SourceFolderRoot;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.core.util.Util;

public class ERBScript
extends RubyScript
implements IRubyScript {
    public ERBScript(SourceFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    public IRubyElement getElementAt(int position) throws RubyModelException {
        this.getElementInfo();
        return super.getElementAt(position);
    }

    protected char[] getCharacters(IProgressMonitor pm, RubyScriptElementInfo unitInfo) throws RubyModelException {
        char[] cs = super.getCharacters(pm, unitInfo);
        return Util.replaceNonRubyCodeWithWhitespace(new String(cs));
    }

    protected IStatus validateRubyScript(IResource resource) {
        SourceFolderRoot root = this.getSourceFolderRoot();
        if (resource != null) {
            char[][] exclusionPatterns;
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            if (Util.isExcluded(resource, inclusionPatterns, exclusionPatterns = root.fullExclusionPatternChars())) {
                return new RubyModelStatus(1006, this);
            }
            if (!resource.isAccessible()) {
                return new RubyModelStatus(969, this);
            }
        }
        if (this.name == null) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.bind(Messages.convention_unit_nullName), null);
        }
        if (!Util.isERBLikeFileName(this.name)) {
            return new Status(4, "org.rubypeople.rdt.core", -1, Messages.bind(Messages.convention_unit_notERBName), null);
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateName(this.name, 1);
        if (!status.isOK()) {
            return status;
        }
        return RubyModelStatus.VERIFIED_OK;
    }

    public String getSource() throws RubyModelException {
        String src = super.getSource();
        return this.replaceNonRubyCodeWithWhitespace(src);
    }

    private String replaceNonRubyCodeWithWhitespace(String source) {
        return new String(Util.replaceNonRubyCodeWithWhitespace(source));
    }
}

