/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyModelOperation;
import org.rubypeople.rdt.internal.core.RubyScript;

public class DiscardWorkingCopyOperation
extends RubyModelOperation {
    public DiscardWorkingCopyOperation(RubyScript workingCopy) {
        super(new IRubyElement[]{workingCopy});
    }

    protected void executeOperation() throws RubyModelException {
        RubyScript workingCopy = this.getWorkingCopy();
        int useCount = RubyModelManager.getRubyModelManager().discardPerWorkingCopyInfo(workingCopy);
        if (useCount == 0) {
            if (!workingCopy.isPrimary()) {
                RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
                delta.removed(workingCopy);
                this.addDelta(delta);
                this.removeReconcileDelta(workingCopy);
            } else if (workingCopy.getResource().isAccessible()) {
                RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
                delta.changed(workingCopy, 65536);
                this.addDelta(delta);
            } else {
                RubyElementDelta delta = new RubyElementDelta(this.getRubyModel());
                delta.removed(workingCopy, 65536);
                this.addDelta(delta);
            }
        }
    }

    protected RubyScript getWorkingCopy() {
        return (RubyScript)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

