/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.DeltaProcessor;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaProcessingState
implements IResourceChangeListener {
    public IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    public int[] elementChangedListenerMasks = new int[5];
    public int elementChangedListenerCount = 0;
    public IResourceChangeListener[] preResourceChangeListeners = new IResourceChangeListener[1];
    public int[] preResourceChangeEventMasks = new int[1];
    public int preResourceChangeListenerCount = 0;
    private ThreadLocal deltaProcessors = new ThreadLocal();
    public HashMap roots = new HashMap();
    public HashMap otherRoots = new HashMap();
    public HashMap oldRoots = new HashMap();
    public HashMap oldOtherRoots = new HashMap();
    public boolean rootsAreStale = true;
    private Set initializingThreads = Collections.synchronizedSet(new HashSet());
    public HashMap projectDependencies = new HashMap();
    public Hashtable<IPath, Long> externalTimeStamps;
    public HashMap projectUpdates = new HashMap();
    private HashSet rubyProjectNamesCache;

    public void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                this.elementChangedListenerMasks[i] = eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    public DeltaProcessor getDeltaProcessor() {
        DeltaProcessor deltaProcessor = (DeltaProcessor)this.deltaProcessors.get();
        if (deltaProcessor != null) {
            return deltaProcessor;
        }
        deltaProcessor = new DeltaProcessor(this, RubyModelManager.getRubyModelManager());
        this.deltaProcessors.set(deltaProcessor);
        return deltaProcessor;
    }

    public void addPreResourceChangedListener(IResourceChangeListener listener, int eventMask) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i].equals(listener)) {
                int n = i;
                this.preResourceChangeEventMasks[n] = this.preResourceChangeEventMasks[n] | eventMask;
                return;
            }
            ++i;
        }
        int length = this.preResourceChangeListeners.length;
        if (length == this.preResourceChangeListenerCount) {
            this.preResourceChangeListeners = new IResourceChangeListener[length * 2];
            System.arraycopy(this.preResourceChangeListeners, 0, this.preResourceChangeListeners, 0, length);
            this.preResourceChangeEventMasks = new int[length * 2];
            System.arraycopy(this.preResourceChangeEventMasks, 0, this.preResourceChangeEventMasks, 0, length);
        }
        this.preResourceChangeListeners[this.preResourceChangeListenerCount] = listener;
        this.preResourceChangeEventMasks[this.preResourceChangeListenerCount] = eventMask;
        ++this.preResourceChangeListenerCount;
    }

    public void removePreResourceChangedListener(IResourceChangeListener listener) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            if (this.preResourceChangeListeners[i].equals(listener)) {
                int length = this.preResourceChangeListeners.length;
                IResourceChangeListener[] newListeners = new IResourceChangeListener[length];
                int[] newEventMasks = new int[length];
                System.arraycopy(this.preResourceChangeListeners, 0, newListeners, 0, i);
                System.arraycopy(this.preResourceChangeEventMasks, 0, newEventMasks, 0, i);
                int trailingLength = this.preResourceChangeListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.preResourceChangeListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.preResourceChangeEventMasks, i + 1, newEventMasks, i, trailingLength);
                }
                this.preResourceChangeListeners = newListeners;
                this.preResourceChangeEventMasks = newEventMasks;
                --this.preResourceChangeListenerCount;
                return;
            }
            ++i;
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int i = 0;
        while (i < this.preResourceChangeListenerCount) {
            final IResourceChangeListener listener = this.preResourceChangeListeners[i];
            if ((this.preResourceChangeEventMasks[i] & event.getType()) != 0) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of pre Ruby resource change notification");
                    }

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
            }
            ++i;
        }
        try {
            this.getDeltaProcessor().resourceChanged(event);
        }
        finally {
            if (event.getType() == 1) {
                this.deltaProcessors.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initializeRoots() {
        HashMap<IPath, DeltaProcessor.RootInfo> newRoots = null;
        HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>> newOtherRoots = null;
        HashMap<IRubyProject, IRubyProject[]> newProjectDependencies = null;
        if (this.rootsAreStale) {
            Thread currentThread = Thread.currentThread();
            boolean addedCurrentThread = false;
            try {
                IRubyProject[] projects;
                if (!this.initializingThreads.add(currentThread)) {
                    return;
                }
                addedCurrentThread = true;
                RubyModelManager.getRubyModelManager().batchContainerInitializations = true;
                newRoots = new HashMap<IPath, DeltaProcessor.RootInfo>();
                newOtherRoots = new HashMap<IPath, ArrayList<DeltaProcessor.RootInfo>>();
                newProjectDependencies = new HashMap<IRubyProject, IRubyProject[]>();
                RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
                try {
                    projects = model.getRubyProjects();
                }
                catch (RubyModelException rubyModelException) {
                    return;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    block25: {
                        ILoadpathEntry[] loadpath;
                        RubyProject project = (RubyProject)projects[i];
                        try {
                            loadpath = project.getResolvedLoadpath(true, false, false);
                        }
                        catch (RubyModelException rubyModelException) {
                            break block25;
                        }
                        int j = 0;
                        int loadpathLength = loadpath.length;
                        while (j < loadpathLength) {
                            ILoadpathEntry entry = loadpath[j];
                            if (entry.getEntryKind() == 2) {
                                IRubyProject key = model.getRubyProject(entry.getPath().segment(0));
                                IRubyProject[] dependents = (IRubyProject[])newProjectDependencies.get(key);
                                if (dependents == null) {
                                    dependents = new IRubyProject[]{project};
                                } else {
                                    int dependentsLength = dependents.length;
                                    IRubyProject[] iRubyProjectArray = dependents;
                                    dependents = new IRubyProject[dependentsLength + 1];
                                    System.arraycopy(iRubyProjectArray, 0, dependents, 0, dependentsLength);
                                    dependents[dependentsLength] = project;
                                }
                                newProjectDependencies.put(key, dependents);
                            } else {
                                IPath path = entry.getPath();
                                if (newRoots.get(path) == null) {
                                    newRoots.put(path, new DeltaProcessor.RootInfo(project, path, ((LoadpathEntry)entry).fullInclusionPatternChars(), ((LoadpathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                } else {
                                    ArrayList<DeltaProcessor.RootInfo> rootList = (ArrayList<DeltaProcessor.RootInfo>)newOtherRoots.get(path);
                                    if (rootList == null) {
                                        rootList = new ArrayList<DeltaProcessor.RootInfo>();
                                        newOtherRoots.put(path, rootList);
                                    }
                                    rootList.add(new DeltaProcessor.RootInfo(project, path, ((LoadpathEntry)entry).fullInclusionPatternChars(), ((LoadpathEntry)entry).fullExclusionPatternChars(), entry.getEntryKind()));
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (addedCurrentThread) {
                    this.initializingThreads.remove(currentThread);
                }
            }
        }
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            this.oldRoots = this.roots;
            this.oldOtherRoots = this.otherRoots;
            if (!this.rootsAreStale || newRoots == null) return;
            this.roots = newRoots;
            this.otherRoots = newOtherRoots;
            this.projectDependencies = newProjectDependencies;
            this.rootsAreStale = false;
            return;
        }
    }

    public Hashtable<IPath, Long> getExternalLibTimeStamps() {
        if (this.externalTimeStamps == null) {
            Hashtable<IPath, Long> timeStamps;
            block17: {
                timeStamps = new Hashtable<IPath, Long>();
                File timestampsFile = this.getTimeStampsFile();
                FilterInputStream in = null;
                try {
                    try {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                        int size = ((DataInputStream)in).readInt();
                        while (size-- > 0) {
                            String key = ((DataInputStream)in).readUTF();
                            long timestamp = ((DataInputStream)in).readLong();
                            timeStamps.put(Path.fromPortableString((String)key), new Long(timestamp));
                        }
                    }
                    catch (IOException e) {
                        if (timestampsFile.exists()) {
                            Util.log(e, "Unable to read external time stamps");
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.externalTimeStamps = timeStamps;
        }
        return this.externalTimeStamps;
    }

    private File getTimeStampsFile() {
        return RubyCore.getPlugin().getStateLocation().append("externalLibsTimeStamps").toFile();
    }

    public void saveExternalLibTimeStamps() throws CoreException {
        if (this.externalTimeStamps == null) {
            return;
        }
        File timestamps = this.getTimeStampsFile();
        FilterOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(timestamps)));
                ((DataOutputStream)out).writeInt(this.externalTimeStamps.size());
                for (IPath key : this.externalTimeStamps.keySet()) {
                    ((DataOutputStream)out).writeUTF(key.toPortableString());
                    Long timestamp = this.externalTimeStamps.get(key);
                    ((DataOutputStream)out).writeLong(timestamp);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.rubypeople.rdt.core", 4, "Problems while saving timestamps", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IRubyProject findRubyProject(String name) {
        if (this.getOldRubyProjecNames().contains(name)) {
            return RubyModelManager.getRubyModelManager().getRubyModel().getRubyProject(name);
        }
        return null;
    }

    public synchronized HashSet getOldRubyProjecNames() {
        if (this.rubyProjectNamesCache == null) {
            IRubyProject[] projects;
            HashSet<String> result = new HashSet<String>();
            try {
                projects = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProjects();
            }
            catch (RubyModelException rubyModelException) {
                return this.rubyProjectNamesCache;
            }
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IRubyProject project = projects[i];
                result.add(project.getElementName());
                ++i;
            }
            this.rubyProjectNamesCache = result;
            return this.rubyProjectNamesCache;
        }
        return this.rubyProjectNamesCache;
    }

    public synchronized void resetOldRubyProjectNames() {
        this.rubyProjectNamesCache = null;
    }

    public synchronized ProjectUpdateInfo[] removeAllProjectUpdates() {
        int length = this.projectUpdates.size();
        if (length == 0) {
            return null;
        }
        ProjectUpdateInfo[] updates = new ProjectUpdateInfo[length];
        this.projectUpdates.values().toArray(updates);
        this.projectUpdates.clear();
        return updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectReferences(RubyProject project, ILoadpathEntry[] oldResolvedPath, ILoadpathEntry[] newResolvedPath, ILoadpathEntry[] newRawPath, boolean canChangeResources) throws RubyModelException {
        ProjectUpdateInfo info;
        DeltaProcessingState deltaProcessingState = this;
        synchronized (deltaProcessingState) {
            info = (ProjectUpdateInfo)(canChangeResources ? this.projectUpdates.remove(project) : this.projectUpdates.get(project));
            if (info == null) {
                info = new ProjectUpdateInfo();
                info.project = project;
                info.oldResolvedPath = oldResolvedPath;
                if (!canChangeResources) {
                    this.projectUpdates.put(project, info);
                }
            }
            info.newResolvedPath = newResolvedPath;
            info.newRawPath = newRawPath;
        }
        if (canChangeResources) {
            info.updateProjectReferencesIfNecessary();
        }
    }

    public synchronized void updateRoots(IPath containerPath, IResourceDelta containerDelta, DeltaProcessor deltaProcessor) {
        HashMap otherUpdatedRoots;
        HashMap updatedRoots;
        if (containerDelta.getKind() == 2) {
            updatedRoots = this.oldRoots;
            otherUpdatedRoots = this.oldOtherRoots;
        } else {
            updatedRoots = this.roots;
            otherUpdatedRoots = this.otherRoots;
        }
        for (IPath path : updatedRoots.keySet()) {
            ArrayList rootList;
            IResourceDelta rootDelta;
            if (!containerPath.isPrefixOf(path) || containerPath.equals((Object)path) || (rootDelta = containerDelta.findMember(path.removeFirstSegments(1))) == null) continue;
            DeltaProcessor.RootInfo rootInfo2 = (DeltaProcessor.RootInfo)updatedRoots.get(path);
            if (!rootInfo2.project.getPath().isPrefixOf(path)) {
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 2, rootInfo2);
            }
            if ((rootList = (ArrayList)otherUpdatedRoots.get(path)) == null) continue;
            for (DeltaProcessor.RootInfo rootInfo2 : rootList) {
                if (rootInfo2.project.getPath().isPrefixOf(path)) continue;
                deltaProcessor.updateCurrentDeltaAndIndex(rootDelta, 2, rootInfo2);
            }
        }
    }

    public static class ProjectUpdateInfo {
        RubyProject project;
        ILoadpathEntry[] oldResolvedPath;
        ILoadpathEntry[] newResolvedPath;
        ILoadpathEntry[] newRawPath;

        public void updateProjectReferencesIfNecessary() throws RubyModelException {
            String[] oldRequired;
            String[] stringArray = oldRequired = this.oldResolvedPath == null ? CharOperation.NO_STRINGS : this.project.projectPrerequisites(this.oldResolvedPath);
            if (this.newResolvedPath == null) {
                if (this.newRawPath == null) {
                    this.newRawPath = this.project.getRawLoadpath(true, false);
                }
                this.newResolvedPath = this.project.getResolvedLoadpath(this.newRawPath, null, true, true, null);
            }
            String[] newRequired = this.project.projectPrerequisites(this.newResolvedPath);
            try {
                int newSize;
                HashSet newReferences;
                IProjectDescription description;
                IProject projectResource;
                block12: {
                    String projectName;
                    projectResource = this.project.getProject();
                    description = projectResource.getDescription();
                    IProject[] projectReferences = description.getDynamicReferences();
                    HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                    int i = 0;
                    while (i < projectReferences.length) {
                        String projectName2 = projectReferences[i].getName();
                        oldReferences.add(projectName2);
                        ++i;
                    }
                    newReferences = (HashSet)oldReferences.clone();
                    int i2 = 0;
                    while (i2 < oldRequired.length) {
                        projectName = oldRequired[i2];
                        newReferences.remove(projectName);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < newRequired.length) {
                        projectName = newRequired[i2];
                        newReferences.add(projectName);
                        ++i2;
                    }
                    newSize = newReferences.size();
                    if (oldReferences.size() == newSize) {
                        Iterator iter = newReferences.iterator();
                        while (iter.hasNext()) {
                            if (oldReferences.contains(iter.next())) {
                                continue;
                            }
                            break block12;
                        }
                        return;
                    }
                }
                String[] requiredProjectNames = new String[newSize];
                int index = 0;
                Iterator iter = newReferences.iterator();
                while (iter.hasNext()) {
                    requiredProjectNames[index++] = (String)iter.next();
                }
                Util.sort(requiredProjectNames);
                IProject[] requiredProjectArray = new IProject[newSize];
                IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
                int i = 0;
                while (i < newSize) {
                    requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                    ++i;
                }
                description.setDynamicReferences(requiredProjectArray);
                projectResource.setDescription(description, null);
            }
            catch (CoreException e) {
                throw new RubyModelException(e);
            }
        }
    }
}

