/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.codeassist;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.core.CompletionRequestor;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.codeassist.ASTSourceRequestor;
import org.rubypeople.rdt.internal.codeassist.CompletionContext;
import org.rubypeople.rdt.internal.codeassist.CompletionProposalComparator;
import org.rubypeople.rdt.internal.codeassist.RubyElementRequestor;
import org.rubypeople.rdt.internal.core.LogicalType;
import org.rubypeople.rdt.internal.core.RubyConstant;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyType;
import org.rubypeople.rdt.internal.core.SourceElementParser;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.search.BasicSearchEngine;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.internal.core.util.Util;
import org.rubypeople.rdt.internal.ti.BasicTypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;
import org.rubypeople.rdt.internal.ti.util.AttributeLocator;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;
import org.rubypeople.rdt.internal.ti.util.ScopedNodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionEngine {
    private static final String OBJECT = "Object";
    private static final String CONSTRUCTOR_INVOKE_NAME = "new";
    private static final String CONSTRUCTOR_DEFINITION_NAME = "initialize";
    private CompletionRequestor fRequestor;
    private CompletionContext fContext;
    private Set<IType> fVisitedTypes;
    private IType fOriginalType;

    public CompletionEngine(CompletionRequestor requestor) {
        this.fRequestor = requestor;
    }

    public void complete(IRubyScript script, int offset) throws RubyModelException {
        this.fRequestor.beginReporting();
        this.fContext = new CompletionContext(script, offset);
        if (this.fContext.inComment()) {
            this.fRequestor.endReporting();
            this.fContext = null;
            return;
        }
        if (this.fContext.emptyPrefix()) {
            this.suggestMethodsForEnclosingType(script);
            this.getDocumentsRubyElementsInScope();
            this.suggestGlobals();
        } else {
            if (this.fContext.isDoubleSemiColon()) {
                String prefix = this.fContext.getFullPrefix();
                String typeName = prefix.substring(0, prefix.lastIndexOf("::"));
                RubyElementRequestor requestor = new RubyElementRequestor(script);
                HashMap<String, Object> proposals = new HashMap<String, Object>();
                if (this.fContext.isBroken()) {
                    Map<IMethod, String> astMethods = this.addASTProposals(typeName);
                    for (IMethod method : astMethods.keySet()) {
                        Object proposal;
                        if (!method.isSingleton() || (proposal = this.suggestMethod(method, astMethods.get(method), 100)) == null) continue;
                        proposals.put(((CompletionProposal)proposal).getName(), proposal);
                    }
                    this.addASTTypeConstants(typeName);
                }
                IType[] types = requestor.findType(typeName);
                int i = 0;
                while (i < types.length) {
                    IType type = types[i];
                    proposals.putAll(this.suggestTypesConstants(type));
                    proposals.putAll(this.suggestNestedTypes(type));
                    proposals.putAll(this.suggestMethods(100, type, false));
                    ++i;
                }
                ArrayList list = new ArrayList(proposals.values());
                Collections.sort(list, new CompletionProposalComparator());
                for (CompletionProposal proposal : list) {
                    if (!proposal.getCompletion().startsWith(this.fContext.getPartialPrefix())) continue;
                    this.fRequestor.accept(proposal);
                }
                this.fRequestor.endReporting();
                this.fContext = null;
                return;
            }
            if (this.fContext.isConstant()) {
                this.suggestTypeNames();
                this.suggestConstantNames();
                return;
            }
            if (this.fContext.isGlobal()) {
                this.suggestGlobals();
                return;
            }
            if (this.fContext.isExplicitMethodInvokation()) {
                ITypeInferrer inferrer = RubyCore.getTypeInferrer();
                Collection<ITypeGuess> guesses = inferrer.infer(this.fContext.getCorrectedSource(), this.fContext.getOffset());
                if (guesses.isEmpty()) {
                    guesses = new ArrayList<ITypeGuess>();
                    guesses.add(new BasicTypeGuess(OBJECT, 100));
                }
                ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
                RubyElementRequestor requestor = new RubyElementRequestor(script);
                for (ITypeGuess guess : guesses) {
                    IType[] types;
                    String name = guess.getType();
                    if (this.fContext.isBroken()) {
                        Map<IMethod, String> astMethods = this.addASTProposals(name);
                        for (IMethod method : astMethods.keySet()) {
                            CompletionProposal proposal = this.suggestMethod(method, astMethods.get(method), 100);
                            if (proposal == null) continue;
                            list.add(proposal);
                        }
                    }
                    if ((types = requestor.findType(name)) == null || types.length == 0) {
                        types = requestor.findType(OBJECT);
                    }
                    HashMap<String, CompletionProposal> mapAll = new HashMap<String, CompletionProposal>();
                    if (types != null && types.length > 0) {
                        LogicalType type = new LogicalType(types);
                        mapAll.putAll(this.suggestMethods(guess.getConfidence(), type, true));
                    }
                    if (!mapAll.containsKey(CONSTRUCTOR_INVOKE_NAME) && this.fContext.fullPrefixIsConstant() && CONSTRUCTOR_INVOKE_NAME.startsWith(this.fContext.getPartialPrefix())) {
                        CompletionProposal proposal = new CompletionProposal(6, CONSTRUCTOR_INVOKE_NAME, 100);
                        proposal.setDeclaringType(name);
                        proposal.setFlags(9);
                        proposal.setReplaceRange(this.fContext.getReplaceStart(), this.fContext.getReplaceStart() + 3);
                        proposal.setName(CONSTRUCTOR_INVOKE_NAME);
                        mapAll.put(CONSTRUCTOR_INVOKE_NAME, proposal);
                    }
                    list.addAll(mapAll.values());
                }
                if (guesses.size() > 1 || guesses.size() == 1 && guesses.iterator().next().getType().equals(OBJECT)) {
                    list.addAll(this.suggestAllMethodsMatchingPrefix(script));
                }
                Collections.sort(list, new CompletionProposalComparator());
                for (CompletionProposal proposal : list) {
                    this.fRequestor.accept(proposal);
                }
            } else {
                if (this.fContext.isMethodInvokationOrLocal()) {
                    this.suggestMethodsForEnclosingType(script);
                    List<CompletionProposal> proposals = this.suggestAllMethodsMatchingPrefix(script);
                    for (CompletionProposal proposal : proposals) {
                        this.fRequestor.accept(proposal);
                    }
                }
                this.getDocumentsRubyElementsInScope();
            }
        }
        this.fRequestor.endReporting();
        this.fContext = null;
    }

    private void addASTTypeConstants(String typeName) {
        Collection<Node> typeNodes = this.getASTTypeNodesFromName(typeName);
        for (Node typeNode : typeNodes) {
            List<Node> constants = ScopedNodeLocator.Instance().findNodesInScope(typeNode, new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof ConstDeclNode || node instanceof ClassNode || node instanceof ModuleNode;
                }
            });
            HashSet<String> fields = new HashSet<String>();
            if (constants != null) {
                for (Node varNode : constants) {
                    String name;
                    Node spanner;
                    if (varNode.equals(typeNode) || (spanner = ClosestSpanningNodeLocator.Instance().findClosestSpanner(typeNode, varNode.getPosition().getStartOffset() - 1, new INodeAcceptor(){

                        public boolean doesAccept(Node node) {
                            return node instanceof ClassNode || node instanceof ModuleNode;
                        }
                    })) == null || !spanner.equals(typeNode) || !this.fContext.prefixStartsWith(name = ASTUtil.getNameReflectively(varNode))) continue;
                    fields.add(name);
                }
            }
            for (String field : fields) {
                CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 2, field);
                proposal.setDeclaringType(typeName);
                proposal.setName(field);
                this.fRequestor.accept(proposal);
            }
        }
    }

    private Map<IMethod, String> addASTProposals(String name) {
        HashMap<IMethod, String> list = new HashMap<IMethod, String>();
        Collection<Node> typeNodes = this.getASTTypeNodesFromName(name);
        for (Node typeNode : typeNodes) {
            Collection<IMethod> duh = this.addASTMethodsInScope(typeNode, name);
            for (IMethod method : duh) {
                list.put(method, name);
            }
        }
        ASTSourceRequestor srcRequestor = new ASTSourceRequestor();
        SourceElementParser srcParser = new SourceElementParser(srcRequestor);
        srcParser.acceptNode(this.fContext.getRootNode());
        List<String> mixins = srcRequestor.getMixins(name);
        for (String mixin : mixins) {
            list.putAll(srcRequestor.getMethods(mixin));
        }
        return list;
    }

    private Collection<Node> getASTTypeNodesFromName(final String name) {
        final Node rootNode = this.fContext.getRootNode();
        return ScopedNodeLocator.Instance().findNodesInScope(rootNode, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                if (!(node instanceof ModuleNode) && !(node instanceof ClassNode)) {
                    return false;
                }
                return ASTUtil.getFullyQualifiedTypeName(rootNode, node).equals(name);
            }
        });
    }

    private Collection<IMethod> addASTMethodsInScope(Node typeNode, String name) {
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        if (typeNode == null) {
            return list;
        }
        List<Node> methods = ScopedNodeLocator.Instance().findNodesInScope(typeNode, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        for (Node methodNode : methods) {
            Node scoping = this.findNearestScope(typeNode, methodNode.getPosition().getStartOffset() - 1);
            if (scoping == null || !scoping.equals(typeNode)) continue;
            MethodDefNode methodDef = (MethodDefNode)methodNode;
            NodeMethod method = new NodeMethod(methodDef, this.fContext.getScript());
            list.add(method);
        }
        return list;
    }

    private Map<String, CompletionProposal> suggestTypesConstants(IType type) throws RubyModelException {
        HashMap<String, CompletionProposal> proposals = new HashMap<String, CompletionProposal>();
        SearchPattern pattern = SearchPattern.createPattern(9, "*", 0, 2);
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{type});
        List<SearchMatch> results = this.search(pattern, scope);
        for (SearchMatch match : results) {
            IRubyElement element = (IRubyElement)match.getElement();
            if (element.getElementType() != 9) continue;
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 2, element.getElementName(), element);
            proposal.setType(type.getFullyQualifiedName());
            proposal.setName(element.getElementName());
            proposals.put(element.getElementName(), proposal);
        }
        return proposals;
    }

    private Map<String, CompletionProposal> suggestNestedTypes(IType type) throws RubyModelException {
        HashMap<String, CompletionProposal> proposals = new HashMap<String, CompletionProposal>();
        SearchPattern pattern = SearchPattern.createPattern(5, "*", 0, 2);
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{type});
        List<SearchMatch> results = this.search(pattern, scope);
        for (SearchMatch match : results) {
            String[] parts;
            IType aType = (IType)match.getElement();
            String fullname = aType.getFullyQualifiedName();
            if (fullname.equals(type.getFullyQualifiedName()) || !fullname.startsWith(type.getFullyQualifiedName()) || (parts = Util.getTypeNameParts(fullname)).length != Util.getTypeNameParts(type.getFullyQualifiedName()).length + 1) continue;
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 9, aType.getElementName());
            proposal.setType(aType.getFullyQualifiedName());
            proposal.setName(aType.getElementName());
            proposals.put(aType.getElementName(), proposal);
        }
        return proposals;
    }

    private List<CompletionProposal> suggestAllMethodsMatchingPrefix(IRubyScript script) {
        ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>();
        if (this.fContext.getPartialPrefix() == null || this.fContext.getPartialPrefix().trim().length() == 0) {
            return list;
        }
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{script.getRubyProject()});
        SearchParticipant participant = BasicSearchEngine.getDefaultSearchParticipant();
        CollectingSearchRequestor searchRequestor = new CollectingSearchRequestor();
        SearchPattern pattern = SearchPattern.createPattern(6, this.fContext.getPartialPrefix(), 0, 1);
        try {
            new BasicSearchEngine().search(pattern, new SearchParticipant[]{participant}, scope, searchRequestor, null);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        List<SearchMatch> matches = searchRequestor.getResults();
        for (SearchMatch match : matches) {
            CompletionProposal proposal;
            IMethod element = (IMethod)match.getElement();
            IType type = element.getDeclaringType();
            String typeName = "";
            if (type != null) {
                typeName = type.getElementName();
            }
            if ((proposal = this.suggestMethod(element, typeName, 50)) == null) continue;
            list.add(proposal);
        }
        return list;
    }

    private void suggestMethodsForEnclosingType(IRubyScript script) throws RubyModelException {
        IType[] types;
        boolean includeInstance;
        IRubyElement thing = script.getElementAt(this.fContext.getOffset());
        IMember element = null;
        if (thing instanceof IMember) {
            element = (IMember)thing;
        }
        boolean bl = includeInstance = !this.fContext.inTypeDefinition();
        if (element == null) {
            RubyElementRequestor requestor = new RubyElementRequestor(script);
            IType[] tmpTypes = requestor.findType(OBJECT);
            ArrayList<IType> filtered = new ArrayList<IType>();
            int i = 0;
            while (i < tmpTypes.length) {
                if (tmpTypes[i].getFullyQualifiedName().equals(OBJECT)) {
                    filtered.add(tmpTypes[i]);
                }
                ++i;
            }
            types = filtered.toArray(new IType[filtered.size()]);
            includeInstance = false;
        } else if (element instanceof IType) {
            IType type = (IType)element;
            RubyElementRequestor requestor = new RubyElementRequestor(script);
            types = requestor.findType(type.getFullyQualifiedName());
        } else {
            types = new IType[]{element.getDeclaringType()};
        }
        if (types == null || types.length < 1) {
            return;
        }
        HashMap<String, CompletionProposal> map = new HashMap<String, CompletionProposal>();
        int i = 0;
        while (i < types.length) {
            if (types[i] != null) {
                map.putAll(this.suggestMethods(100, types[i], includeInstance));
            }
            ++i;
        }
        List<CompletionProposal> list = this.sort(map);
        for (CompletionProposal proposal : list) {
            this.fRequestor.accept(proposal);
        }
    }

    private Map<String, CompletionProposal> suggestMethods(int confidence, IType type, boolean includeInstanceMethods) throws RubyModelException {
        if (this.fVisitedTypes == null) {
            this.fVisitedTypes = new HashSet<IType>();
        }
        this.fOriginalType = type;
        HashMap<String, CompletionProposal> proposals = new HashMap<String, CompletionProposal>();
        IType[] superTypes = this.getSuperTypes(type);
        int j = 0;
        while (j < superTypes.length) {
            IType currentType = superTypes[j];
            if (!this.fVisitedTypes.contains(currentType)) {
                this.fVisitedTypes.add(currentType);
                IMethod[] methods = currentType.getMethods();
                if (methods != null) {
                    int k = 0;
                    while (k < methods.length) {
                        CompletionProposal proposal;
                        if (methods[k] != null && (proposal = this.suggestMethod(methods[k], currentType.getElementName(), confidence)) != null && !proposals.containsKey(proposal.getName())) {
                            proposals.put(proposal.getName(), proposal);
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        this.fOriginalType = null;
        this.fVisitedTypes.clear();
        return proposals;
    }

    private IType[] getSuperTypes(IType type) throws RubyModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        if (hierarchy == null) {
            return new IType[]{type};
        }
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        if (superTypes == null || superTypes.length == 0) {
            return new IType[]{type};
        }
        IType[] modules = hierarchy.getAllSuperModules(type);
        if (modules == null || modules.length == 0) {
            int length = superTypes.length;
            IType[] all = new IType[length + 1];
            all[0] = type;
            System.arraycopy(superTypes, 0, all, 1, length);
            return all;
        }
        int length = superTypes.length + modules.length;
        IType[] all = new IType[length + 1];
        all[0] = type;
        System.arraycopy(superTypes, 0, all, 1, superTypes.length);
        System.arraycopy(modules, 0, all, superTypes.length + 1, modules.length);
        return all;
    }

    private List<CompletionProposal> sort(Map<String, CompletionProposal> proposals) {
        ArrayList<CompletionProposal> list = new ArrayList<CompletionProposal>(proposals.values());
        Collections.sort(list, new CompletionProposalComparator());
        return list;
    }

    private void suggestGlobals() {
        SearchPattern pattern = SearchPattern.createPattern(7, "$*", 0, 2);
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{this.fContext.getScript().getRubyProject()});
        List<SearchMatch> results = this.search(pattern, scope);
        HashSet<String> names = new HashSet<String>();
        for (SearchMatch match : results) {
            IRubyElement element = (IRubyElement)match.getElement();
            String name = element.getElementName();
            if (names.contains(name)) continue;
            names.add(name);
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 1, name, element);
            proposal.setType(name);
            this.fRequestor.accept(proposal);
        }
    }

    private void suggestTypeNames() {
        SearchPattern pattern = SearchPattern.createPattern(5, String.valueOf(this.fContext.getPartialPrefix()) + "*", 0, 2);
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{this.fContext.getScript().getRubyProject()});
        List<SearchMatch> results = this.search(pattern, scope);
        HashSet<String> names = new HashSet<String>();
        for (SearchMatch match : results) {
            IRubyElement element = (IRubyElement)match.getElement();
            String name = element.getElementName();
            if (names.contains(name)) continue;
            names.add(name);
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 9, name, element);
            proposal.setType(name);
            this.fRequestor.accept(proposal);
        }
    }

    private List<SearchMatch> search(SearchPattern pattern, IRubySearchScope scope) {
        BasicSearchEngine engine = new BasicSearchEngine();
        SearchParticipant[] participants = new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()};
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        try {
            engine.search(pattern, participants, scope, requestor, null);
        }
        catch (CoreException e) {
            RubyCore.log((Exception)((Object)e));
        }
        return requestor.getResults();
    }

    private CompletionProposal createProposal(int replaceStart, int type, String name) {
        return this.createProposal(replaceStart, type, name, 100, null);
    }

    private CompletionProposal createProposal(int replaceStart, int type, String name, IRubyElement element) {
        return this.createProposal(replaceStart, type, name, 100, element);
    }

    private CompletionProposal createProposal(int replaceStart, int type, String name, int confidence, IRubyElement element) {
        CompletionProposal proposal = new CompletionProposal(type, name, confidence);
        proposal.setReplaceRange(replaceStart, replaceStart + name.length());
        proposal.setElement(element);
        return proposal;
    }

    private void suggestConstantNames() {
        SearchPattern pattern = SearchPattern.createPattern(9, String.valueOf(this.fContext.getPartialPrefix()) + "*", 0, 2);
        IRubySearchScope scope = BasicSearchEngine.createRubySearchScope(new IRubyElement[]{this.fContext.getScript()});
        List<SearchMatch> results = this.search(pattern, scope);
        for (SearchMatch match : results) {
            IRubyElement element = (IRubyElement)match.getElement();
            String name = element.getElementName();
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 2, name, element);
            proposal.setType(name);
            this.fRequestor.accept(proposal);
        }
        if ("ARGV".startsWith(this.fContext.getPartialPrefix())) {
            RubyConstant element = new RubyConstant(null, "ARGV");
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 2, "ARGV", element);
            proposal.setType("Array");
            this.fRequestor.accept(proposal);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompletionProposal suggestMethod(IMethod method, String typeName, int confidence) {
        try {
            int flags;
            String name;
            int start;
            block17: {
                block16: {
                    start = this.fContext.getReplaceStart();
                    name = method.getElementName();
                    flags = 0;
                    if (!method.isSingleton()) break block16;
                    flags |= 8;
                    if (method.isConstructor()) {
                        name = CONSTRUCTOR_INVOKE_NAME;
                        break block17;
                    } else if (name.startsWith(typeName)) {
                        name = name.substring(typeName.length() + 1);
                    }
                    break block17;
                }
                if (this.fContext.fullPrefixIsConstant()) {
                    return null;
                }
            }
            if (!this.fContext.prefixStartsWith(name)) {
                return null;
            }
            try {
                switch (method.getVisibility()) {
                    case 2: {
                        flags |= 2;
                        if (this.fOriginalType != null && !this.fOriginalType.getElementName().equals(typeName)) {
                            return null;
                        }
                        if (!this.fContext.hasReceiver()) break;
                        return null;
                    }
                    case 1: {
                        flags |= 1;
                        break;
                    }
                    case 4: {
                        flags |= 4;
                        break;
                    }
                }
            }
            catch (RubyModelException e) {
                RubyCore.log((Exception)((Object)e));
                flags |= 1;
            }
            CompletionProposal proposal = this.createProposal(start, 6, name, confidence, method);
            proposal.setReplaceRange(start, start + name.length());
            proposal.setFlags(flags);
            proposal.setName(name);
            IType declaringType = method.getDeclaringType();
            String declaringName = typeName;
            if (declaringType != null) {
                declaringName = declaringType.getFullyQualifiedName();
            }
            proposal.setDeclaringType(declaringName);
            return proposal;
        }
        catch (RuntimeException e) {
            RubyCore.log(e);
            return null;
        }
    }

    private void getDocumentsRubyElementsInScope() {
        try {
            Node rootNode = this.fContext.getRootNode();
            if (rootNode == null) {
                return;
            }
            Node enclosingNode = this.findNearestScope(rootNode, this.fContext.getOffset());
            if (enclosingNode == null) {
                enclosingNode = rootNode;
            }
            Set<String> variables = this.addVariablesinScope(this.getScope(enclosingNode));
            for (String variable : variables) {
                int type = 5;
                if (variable.startsWith("$")) {
                    type = 1;
                }
                CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), type, variable);
                this.fRequestor.accept(proposal);
            }
            Node enclosingTypeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(rootNode, this.fContext.getOffset(), new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof ClassNode || node instanceof ModuleNode || node instanceof RootNode;
                }
            });
            if (enclosingTypeNode == null) {
                enclosingTypeNode = rootNode;
            }
            Collection<IMethod> methods = this.addASTMethodsInScope(enclosingTypeNode, "");
            for (IMethod method : methods) {
                CompletionProposal proposal = this.suggestMethod(method, "", 100);
                if (proposal == null) continue;
                this.fRequestor.accept(proposal);
            }
            enclosingTypeNode = ClosestSpanningNodeLocator.Instance().findClosestSpanner(rootNode, this.fContext.getOffset(), new INodeAcceptor(){

                public boolean doesAccept(Node node) {
                    return node instanceof ClassNode || node instanceof ModuleNode;
                }
            });
            if (enclosingTypeNode != null) {
                this.getMembersAvailableInsideType(enclosingTypeNode);
            }
        }
        catch (RubyModelException rme) {
            RubyCore.log((Exception)((Object)rme));
            RubyCore.log("RubyModelException in CompletionEngine::getElementsInScope()");
        }
        catch (SyntaxException se) {
            RubyCore.log((Exception)((Object)se));
            RubyCore.log("SyntaxError in CompletionEngine::getElementsInScope()");
        }
    }

    private Node findNearestScope(Node scopeNode, int offset) {
        if (offset == -1) {
            return scopeNode;
        }
        Node scope = ClosestSpanningNodeLocator.Instance().findClosestSpanner(scopeNode, offset, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode || node instanceof ClassNode || node instanceof ModuleNode || node instanceof RootNode || node instanceof IterNode;
            }
        });
        if (scope == null) {
            return scopeNode;
        }
        return scope;
    }

    private Set<String> addVariablesinScope(StaticScope scope) {
        HashSet<String> matches = new HashSet<String>();
        if (scope == null) {
            return matches;
        }
        String[] variables = scope.getVariables();
        int i = 0;
        while (i < variables.length) {
            String local = variables[i];
            if (this.fContext.prefixStartsWith(local)) {
                matches.add(local);
            }
            ++i;
        }
        matches.addAll(this.addVariablesinScope(scope.getEnclosingScope()));
        return matches;
    }

    private StaticScope getScope(Node enclosingNode) {
        if (enclosingNode == null) {
            return ((RootNode)this.fContext.getRootNode()).getStaticScope();
        }
        if (enclosingNode instanceof RootNode) {
            RootNode root = (RootNode)enclosingNode;
            return root.getStaticScope();
        }
        try {
            Method getScopeMethod = enclosingNode.getClass().getMethod("getScope", new Class[0]);
            Object scope = getScopeMethod.invoke((Object)enclosingNode, new Object[0]);
            return (StaticScope)scope;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void getMembersAvailableInsideType(Node typeNode) throws RubyModelException {
        if (typeNode == null) {
            return;
        }
        String typeName = this.getTypeName(typeNode);
        if (typeName == null) {
            return;
        }
        List<Node> superclassNodes = this.getSuperclassNodes(typeNode);
        for (Node superclassNode : superclassNodes) {
            this.getMembersAvailableInsideType(superclassNode);
        }
        List<String> mixinNames = this.getIncludedMixinNames(typeName);
        for (String mixinName : mixinNames) {
            List<Node> mixinDeclarations = this.getTypeDeclarationNodes(mixinName);
            for (Node mixinDeclaration : mixinDeclarations) {
                this.getMembersAvailableInsideType(mixinDeclaration);
            }
        }
        List<Node> methodDefinitions = ScopedNodeLocator.Instance().findNodesInScope(typeNode, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof DefnNode || node instanceof DefsNode;
            }
        });
        for (Node methodDefinition : methodDefinitions) {
            String name = null;
            if (methodDefinition instanceof DefnNode) {
                name = ((DefnNode)methodDefinition).getName();
            }
            if (methodDefinition instanceof DefsNode) {
                name = ((DefsNode)methodDefinition).getName();
            }
            if (!this.fContext.prefixStartsWith(name)) continue;
            NodeMethod method = new NodeMethod((MethodDefNode)methodDefinition, this.fContext.getScript());
            this.suggestMethod(method, typeName, 100);
        }
        this.addTypesVariables(typeNode);
    }

    private String getTypeName(Node typeNode) {
        String typeName = null;
        if (typeNode instanceof ClassNode) {
            typeName = ((Colon2Node)((ClassNode)typeNode).getCPath()).getName();
        }
        if (typeNode instanceof ModuleNode) {
            typeName = ((Colon2Node)((ModuleNode)typeNode).getCPath()).getName();
        }
        return typeName;
    }

    private void addTypesVariables(Node typeNode) {
        List<Node> instanceAndClassVars = ScopedNodeLocator.Instance().findNodesInScope(typeNode, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof ConstDeclNode || node instanceof InstVarNode || node instanceof InstAsgnNode || node instanceof ClassVarNode || node instanceof ClassVarDeclNode || node instanceof ClassVarAsgnNode;
            }
        });
        HashSet<String> fields = new HashSet<String>();
        if (instanceAndClassVars != null) {
            for (Node varNode : instanceAndClassVars) {
                String name = ASTUtil.getNameReflectively(varNode);
                if (!this.fContext.prefixStartsWith(name)) continue;
                fields.add(name);
            }
        }
        List<String> attrs = AttributeLocator.Instance().findInstanceAttributesInScope(typeNode);
        for (String attr : attrs) {
            if (!this.fContext.prefixStartsWith(attr)) continue;
            fields.add(attr);
        }
        for (String field : fields) {
            CompletionProposal proposal = this.createProposal(this.fContext.getReplaceStart(), 2, field);
            this.fRequestor.accept(proposal);
        }
    }

    private List<Node> getSuperclassNodes(Node typeNode) {
        Node superNode;
        if (typeNode instanceof ClassNode && (superNode = ((ClassNode)typeNode).getSuperNode()) instanceof ConstNode) {
            String superclassName = ((ConstNode)superNode).getName();
            return this.getTypeDeclarationNodes(superclassName);
        }
        return new ArrayList<Node>();
    }

    private List<Node> getTypeDeclarationNodes(String typeName) {
        block7: {
            RubyElementRequestor requestor = new RubyElementRequestor(this.fContext.getScript());
            IType[] types = requestor.findType(typeName);
            if (types == null || types.length == 0) {
                return new ArrayList<Node>(0);
            }
            IType type = types[0];
            try {
                if (!(type instanceof RubyType)) break block7;
                RubyType rubyType = (RubyType)type;
                String source = rubyType.getSource();
                if (source == null) {
                    return new ArrayList<Node>(0);
                }
                source = source.replace('\r', ' ');
                Node rootNode = null;
                try {
                    rootNode = new RubyParser().parse(type.getRubyScript().getElementName(), source).getAST();
                }
                catch (Exception e) {
                    RubyCore.log(e);
                }
                if (rootNode == null) {
                    return new ArrayList<Node>();
                }
                return ScopedNodeLocator.Instance().findNodesInScope(rootNode, new INodeAcceptor(){

                    public boolean doesAccept(Node node) {
                        return node instanceof ClassNode || node instanceof ModuleNode;
                    }
                });
            }
            catch (RubyModelException rme) {
                rme.printStackTrace();
            }
        }
        return new ArrayList<Node>(0);
    }

    private List<String> getIncludedMixinNames(String typeName) {
        RubyType rubyType = new RubyType((RubyElement)((Object)this.fContext.getScript()), typeName);
        try {
            String[] includedModuleNames = rubyType.getIncludedModuleNames();
            if (includedModuleNames != null) {
                return Arrays.asList(rubyType.getIncludedModuleNames());
            }
            return new ArrayList<String>(0);
        }
        catch (RubyModelException rubyModelException) {
            return new ArrayList<String>(0);
        }
    }

    private class NodeMethod
    implements IMethod {
        private MethodDefNode node;
        private IRubyScript fScript;

        public NodeMethod(MethodDefNode methodDefinition, IRubyScript script) {
            this.node = methodDefinition;
            this.fScript = script;
        }

        public String[] getParameterNames() throws RubyModelException {
            return ASTUtil.getArgs((Node)this.node.getArgsNode(), this.node.getScope());
        }

        public int getNumberOfParameters() throws RubyModelException {
            return this.getParameterNames().length;
        }

        public int getVisibility() throws RubyModelException {
            return 1;
        }

        public boolean isConstructor() {
            return this.node.getName().equals(CompletionEngine.CONSTRUCTOR_DEFINITION_NAME);
        }

        public boolean isSingleton() {
            return this.isConstructor() || this.node instanceof DefsNode;
        }

        public boolean exists() {
            return false;
        }

        public IRubyElement getAncestor(int ancestorType) {
            return null;
        }

        public IResource getCorrespondingResource() throws RubyModelException {
            return null;
        }

        public String getElementName() {
            return this.node.getName();
        }

        public int getElementType() {
            return 6;
        }

        public IOpenable getOpenable() {
            return this.fScript;
        }

        public IRubyElement getParent() {
            return null;
        }

        public IPath getPath() {
            return null;
        }

        public IRubyElement getPrimaryElement() {
            return null;
        }

        public IResource getResource() {
            return null;
        }

        public IRubyModel getRubyModel() {
            return null;
        }

        public IRubyProject getRubyProject() {
            return null;
        }

        public IResource getUnderlyingResource() throws RubyModelException {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isStructureKnown() throws RubyModelException {
            return false;
        }

        public boolean isType(int type) {
            return type == 6;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IType getDeclaringType() {
            return null;
        }

        public ISourceRange getNameRange() throws RubyModelException {
            return null;
        }

        public IRubyScript getRubyScript() {
            return this.fScript;
        }

        public IType getType(String name, int occurrenceCount) {
            return null;
        }

        public String getSource() throws RubyModelException {
            return null;
        }

        public ISourceRange getSourceRange() throws RubyModelException {
            return null;
        }

        public IRubyElement[] getChildren() throws RubyModelException {
            return null;
        }

        public boolean hasChildren() throws RubyModelException {
            return false;
        }

        public String getHandleIdentifier() {
            return null;
        }

        public boolean isPrivate() throws RubyModelException {
            return false;
        }

        public boolean isProtected() throws RubyModelException {
            return false;
        }

        public boolean isPublic() throws RubyModelException {
            return false;
        }

        public String[] getBlockParameters() throws RubyModelException {
            final HashSet vars = new HashSet();
            InOrderVisitor visitor = new InOrderVisitor(){
                private String typeName;

                public Instruction visitClassNode(ClassNode iVisited) {
                    this.typeName = ASTUtil.getFullyQualifiedName((Node)iVisited.getCPath());
                    return super.visitClassNode(iVisited);
                }

                public Instruction visitModuleNode(ModuleNode iVisited) {
                    this.typeName = ASTUtil.getFullyQualifiedName((Node)iVisited.getCPath());
                    return super.visitModuleNode(iVisited);
                }

                public Instruction visitYieldNode(YieldNode iVisited) {
                    Node argsNode = iVisited.getArgsNode();
                    if (argsNode instanceof LocalVarNode) {
                        vars.add(((LocalVarNode)argsNode).getName());
                    } else if (argsNode instanceof SelfNode) {
                        String name = null;
                        if (this.typeName == null) {
                            name = "var";
                        } else {
                            name = this.typeName.toLowerCase();
                            if (name.indexOf("::") > -1) {
                                name = name.substring(name.lastIndexOf("::") + 2);
                            }
                        }
                        vars.add(name);
                    }
                    return super.visitYieldNode(iVisited);
                }
            };
            this.node.accept((NodeVisitor)visitor);
            return vars.toArray(new String[vars.size()]);
        }
    }
}

