/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.codeassist;

import java.util.List;
import org.jruby.ast.ClassNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.parser.RubyParserResult;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.ti.util.ClosestSpanningNodeLocator;
import org.rubypeople.rdt.internal.ti.util.INodeAcceptor;

public class CompletionContext {
    private IRubyScript script;
    private int offset;
    private boolean isMethodInvokation = false;
    private String correctedSource;
    private String partialPrefix;
    private String fullPrefix;
    private int replaceStart;
    private boolean isAfterDoubleSemiColon = false;
    private Node fRootNode;
    private List<CommentNode> fCommentNodes;
    private boolean inComment;

    public CompletionContext(IRubyScript script, int offset) throws RubyModelException {
        this.script = script;
        if (offset < 0) {
            offset = 0;
        }
        this.offset = offset;
        this.replaceStart = offset + 1;
        try {
            this.run();
        }
        catch (RuntimeException e) {
            RubyCore.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void run() throws RubyModelException {
        StringBuffer source = new StringBuffer(this.script.getSource());
        if (this.offset >= source.length()) {
            this.offset = source.length() - 1;
            this.replaceStart = this.offset + 1;
        }
        StringBuffer tmpPrefix = new StringBuffer();
        boolean setOffset = false;
        int i = this.offset;
        while (i >= 0) {
            block16: {
                char previous;
                char curChar;
                block15: {
                    curChar = source.charAt(i);
                    if (this.offset != i) break block15;
                    switch (curChar) {
                        case '$': 
                        case ',': 
                        case '.': 
                        case '@': {
                            source.deleteCharAt(i);
                            break;
                        }
                        case ':': {
                            if (i <= 0 || (previous = source.charAt(i - 1)) != ':') break;
                            this.isAfterDoubleSemiColon = true;
                            source.deleteCharAt(i);
                            source.deleteCharAt(i - 1);
                            tmpPrefix.insert(0, "::");
                            this.partialPrefix = "";
                            --i;
                            break block16;
                        }
                    }
                }
                if (curChar == '.') {
                    this.isMethodInvokation = true;
                    if (this.partialPrefix == null) {
                        this.partialPrefix = tmpPrefix.toString();
                    }
                    this.offset = this.offset - 1 == i ? i : i - 1;
                    setOffset = true;
                } else if (curChar == ':' && i > 0 && (previous = source.charAt(i - 1)) == ':') {
                    this.isAfterDoubleSemiColon = true;
                    if (this.partialPrefix == null) {
                        this.partialPrefix = tmpPrefix.toString();
                    }
                    tmpPrefix.insert(0, ":");
                    --i;
                }
                if (Character.isWhitespace(curChar) || curChar == ',' || curChar == '(' || curChar == '[' || curChar == '{') {
                    if (setOffset) break;
                    this.offset = i + 1;
                    setOffset = true;
                    break;
                }
                tmpPrefix.insert(0, curChar);
            }
            --i;
        }
        this.fullPrefix = tmpPrefix.toString();
        if (this.partialPrefix == null) {
            this.partialPrefix = this.fullPrefix;
        }
        if (this.partialPrefix != null) {
            this.replaceStart -= this.partialPrefix.length();
        }
        this.correctedSource = source.toString();
        Node selected = ClosestSpanningNodeLocator.Instance().findClosestSpanner(this.getRootNode(), this.offset, new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return true;
            }
        });
        if (selected != null) return;
        if (this.fCommentNodes == null) return;
        for (CommentNode comment : this.fCommentNodes) {
            if (!ClosestSpanningNodeLocator.nodeSpansOffset((Node)comment, this.offset)) continue;
            this.inComment = true;
            return;
        }
    }

    public boolean isExplicitMethodInvokation() {
        return this.isMethodInvokation;
    }

    public boolean isMethodInvokationOrLocal() {
        return !this.isExplicitMethodInvokation() && (this.emptyPrefix() || this.getPartialPrefix().length() > 0 && Character.isLowerCase(this.getPartialPrefix().charAt(0)));
    }

    public boolean isConstant() {
        return this.getPartialPrefix() != null && this.getPartialPrefix().length() > 0 && Character.isUpperCase(this.getPartialPrefix().charAt(0));
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public String getCorrectedSource() {
        return this.correctedSource;
    }

    public boolean isBroken() {
        try {
            return !this.getCorrectedSource().equals(this.script.getSource());
        }
        catch (RubyModelException rubyModelException) {
            return true;
        }
    }

    public boolean hasReceiver() {
        return this.getFullPrefix().indexOf(46) > 1;
    }

    public String getSource() {
        try {
            return this.getScript().getSource();
        }
        catch (RubyModelException rubyModelException) {
            return "";
        }
    }

    public String getFullPrefix() {
        return this.fullPrefix;
    }

    public String getPartialPrefix() {
        return this.partialPrefix;
    }

    public int getOffset() {
        return this.offset;
    }

    public IRubyScript getScript() {
        return this.script;
    }

    public boolean emptyPrefix() {
        return this.getFullPrefix() == null || this.getFullPrefix().length() == 0;
    }

    public boolean prefixStartsWith(String name) {
        return name != null && this.getPartialPrefix() != null && name.startsWith(this.getPartialPrefix());
    }

    public boolean isGlobal() {
        return !this.emptyPrefix() && !this.isExplicitMethodInvokation() && this.getPartialPrefix().startsWith("$");
    }

    public boolean isDoubleSemiColon() {
        return this.isAfterDoubleSemiColon && !this.isMethodInvokation;
    }

    public boolean fullPrefixIsConstant() {
        if (this.getFullPrefix() == null || this.getFullPrefix().length() == 0) {
            return false;
        }
        if (this.getFullPrefix().endsWith("\".") || this.getFullPrefix().endsWith("'.")) {
            return false;
        }
        return Character.isUpperCase(this.getFullPrefix().charAt(0));
    }

    public boolean inTypeDefinition() {
        if (this.getRootNode() == null) {
            return false;
        }
        Node spanner = ClosestSpanningNodeLocator.Instance().findClosestSpanner(this.getRootNode(), this.getOffset(), new INodeAcceptor(){

            public boolean doesAccept(Node node) {
                return node instanceof MethodDefNode || node instanceof ClassNode || node instanceof ModuleNode;
            }
        });
        return spanner instanceof ClassNode || spanner instanceof ModuleNode;
    }

    Node getRootNode() {
        RubyParserResult result;
        if (this.fRootNode != null) {
            return this.fRootNode;
        }
        RubyParser parser = new RubyParser();
        if (!this.isBroken()) {
            try {
                result = parser.parse(this.getScript().getElementName(), this.getSource());
                this.fRootNode = result.getAST();
                this.fCommentNodes = result.getCommentNodes();
            }
            catch (RuntimeException runtimeException) {}
        }
        if (this.fRootNode == null) {
            try {
                result = parser.parse(this.getCorrectedSource());
                this.fRootNode = result.getAST();
                this.fCommentNodes = result.getCommentNodes();
            }
            catch (RuntimeException runtimeException) {}
        }
        if (this.fRootNode == null) {
            this.fRootNode = ((RubyScript)this.getScript()).lastGoodAST;
        }
        return this.fRootNode;
    }

    public boolean inComment() {
        return this.inComment;
    }
}

