/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class Util {
    private static final String[] KEYWORDS = new String[]{"alias", "and", "BEGIN", "begin", "break", "case", "class", "def", "defined", "do", "else", "elsif", "END", "end", "ensure", "false", "for", "if", "in", "module", "next", "nil", "not", "or", "redo", "rescue", "retry", "return", "self", "super", "then", "true", "undef", "unless", "until", "when", "while", "yield"};
    private static final String[] OPERATORS = new String[]{"::", ".", "[]", "**", "-", "+", "!", "~", "*", "/", " %", "+", "-", "<<", ">>", "&", "|", "^", ">", ">=", "<", "<=", "<=>", "==", "===", "!=", "=~", "!~", "&&", "||", "..", "...", "=", "+=", "-=", "*=", "/=", "||="};
    private static final int DEFAULT_READING_SIZE = 8192;
    public static final String UTF_8 = "UTF-8";
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static String toString(Object[] objects, Displayable renderer) {
        if (objects == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(renderer.displayString(objects[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static String toString(Object[] objects) {
        return Util.toString(objects, new Displayable(){

            public String displayString(Object o) {
                if (o == null) {
                    return "null";
                }
                return o.toString();
            }
        });
    }

    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        block7: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            reader = new InputStreamReader(stream);
        }
        int totalRead = 0;
        char[] contents = length == -1 ? CharOperation.NO_CHAR : new char[length];
        while (true) {
            int amountRequested;
            if (totalRead < length) {
                amountRequested = length - totalRead;
            } else {
                int current = reader.read();
                if (current < 0) break;
                amountRequested = Math.max(stream.available(), 8192);
                if (totalRead + 1 + amountRequested > contents.length) {
                    char[] cArray = contents;
                    contents = new char[totalRead + 1 + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, totalRead);
                }
                contents[totalRead++] = (char)current;
            }
            int amountRead = reader.read(contents, totalRead, amountRequested);
            if (amountRead < 0) break;
            totalRead += amountRead;
        }
        int start = 0;
        if (totalRead > 0 && UTF_8.equals(encoding) && contents[0] == '\ufeff') {
            --totalRead;
            start = 1;
        }
        if (totalRead < contents.length) {
            char[] cArray = contents;
            contents = new char[totalRead];
            System.arraycopy(cArray, start, contents, 0, totalRead);
        }
        return contents;
    }

    public static String camelCaseToUnderscores(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return "";
        }
        StringBuffer newName = new StringBuffer();
        boolean lastWasUpper = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            newName.append(Character.toLowerCase(c));
            if (lastWasUpper && Character.isLowerCase(c)) {
                if (newName.length() > 2) {
                    newName.insert(newName.length() - 2, "_");
                }
                lastWasUpper = false;
            }
            if (Character.isUpperCase(c)) {
                lastWasUpper = true;
            }
            ++i;
        }
        return newName.toString();
    }

    public static String underscoresToCamelCase(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return "";
        }
        StringBuffer newName = new StringBuffer();
        boolean lastWasUnderScore = false;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (lastWasUnderScore || i == 0) {
                newName.append(Character.toUpperCase(c));
                lastWasUnderScore = false;
            } else if (c == '_') {
                lastWasUnderScore = true;
            } else {
                newName.append(c);
            }
            ++i;
        }
        return newName.toString();
    }

    public static boolean isOperator(String word) {
        return Util.contains(word, OPERATORS);
    }

    public static boolean isKeyword(String word) {
        return Util.contains(word, KEYWORDS);
    }

    private static boolean contains(String word, String[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(word)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

