/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.search;

import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.compiler.parser.ScannerHelper;
import org.rubypeople.rdt.internal.core.LocalVariable;
import org.rubypeople.rdt.internal.core.search.MethodPatternParser;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.matching.ConstructorPattern;
import org.rubypeople.rdt.internal.core.search.matching.FieldPattern;
import org.rubypeople.rdt.internal.core.search.matching.InternalSearchPattern;
import org.rubypeople.rdt.internal.core.search.matching.LocalVariablePattern;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.MethodPattern;
import org.rubypeople.rdt.internal.core.search.matching.OrPattern;
import org.rubypeople.rdt.internal.core.search.matching.QualifiedTypeDeclarationPattern;
import org.rubypeople.rdt.internal.core.search.matching.TypeDeclarationPattern;
import org.rubypeople.rdt.internal.core.search.matching.TypeReferencePattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public abstract class SearchPattern
extends InternalSearchPattern {
    public static final int R_EXACT_MATCH = 0;
    public static final int R_PREFIX_MATCH = 1;
    public static final int R_PATTERN_MATCH = 2;
    public static final int R_REGEXP_MATCH = 4;
    public static final int R_CASE_SENSITIVE = 8;
    public static final int R_ERASURE_MATCH = 16;
    public static final int R_EQUIVALENT_MATCH = 32;
    public static final int R_FULL_MATCH = 64;
    public static final int R_CAMELCASE_MATCH = 128;
    private static final int MODE_MASK = 7;
    private int matchRule;

    public SearchPattern(int matchRule) {
        this.matchRule = matchRule;
        if ((matchRule & 0x30) == 0) {
            this.matchRule |= 0x40;
        }
    }

    public abstract SearchPattern getBlankPattern();

    public void decodeIndexKey(char[] key) {
    }

    public char[] getIndexKey() {
        return null;
    }

    public char[][] getIndexCategories() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public final int getMatchRule() {
        return this.matchRule;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    public static SearchPattern createPattern(int elementType, String stringPattern, int limitTo, int matchRule) {
        switch (elementType) {
            case 5: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\u0000');
            }
            case 6: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false);
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule);
            }
        }
        return null;
    }

    private static SearchPattern createFieldPattern(String patternString, int limitTo, int matchRule) {
        String fieldName = patternString;
        if (fieldName == null) {
            return null;
        }
        char[] fieldNameChars = fieldName.toCharArray();
        if (fieldNameChars.length == 1 && fieldNameChars[0] == '*') {
            fieldNameChars = null;
        }
        char[] declaringTypeQualification = null;
        char[] declaringTypeSimpleName = null;
        boolean findDeclarations = false;
        boolean readAccess = false;
        boolean writeAccess = false;
        switch (limitTo) {
            case 0: {
                findDeclarations = true;
                break;
            }
            case 1: {
                readAccess = true;
                writeAccess = true;
                break;
            }
            case 3: {
                readAccess = true;
                break;
            }
            case 4: {
                writeAccess = true;
                break;
            }
            case 2: {
                findDeclarations = true;
                readAccess = true;
                writeAccess = true;
            }
        }
        return new FieldPattern(findDeclarations, readAccess, writeAccess, fieldNameChars, declaringTypeQualification, declaringTypeSimpleName, matchRule);
    }

    public boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            boolean matchFirstChar;
            boolean isCaseSensitive = (this.matchRule & 8) != 0;
            boolean isCamelCase = (this.matchRule & 0x80) != 0;
            int matchMode = this.matchRule & 7;
            boolean sameLength = pattern.length == name.length;
            boolean canBePrefix = name.length >= pattern.length;
            boolean bl = matchFirstChar = !isCaseSensitive || pattern.length == 0 || name.length > 0 && pattern[0] == name[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
                return true;
            }
            switch (matchMode) {
                case 0: 
                case 64: {
                    if (!isCamelCase) {
                        if (!sameLength || !matchFirstChar) break;
                        return CharOperation.equals(pattern, name, isCaseSensitive);
                    }
                }
                case 1: {
                    if (!canBePrefix || !matchFirstChar) break;
                    return CharOperation.prefixEquals(pattern, name, isCaseSensitive);
                }
                case 2: {
                    if (!isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, isCaseSensitive);
                }
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private static SearchPattern createTypePattern(String patternString, int limitTo, int matchRule, char indexSuffix) {
        char[] typePart = null;
        if (patternString != null) {
            typePart = patternString.toCharArray();
        }
        char[] typeChars = null;
        char[] qualificationChars = null;
        int lastDotPosition = CharOperation.lastIndexOf("::", typePart);
        if (lastDotPosition >= 0) {
            qualificationChars = CharOperation.subarray(typePart, 0, lastDotPosition);
            if (qualificationChars.length == 1 && qualificationChars[0] == '*') {
                qualificationChars = null;
            }
            typeChars = CharOperation.subarray(typePart, lastDotPosition + 2, typePart.length);
        } else {
            typeChars = typePart;
        }
        if (typeChars != null && typeChars.length == 1 && typeChars[0] == '*') {
            typeChars = null;
        }
        switch (limitTo) {
            case 0: {
                return new QualifiedTypeDeclarationPattern(qualificationChars, typeChars, indexSuffix, matchRule);
            }
            case 1: {
                return new TypeReferencePattern(qualificationChars, typeChars, matchRule);
            }
            case 2: {
                return new OrPattern(new QualifiedTypeDeclarationPattern(qualificationChars, typeChars, indexSuffix, matchRule), new TypeReferencePattern(qualificationChars, typeChars, matchRule));
            }
        }
        return null;
    }

    private static SearchPattern createMethodOrConstructorPattern(String patternString, int limitTo, int matchRule, boolean isConstructor) {
        MethodPatternParser parser = new MethodPatternParser();
        parser.parse(patternString);
        char[] selectorChars = parser.getSelector();
        char[][] parameterNames = parser.getParameterNames();
        char[] declaringTypeSimpleName = parser.getTypeSimpleName();
        char[] declaringTypeQualification = parser.getQualifiedTypeName();
        boolean findDeclarations = true;
        boolean findReferences = true;
        switch (limitTo) {
            case 0: {
                findReferences = false;
                break;
            }
            case 1: {
                findDeclarations = false;
                break;
            }
        }
        if (isConstructor) {
            return new ConstructorPattern(findDeclarations, findReferences, declaringTypeSimpleName, declaringTypeQualification, parameterNames, matchRule);
        }
        return new MethodPattern(findDeclarations, findReferences, selectorChars, declaringTypeQualification, declaringTypeSimpleName, parameterNames, matchRule);
    }

    public static final boolean camelCaseMatch(String pattern, String name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return SearchPattern.camelCaseMatch(pattern, 0, pattern.length(), name, 0, name.length());
    }

    public static final boolean camelCaseMatch(String pattern, int patternStart, int patternEnd, String name, int nameStart, int nameEnd) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length();
        }
        if (nameEnd < 0) {
            nameEnd = name.length();
        }
        if (patternEnd <= patternStart) {
            return nameEnd <= nameStart;
        }
        if (nameEnd <= nameStart) {
            return false;
        }
        if (name.charAt(nameStart) != pattern.charAt(patternStart)) {
            return false;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        block0: while (true) {
            char nameChar;
            ++iName;
            if (++iPattern == patternEnd) {
                return true;
            }
            if (iName == nameEnd) {
                return false;
            }
            char patternChar = pattern.charAt(iPattern);
            if (patternChar == name.charAt(iName)) continue;
            if (patternChar < '\u0080' ? (ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[patternChar] & 0x20) == 0 : Character.isJavaIdentifierPart(patternChar) && !Character.isUpperCase(patternChar)) {
                return false;
            }
            while (true) {
                if (iName == nameEnd) {
                    return false;
                }
                nameChar = name.charAt(iName);
                if (nameChar < '\u0080') {
                    if ((ScannerHelper.OBVIOUS_IDENT_CHAR_NATURES[nameChar] & 0x94) != 0) {
                        ++iName;
                        continue;
                    }
                    if (patternChar == nameChar) continue block0;
                    return false;
                }
                if (!Character.isJavaIdentifierPart(nameChar) || Character.isUpperCase(nameChar)) break;
                ++iName;
            }
            if (patternChar != nameChar) break;
        }
        return false;
    }

    public static int validateMatchRule(String stringPattern, int matchRule) {
        if ((matchRule & 4) != 0 && ((matchRule & 2) != 0 || (matchRule & 1) != 0 || (matchRule & 0x80) != 0)) {
            return -1;
        }
        int starIndex = stringPattern.indexOf(42);
        int questionIndex = stringPattern.indexOf(63);
        matchRule = starIndex < 0 && questionIndex < 0 ? (matchRule &= 0xFFFFFFFD) : (matchRule |= 2);
        if ((matchRule & 2) != 0) {
            matchRule &= 0xFFFFFF7F;
            matchRule &= 0xFFFFFFFE;
        }
        if ((matchRule & 0x80) != 0) {
            int length = stringPattern.length();
            boolean validCamelCase = true;
            boolean uppercase = false;
            int i = 0;
            while (i < length && validCamelCase) {
                char ch = stringPattern.charAt(i);
                validCamelCase = ScannerHelper.isJavaIdentifierStart(ch);
                if (!uppercase) {
                    uppercase = ScannerHelper.isUpperCase(ch);
                }
                ++i;
            }
            boolean bl = validCamelCase = validCamelCase && uppercase;
            if (validCamelCase) {
                if ((matchRule & 1) != 0 && (matchRule & 8) != 0) {
                    matchRule &= 0xFFFFFFFE;
                    matchRule &= 0xFFFFFFF7;
                }
            } else if (((matchRule &= 0xFFFFFF7F) & 1) == 0) {
                matchRule |= 1;
                matchRule |= 8;
            }
        }
        return matchRule;
    }

    public static SearchPattern createPattern(String stringPattern, int searchFor, int limitTo, int matchRule) {
        if (stringPattern == null || stringPattern.length() == 0) {
            return null;
        }
        if ((matchRule = SearchPattern.validateMatchRule(stringPattern, matchRule)) == -1) {
            return null;
        }
        switch (searchFor) {
            case 4: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'C');
            }
            case 5: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, 'M');
            }
            case 0: {
                return SearchPattern.createTypePattern(stringPattern, limitTo, matchRule, '\u0000');
            }
            case 1: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, false);
            }
            case 2: {
                return SearchPattern.createMethodOrConstructorPattern(stringPattern, limitTo, matchRule, true);
            }
            case 3: {
                return SearchPattern.createFieldPattern(stringPattern, limitTo, matchRule);
            }
        }
        return null;
    }

    public static SearchPattern createPattern(IRubyElement element, int limitTo, int matchRule) {
        SearchPattern searchPattern = null;
        boolean ignoreDeclaringType = true;
        int maskedLimitTo = limitTo;
        if (maskedLimitTo == 0 || maskedLimitTo == 2) {
            ignoreDeclaringType = (limitTo & 0x10) != 0;
        }
        char[] declaringSimpleName = null;
        char[] declaringQualification = null;
        switch (element.getElementType()) {
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                IField field = (IField)element;
                if (!ignoreDeclaringType) {
                    IType declaringClass = field.getDeclaringType();
                    declaringSimpleName = declaringClass.getElementName().toCharArray();
                    declaringQualification = declaringClass.getSourceFolder().getElementName().toCharArray();
                    char[][] enclosingNames = SearchPattern.enclosingTypeNames(declaringClass);
                    if (enclosingNames.length > 0) {
                        declaringQualification = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '.'), '.');
                    }
                }
                char[] name = field.getElementName().toCharArray();
                boolean findDeclarations = false;
                boolean readAccess = false;
                boolean writeAccess = false;
                switch (maskedLimitTo) {
                    case 0: {
                        findDeclarations = true;
                        break;
                    }
                    case 1: {
                        readAccess = true;
                        writeAccess = true;
                        break;
                    }
                    case 3: {
                        readAccess = true;
                        break;
                    }
                    case 4: {
                        writeAccess = true;
                        break;
                    }
                    case 2: {
                        findDeclarations = true;
                        readAccess = true;
                        writeAccess = true;
                    }
                }
                searchPattern = new FieldPattern(findDeclarations, readAccess, writeAccess, name, declaringQualification, declaringSimpleName, matchRule);
                break;
            }
            case 8: {
                String elementName = element.getElementName();
                int lastDot = elementName.lastIndexOf(46);
                if (lastDot == -1) {
                    return null;
                }
                IImportDeclaration cfr_ignored_0 = (IImportDeclaration)element;
                searchPattern = SearchPattern.createTypePattern(elementName.substring(lastDot + 1).toCharArray(), elementName.substring(0, lastDot).toCharArray(), null, null, null, maskedLimitTo, matchRule);
                break;
            }
            case 12: {
                LocalVariable localVar = (LocalVariable)element;
                boolean findVarDeclarations = false;
                boolean findVarReadAccess = false;
                boolean findVarWriteAccess = false;
                switch (maskedLimitTo) {
                    case 0: {
                        findVarDeclarations = true;
                        break;
                    }
                    case 1: {
                        findVarReadAccess = true;
                        findVarWriteAccess = true;
                        break;
                    }
                    case 3: {
                        findVarReadAccess = true;
                        break;
                    }
                    case 4: {
                        findVarWriteAccess = true;
                        break;
                    }
                    case 2: {
                        findVarDeclarations = true;
                        findVarReadAccess = true;
                        findVarWriteAccess = true;
                    }
                }
                searchPattern = new LocalVariablePattern(findVarDeclarations, findVarReadAccess, findVarWriteAccess, localVar, matchRule);
                break;
            }
            case 6: {
                String[] parameterNames;
                IMethod method = (IMethod)element;
                boolean isConstructor = method.isConstructor();
                IType declaringClass = method.getDeclaringType();
                if (ignoreDeclaringType) {
                    if (isConstructor) {
                        declaringSimpleName = declaringClass.getElementName().toCharArray();
                    }
                } else {
                    declaringSimpleName = declaringClass.getElementName().toCharArray();
                    declaringQualification = declaringClass.getSourceFolder().getElementName().toCharArray();
                    char[][] enclosingNames = SearchPattern.enclosingTypeNames(declaringClass);
                    if (enclosingNames.length > 0) {
                        declaringQualification = CharOperation.concat(declaringQualification, CharOperation.concatWith(enclosingNames, '.'), '.');
                    }
                }
                char[] selector = method.getElementName().toCharArray();
                try {
                    parameterNames = method.getParameterNames();
                }
                catch (RubyModelException rubyModelException) {
                    return null;
                }
                int paramCount = parameterNames.length;
                char[][] parameterSimpleNames = new char[paramCount][];
                int i = 0;
                while (i < paramCount) {
                    parameterSimpleNames[i] = parameterNames[i].toCharArray();
                    ++i;
                }
                boolean findMethodDeclarations = true;
                boolean findMethodReferences = true;
                switch (maskedLimitTo) {
                    case 0: {
                        findMethodReferences = false;
                        break;
                    }
                    case 1: {
                        findMethodDeclarations = false;
                        break;
                    }
                }
                if (isConstructor) {
                    searchPattern = new ConstructorPattern(findMethodDeclarations, findMethodReferences, declaringSimpleName, declaringQualification, parameterSimpleNames, method, matchRule);
                    break;
                }
                searchPattern = new MethodPattern(findMethodDeclarations, findMethodReferences, selector, declaringQualification, declaringSimpleName, (char[][])parameterSimpleNames, method, matchRule);
                break;
            }
            case 5: {
                IType type = (IType)element;
                searchPattern = SearchPattern.createTypePattern(type.getElementName().toCharArray(), type.getSourceFolder().getElementName().toCharArray(), ignoreDeclaringType ? null : SearchPattern.enclosingTypeNames(type), null, type, maskedLimitTo, matchRule);
            }
        }
        if (searchPattern != null) {
            MatchLocator.setFocus(searchPattern, element);
        }
        return searchPattern;
    }

    private static SearchPattern createTypePattern(char[] simpleName, char[] packageName, char[][] enclosingTypeNames, String typeSignature, IType type, int limitTo, int matchRule) {
        switch (limitTo) {
            case 0: {
                return new TypeDeclarationPattern(packageName, enclosingTypeNames, simpleName, '\u0000', matchRule);
            }
            case 1: {
                return new TypeReferencePattern(CharOperation.concatWith(enclosingTypeNames, "::"), simpleName, matchRule);
            }
            case 2: {
                return new OrPattern(new TypeDeclarationPattern(packageName, enclosingTypeNames, simpleName, '\u0000', matchRule), new TypeReferencePattern(CharOperation.concatWith(enclosingTypeNames, "::"), simpleName, matchRule));
            }
        }
        return null;
    }

    private static char[][] enclosingTypeNames(IType type) {
        IRubyElement parent = type.getParent();
        switch (parent.getElementType()) {
            case 4: {
                return CharOperation.NO_CHAR_CHAR;
            }
            case 6: 
            case 15: {
                IType declaringClass = ((IMember)parent).getDeclaringType();
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames(declaringClass), new char[][]{declaringClass.getElementName().toCharArray(), IIndexConstants.ONE_STAR});
            }
            case 5: {
                return CharOperation.arrayConcat(SearchPattern.enclosingTypeNames((IType)parent), parent.getElementName().toCharArray());
            }
        }
        return null;
    }
}

