/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.index.EntryResult;
import org.rubypeople.rdt.internal.core.search.HandleFactory;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.indexing.InternalSearchDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchDocument
extends InternalSearchDocument {
    private static HandleFactory factory = new HandleFactory();
    private IRubyScript script;
    private String documentPath;
    private SearchParticipant participant;

    public SearchDocument(String documentPath, SearchParticipant participant) {
        this.documentPath = documentPath;
        this.participant = participant;
    }

    @Override
    public void addIndexEntry(char[] category, char[] key) {
        super.addIndexEntry(category, key);
    }

    @Override
    public void removeAllIndexEntries() {
        super.removeAllIndexEntries();
    }

    public Set<String> getElementNamesOfType(int type) {
        HashSet<String> names = new HashSet<String>();
        try {
            EntryResult[] results = this.index.query(new char[][]{this.getCategory(type)}, new char[]{'*'}, 2);
            int i = 0;
            while (i < results.length) {
                String name = new String(results[i].getWord());
                names.add(name);
                ++i;
            }
        }
        catch (IOException e) {
            RubyCore.log(e);
        }
        return names;
    }

    public List<IRubyElement> getElementsOfType(int type) {
        IRubyScript script = this.getScript();
        return this.getChildrenOfType(script, type);
    }

    private IRubyScript getScript() {
        if (this.script == null) {
            Openable openable = factory.createOpenable(this.documentPath);
            this.script = (IRubyScript)((Object)openable);
        }
        return this.script;
    }

    @Override
    public final String getPath() {
        return this.documentPath;
    }

    private List<IRubyElement> getChildrenOfType(IParent parent, int type) {
        ArrayList<IRubyElement> elements = new ArrayList<IRubyElement>();
        if (parent == null) {
            return elements;
        }
        try {
            IRubyElement[] children = parent.getChildren();
            if (children == null) {
                return elements;
            }
            int i = 0;
            while (i < children.length) {
                if (children[i].isType(type)) {
                    elements.add(children[i]);
                }
                if (children[i] instanceof IParent) {
                    IParent childParent = (IParent)((Object)children[i]);
                    elements.addAll(this.getChildrenOfType(childParent, type));
                }
                ++i;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return elements;
    }

    public void removeElement(IRubyElement element) {
    }

    public void addElement(IRubyElement element) {
        this.addIndexEntry(this.getCategory(element), element.getElementName().toCharArray());
    }

    private char[] getCategory(IRubyElement element) {
        return this.getCategory(element.getElementType());
    }

    private char[] getCategory(int elementType) {
        switch (elementType) {
            case 5: {
                return IIndexConstants.TYPE_DECL;
            }
            case 6: {
                return IIndexConstants.METHOD_DECL;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return IIndexConstants.FIELD_DECL;
            }
        }
        return new char[0];
    }

    public IType findType(String name) {
        return (IType)this.findElement(5, name);
    }

    private IRubyElement findElement(int type, String name) {
        IRubyScript script = this.getScript();
        List<IRubyElement> children = this.getChildrenOfType(script, type);
        for (IRubyElement element : children) {
            if (!element.getElementName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public abstract char[] getCharContents();

    public final SearchParticipant getParticipant() {
        return this.participant;
    }
}

