/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReturnVisitor
extends InOrderVisitor {
    private boolean implicit = false;
    private Set<ReturnVisitor> branches = new HashSet<ReturnVisitor>();
    private List<Node> values = new ArrayList<Node>();
    private Node lastNode;

    @Override
    protected Instruction visitNode(Node iVisited) {
        if (!(iVisited == null || this.structuralNode(iVisited) || this.branchingNode(iVisited) || iVisited instanceof ReturnNode)) {
            this.implicit = true;
            this.lastNode = iVisited;
        }
        return super.visitNode(iVisited);
    }

    private boolean structuralNode(Node visited) {
        return visited instanceof RootNode || visited instanceof NewlineNode;
    }

    private boolean branchingNode(Node visited) {
        return visited instanceof IfNode || visited instanceof CaseNode;
    }

    @Override
    public Instruction visitReturnNode(ReturnNode iVisited) {
        this.implicit = false;
        this.lastNode = null;
        this.values.add((Node)iVisited);
        return null;
    }

    @Override
    public Instruction visitCaseNode(CaseNode iVisited) {
        Node node = iVisited.getFirstWhenNode();
        Object whenNode = (WhenNode)node;
        while (whenNode != null) {
            ReturnVisitor visitor = new ReturnVisitor();
            whenNode.getBodyNode().accept((NodeVisitor)visitor);
            this.branches.add(visitor);
            Node nextCase = whenNode.getNextCase();
            if (nextCase instanceof BlockNode) {
                ReturnVisitor visitor2 = new ReturnVisitor();
                nextCase.accept((NodeVisitor)visitor2);
                this.branches.add(visitor);
                whenNode = null;
                break;
            }
            if (nextCase instanceof NewlineNode) {
                NewlineNode newline = (NewlineNode)nextCase;
                nextCase = newline.getNextNode();
            }
            whenNode = nextCase instanceof WhenNode ? (WhenNode)whenNode.getNextCase() : null;
        }
        return null;
    }

    @Override
    public Instruction visitIfNode(IfNode iVisited) {
        ReturnVisitor visitor;
        if (iVisited.getThenBody() != null) {
            visitor = new ReturnVisitor();
            iVisited.getThenBody().accept((NodeVisitor)visitor);
            this.branches.add(visitor);
        }
        if (iVisited.getElseBody() != null) {
            visitor = new ReturnVisitor();
            iVisited.getElseBody().accept((NodeVisitor)visitor);
            this.branches.add(visitor);
        } else {
            this.implicit = true;
        }
        return null;
    }

    public boolean alwaysExplicit() {
        for (ReturnVisitor visitor : this.branches) {
            if (visitor.alwaysExplicit()) continue;
            return false;
        }
        return !this.implicit;
    }

    public List<Node> getReturnValues() {
        if (this.lastNode != null) {
            this.values.add(this.lastNode);
        }
        for (ReturnVisitor visitor : this.branches) {
            this.values.addAll(visitor.getReturnValues());
        }
        return this.values;
    }
}

