/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core.compiler;

import java.util.List;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.compiler.BuildContext;
import org.rubypeople.rdt.core.compiler.CategorizedProblem;
import org.rubypeople.rdt.core.compiler.ReconcileContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompilationParticipant {
    public static int READY_FOR_BUILD = 1;
    public static int NEEDS_FULL_BUILD = 2;

    public int aboutToBuild(IRubyProject project) {
        return READY_FOR_BUILD;
    }

    public void buildStarting(BuildContext[] files, boolean isBatch) {
    }

    public void cleanStarting(IRubyProject project) {
    }

    public boolean isActive(IRubyProject project) {
        return false;
    }

    public boolean isAnnotationProcessor() {
        return false;
    }

    public void processAnnotations(BuildContext[] files) {
    }

    public void reconcile(ReconcileContext context) {
    }

    protected void addProblems(ReconcileContext context, String type, List<CategorizedProblem> problems) {
        if (problems == null || problems.size() == 0) {
            return;
        }
        CategorizedProblem[] oldProblems = context.getProblems(type);
        if (oldProblems == null || oldProblems.length == 0) {
            context.putProblems(type, problems.toArray(new CategorizedProblem[problems.size()]));
            return;
        }
        CategorizedProblem[] combined = new CategorizedProblem[problems.size() + oldProblems.length];
        int i = 0;
        while (i < oldProblems.length) {
            combined[i] = oldProblems[i];
            ++i;
        }
        int j = oldProblems.length;
        for (CategorizedProblem problem : problems) {
            combined[j++] = problem;
        }
        context.putProblems(type, combined);
    }
}

