/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.ILoadpathAttribute;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRegion;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.LoadpathVariableInitializer;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.WorkingCopyOwner;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.TypeNameRequestor;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.core.BatchOperation;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.LoadpathAttribute;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.Region;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.SetExecutableBits;
import org.rubypeople.rdt.internal.core.SetLoadpathOperation;
import org.rubypeople.rdt.internal.core.util.MementoTokenizer;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ti.DataFlowTypeInferrer;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyCore
extends Plugin {
    private static RubyCore RUBY_CORE_PLUGIN = null;
    public static final String PLUGIN_ID = "org.rubypeople.rdt.core";
    public static final String NATURE_ID = "org.rubypeople.rdt.core.rubynature";
    public static final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    public static final String DEFAULT_TASK_TAGS = "TODO,FIXME,XXX,OPTIMIZE";
    public static final String BUILDER_ID = "org.rubypeople.rdt.core.rubybuilder";
    public static final String DEFAULT_TASK_PRIORITIES = "NORMAL,HIGH,NORMAL,NORMAL";
    public static final String COMPILER_TASK_PRIORITIES = "org.rubypeople.rdt.core.compiler.taskPriorities";
    public static final String COMPILER_TASK_PRIORITY_HIGH = "HIGH";
    public static final String COMPILER_TASK_PRIORITY_LOW = "LOW";
    public static final String COMPILER_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String COMPILER_TASK_TAGS = "org.rubypeople.rdt.core.compiler.taskTags";
    public static final String COMPILER_TASK_CASE_SENSITIVE = "org.rubypeople.rdt.core.compiler.taskCaseSensitive";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public static final String CORE_ENCODING = "org.rubypeople.rdt.core.encoding";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String RUBY_SOURCE_CONTENT_TYPE = "org.rubypeople.rdt.core.rubySource";
    public static final String COMPILER_PB_EMPTY_STATEMENT = "org.rubypeople.rdt.core.compiler.problem.emptyStatement";
    public static final String COMPILER_PB_CONSTANT_REASSIGNMENT = "org.rubypeople.rdt.core.compiler.problem.constantReassignment";
    public static final String COMPILER_PB_UNREACHABLE_CODE = "org.rubypeople.rdt.core.compiler.problem.unreachableCode";
    public static final String COMPILER_PB_REDEFINITION_CORE_CLASS_METHOD = "org.rubypeople.rdt.core.compiler.problem.redefinition.core.class.method";
    public static final String COMPILER_PB_RUBY_19_WHEN_STATEMENTS = "org.rubypeople.rdt.core.compiler.problem.ruby19WhenStatements";
    public static final String COMPILER_PB_RUBY_19_HASH_COMMA_SYTNAX = "org.rubypeople.rdt.core.compiler.problem.ruby19HashCommaSyntax";
    public static final String CODEASSIST_CAMEL_CASE_MATCH = "org.rubypeople.rdt.core.codeComplete.camelCaseMatch";
    public static final String CORE_INCOMPLETE_CLASSPATH = "org.rubypeople.rdt.core.incompleteClasspath";
    public static final String CORE_INCOMPATIBLE_JDK_LEVEL = "org.rubypeople.rdt.core.incompatibleJDKLevel";
    public static final String CORE_CIRCULAR_CLASSPATH = "org.rubypeople.rdt.core.circularClasspath";
    public static final String USER_LIBRARY_CONTAINER_ID = "org.rubypeople.rdt.USER_LIBRARY";
    private static final boolean VERBOSE = false;
    private RubyProjectListener fProjectListener;

    public RubyCore() {
        RUBY_CORE_PLUGIN = this;
    }

    public static RubyCore getPlugin() {
        return RUBY_CORE_PLUGIN;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fProjectListener = new RubyProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fProjectListener, 1);
        RubyModelManager.getRubyModelManager().startup();
        new SetExecutableBits().schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProjectListener);
            RubyModelManager.getRubyModelManager().shutdown();
        }
        finally {
            super.stop(context);
        }
    }

    public static void trace(String message) {
        if (RubyCore.getPlugin().isDebugging()) {
            System.out.println(message);
        }
    }

    public static void log(Exception e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = "";
        }
        RubyCore.log(4, msg, e);
    }

    public static void log(String string) {
        RubyCore.log(1, string);
    }

    public static void log(int severity, String string) {
        RubyCore.log(severity, string, null);
    }

    public static void log(int severity, String string, Throwable e) {
        RubyCore.getPlugin().getLog().log((IStatus)new Status(severity, PLUGIN_ID, 0, string, e));
    }

    public static String getOSDirectory(Plugin plugin) {
        Bundle bundle = plugin.getBundle();
        String location = bundle.getLocation();
        int prefixLength = location.indexOf(64);
        if (prefixLength == -1) {
            throw new RuntimeException("Location of launching bundle does not contain @: " + location);
        }
        String pluginDir = location.substring(prefixLength + 1);
        File pluginDirFile = new File(pluginDir);
        if (!pluginDirFile.exists()) {
            File installFile;
            String installArea = System.getProperty("osgi.install.area");
            if (installArea.startsWith("file:")) {
                installArea = installArea.substring("file:".length());
            }
            if (!(pluginDirFile = new File(installFile = new File(new Path(installArea).toOSString()), pluginDir)).exists()) {
                throw new RuntimeException("Unable to find (" + pluginDirFile + ") directory for " + plugin.getClass());
            }
        }
        return String.valueOf(pluginDirFile.getAbsolutePath()) + "/";
    }

    public static IProject[] getRubyProjects() {
        ArrayList<IProject> rubyProjectsList = new ArrayList<IProject>();
        IProject[] workspaceProjects = RubyCore.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject iProject = workspaceProjects[i];
            if (RubyCore.isRubyProject(iProject)) {
                rubyProjectsList.add(iProject);
            }
            ++i;
        }
        IProject[] rubyProjects = new IProject[rubyProjectsList.size()];
        return rubyProjectsList.toArray(rubyProjects);
    }

    public static boolean isRubyProject(IProject aProject) {
        try {
            return aProject.hasNature(NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IRubyScript create(IFile file) {
        return RubyModelManager.create(file, null);
    }

    public static IRubyProject create(IProject project) {
        if (project == null) {
            return null;
        }
        RubyModel rubyModel = RubyModelManager.getRubyModelManager().getRubyModel();
        return rubyModel.getRubyProject((IResource)project);
    }

    public static void addRubyNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = NATURE_ID;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    public static IRubyElement create(IResource resource) {
        return RubyModelManager.create(resource, null);
    }

    public static IRubyModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return RubyModelManager.getRubyModelManager().getRubyModel();
    }

    public static void run(IWorkspaceRunnable action, ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), rule, 1, monitor);
        }
    }

    public static String getOption(String optionName) {
        return RubyModelManager.getRubyModelManager().getOption(optionName);
    }

    public static String getEncoding() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            try {
                return workspace.getRoot().getDefaultCharset();
            }
            catch (CoreException coreException) {}
        }
        return ResourcesPlugin.getEncoding();
    }

    public static ITypeInferrer getTypeInferrer() {
        return new DataFlowTypeInferrer();
    }

    public static Hashtable<String, String> getOptions() {
        return RubyModelManager.getRubyModelManager().getOptions();
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        RubyCore.addElementChangedListener(listener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        RubyModelManager.getRubyModelManager().deltaState.addElementChangedListener(listener, eventMask);
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        RubyModelManager.getRubyModelManager().deltaState.removeElementChangedListener(listener);
    }

    public static RubyCore getRubyCore() {
        return RubyCore.getPlugin();
    }

    public static boolean isRubyLikeFileName(String name) {
        return org.rubypeople.rdt.internal.core.util.Util.isRubyLikeFileName(name);
    }

    public static ILoadpathEntry newSourceEntry(IPath path) {
        return RubyCore.newSourceEntry(path, LoadpathEntry.INCLUDE_ALL, LoadpathEntry.EXCLUDE_NONE, LoadpathEntry.NO_EXTRA_ATTRIBUTES);
    }

    public static ILoadpathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, ILoadpathAttribute[] extraAttributes) {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Source path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for ILoadpathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            Assert.isTrue((boolean)false, (String)"Exclusion pattern set cannot be null");
        }
        if (inclusionPatterns == null) {
            Assert.isTrue((boolean)false, (String)"Inclusion pattern set cannot be null");
        }
        return new LoadpathEntry(3, path, inclusionPatterns, exclusionPatterns, extraAttributes, false);
    }

    public static ILoadpathEntry newLibraryEntry(IPath path, ILoadpathAttribute[] extraAttributes, boolean isExported) {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Library path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for ILoadpathEntry must be absolute");
        }
        return new LoadpathEntry(1, RubyProject.canonicalizedPath(path), LoadpathEntry.INCLUDE_ALL, LoadpathEntry.EXCLUDE_NONE, extraAttributes, isExported);
    }

    public static ILoadpathEntry newProjectEntry(IPath path, ILoadpathAttribute[] extraAttributes, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for ILoadpathEntry must be absolute");
        }
        return new LoadpathEntry(2, path, LoadpathEntry.INCLUDE_ALL, LoadpathEntry.EXCLUDE_NONE, extraAttributes, isExported);
    }

    public static ILoadpathEntry newVariableEntry(IPath variablePath, ILoadpathAttribute[] extraAttributes, boolean isExported) {
        if (variablePath == null) {
            Assert.isTrue((boolean)false, (String)"Variable path cannot be null");
        }
        if (variablePath.segmentCount() < 1) {
            Assert.isTrue((boolean)false, (String)("Illegal loadpath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment"));
        }
        return new LoadpathEntry(4, variablePath, LoadpathEntry.INCLUDE_ALL, LoadpathEntry.EXCLUDE_NONE, extraAttributes, isExported);
    }

    public static ILoadpathEntry newContainerEntry(IPath containerPath, ILoadpathAttribute[] extraAttributes, boolean isExported) {
        if (containerPath == null) {
            Assert.isTrue((boolean)false, (String)"Container path cannot be null");
        } else if (containerPath.segmentCount() < 1) {
            Assert.isTrue((boolean)false, (String)("Illegal loadpath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)"));
        }
        return new LoadpathEntry(5, containerPath, LoadpathEntry.INCLUDE_ALL, LoadpathEntry.EXCLUDE_NONE, extraAttributes, isExported);
    }

    public static ILoadpathEntry getResolvedLoadpathEntry(ILoadpathEntry entry) {
        IResource resolvedResource;
        if (entry.getEntryKind() != 4) {
            return entry;
        }
        IPath resolvedPath = RubyCore.getResolvedVariablePath(entry.getPath());
        if (resolvedPath == null) {
            return null;
        }
        Object target = RubyModel.getTarget(resolvedPath, false);
        if (target == null) {
            return null;
        }
        if (target instanceof IResource && (resolvedResource = (IResource)target) != null) {
            switch (resolvedResource.getType()) {
                case 4: {
                    return RubyCore.newProjectEntry(resolvedPath, entry.getExtraAttributes(), entry.isExported());
                }
                case 2: {
                    return RubyCore.newLibraryEntry(resolvedPath, entry.getExtraAttributes(), entry.isExported());
                }
            }
        }
        if (target instanceof File) {
            File externalFile = RubyModel.getFolder(target);
            if (externalFile != null) {
                return RubyCore.newLibraryEntry(resolvedPath, entry.getExtraAttributes(), entry.isExported());
            }
            if (resolvedPath.isAbsolute()) {
                return RubyCore.newLibraryEntry(resolvedPath, entry.getExtraAttributes(), entry.isExported());
            }
        }
        return null;
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath[] resolvedPaths = RubyCore.getLoadpathVariable(variableName);
        if (resolvedPaths == null) {
            return null;
        }
        if (count > 1) {
            int i = 0;
            while (i < resolvedPaths.length) {
                resolvedPaths[i] = resolvedPaths[i].append(variablePath.removeFirstSegments(1));
                ++i;
            }
        }
        IPath resolvedPath = null;
        Object target = null;
        int i = 0;
        while (i < resolvedPaths.length) {
            File targetFile;
            target = RubyModel.getTarget(resolvedPaths[i], false);
            if (target instanceof File && !(targetFile = (File)target).exists()) {
                target = null;
            }
            if (target != null) {
                resolvedPath = resolvedPaths[i];
                break;
            }
            ++i;
        }
        if (target == null) {
            RubyCore.log(1, "Was unable to resolve path: " + variablePath.toPortableString());
            return null;
        }
        return resolvedPath;
    }

    public static IPath[] getLoadpathVariable(String variableName) {
        IPath[] variablePath;
        block18: {
            RubyModelManager manager = RubyModelManager.getRubyModelManager();
            variablePath = manager.variableGet(variableName);
            if (variablePath == RubyModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                return manager.getPreviousSessionVariable(variableName);
            }
            if (variablePath != null) {
                if (variablePath == RubyModelManager.CP_ENTRY_IGNORE_PATH) {
                    return null;
                }
                return variablePath;
            }
            LoadpathVariableInitializer initializer = RubyCore.getLoadpathVariableInitializer(variableName);
            if (initializer != null) {
                if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                    org.rubypeople.rdt.internal.core.util.Util.verbose("CPVariable INIT - triggering initialization\n\tvariable: " + variableName + '\n' + "\tinitializer: " + initializer + '\n' + "\tinvocation stack trace:");
                    new Exception("<Fake exception>").printStackTrace(System.out);
                }
                manager.variablePut(variableName, RubyModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS);
                boolean ok = false;
                try {
                    initializer.initialize(variableName);
                    variablePath = manager.variableGet(variableName);
                    if (variablePath == RubyModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                        return null;
                    }
                    try {
                        if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                            org.rubypeople.rdt.internal.core.util.Util.verbose("CPVariable INIT - after initialization\n\tvariable: " + variableName + '\n' + "\tvariable path: " + variablePath);
                        }
                        manager.variablesWithInitializer.add(variableName);
                        ok = true;
                        break block18;
                    }
                    catch (RuntimeException e) {
                        if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                            e.printStackTrace();
                        }
                        throw e;
                    }
                    catch (Error e) {
                        if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                            e.printStackTrace();
                        }
                        throw e;
                    }
                }
                finally {
                    if (!ok) {
                        RubyModelManager.getRubyModelManager().variablePut(variableName, null);
                    }
                }
            }
            if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                org.rubypeople.rdt.internal.core.util.Util.verbose("CPVariable INIT - no initializer found\n\tvariable: " + variableName);
            }
        }
        return variablePath;
    }

    public static LoadpathVariableInitializer getLoadpathVariableInitializer(String variable) {
        RubyCore jdtCorePlugin = RubyCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "loadpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    block9: {
                        try {
                            String varAttribute = configElements[j].getAttribute("variable");
                            if (variable.equals(varAttribute)) {
                                Object execExt;
                                if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                                    org.rubypeople.rdt.internal.core.util.Util.verbose("CPVariable INIT - found initializer\n\tvariable: " + variable + '\n' + "\tclass: " + configElements[j].getAttribute("class"));
                                }
                                if ((execExt = configElements[j].createExecutableExtension("class")) instanceof LoadpathVariableInitializer) {
                                    return (LoadpathVariableInitializer)execExt;
                                }
                            }
                        }
                        catch (CoreException e) {
                            if (!RubyModelManager.CP_RESOLVE_VERBOSE) break block9;
                            org.rubypeople.rdt.internal.core.util.Util.verbose("CPContainer INIT - failed to instanciate initializer\n\tvariable: " + variable + '\n' + "\tclass: " + configElements[j].getAttribute("class"), System.err);
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static ILoadpathContainer getLoadpathContainer(IPath containerPath, IRubyProject project) throws RubyModelException {
        RubyModelManager manager = RubyModelManager.getRubyModelManager();
        ILoadpathContainer container = manager.getLoadpathContainer(containerPath, project);
        if (container == RubyModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
            return manager.getPreviousSessionContainer(containerPath, project);
        }
        return container;
    }

    public static LoadpathContainerInitializer getLoadpathContainerInitializer(String containerID) {
        HashMap<String, LoadpathContainerInitializer> containerInitializersCache = RubyModelManager.getRubyModelManager().containerInitializersCache;
        LoadpathContainerInitializer initializer = containerInitializersCache.get(containerID);
        if (initializer == null) {
            initializer = RubyCore.computeLoadpathContainerInitializer(containerID);
            if (initializer == null) {
                return null;
            }
            containerInitializersCache.put(containerID, initializer);
        }
        return initializer;
    }

    private static LoadpathContainerInitializer computeLoadpathContainerInitializer(String containerID) {
        RubyCore jdtCorePlugin = RubyCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "loadpathContainerInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    block9: {
                        String initializerID = configElements[j].getAttribute("id");
                        if (initializerID != null && initializerID.equals(containerID)) {
                            if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                                org.rubypeople.rdt.internal.core.util.Util.verbose("CPContainer INIT - found initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configElements[j].getAttribute("class"));
                            }
                            try {
                                Object execExt = configElements[j].createExecutableExtension("class");
                                if (execExt instanceof LoadpathContainerInitializer) {
                                    return (LoadpathContainerInitializer)execExt;
                                }
                            }
                            catch (CoreException e) {
                                if (!RubyModelManager.CP_RESOLVE_VERBOSE) break block9;
                                org.rubypeople.rdt.internal.core.util.Util.verbose("CPContainer INIT - failed to instanciate initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configElements[j].getAttribute("class"), System.err);
                                e.printStackTrace();
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void setLoadpathContainer(final IPath containerPath, IRubyProject[] affectedProjects, ILoadpathContainer[] respectiveContainers, IProgressMonitor monitor) throws RubyModelException {
        if (affectedProjects.length != respectiveContainers.length) {
            Assert.isTrue((boolean)false, (String)"Projects and containers collections should have the same size");
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (RubyModelManager.CP_RESOLVE_VERBOSE) {
            org.rubypeople.rdt.internal.core.util.Util.verbose("CPContainer SET  - setting container\n\tcontainer path: " + containerPath + '\n' + "\tprojects: {" + Util.toString(affectedProjects, new Util.Displayable(){

                public String displayString(Object o) {
                    return ((IRubyProject)o).getElementName();
                }
            }) + "}\n\tvalues: {\n" + Util.toString(respectiveContainers, new Util.Displayable(){

                public String displayString(Object o) {
                    StringBuffer buffer = new StringBuffer("\t\t");
                    if (o == null) {
                        buffer.append("<null>");
                        return buffer.toString();
                    }
                    ILoadpathContainer container = (ILoadpathContainer)o;
                    buffer.append(container.getDescription());
                    buffer.append(" {\n");
                    ILoadpathEntry[] entries = container.getLoadpathEntries();
                    if (entries != null) {
                        int i = 0;
                        while (i < entries.length) {
                            buffer.append(" \t\t\t");
                            buffer.append(entries[i]);
                            buffer.append('\n');
                            ++i;
                        }
                    }
                    buffer.append(" \t\t}");
                    return buffer.toString();
                }
            }) + "\n\t}\n\tinvocation stack trace:");
            new Exception("<Fake exception>").printStackTrace(System.out);
        }
        if ((manager = RubyModelManager.getRubyModelManager()).containerPutIfInitializingWithSameEntries(containerPath, affectedProjects, respectiveContainers)) {
            return;
        }
        projectLength = affectedProjects.length;
        modifiedProjects = new IRubyProject[projectLength];
        System.arraycopy(affectedProjects, 0, modifiedProjects, 0, projectLength);
        oldResolvedPaths = new ILoadpathEntry[projectLength][];
        remaining = 0;
        i = 0;
        while (i < projectLength) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            affectedProject = (RubyProject)affectedProjects[i];
            newContainer = respectiveContainers[i];
            if (newContainer == null) {
                newContainer = RubyModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS;
            }
            found = false;
            if (RubyProject.hasRubyNature(affectedProject.getProject())) {
                rawClasspath = affectedProject.getRawLoadpath();
                j = 0;
                cpLength = rawClasspath.length;
                while (j < cpLength) {
                    entry = rawClasspath[j];
                    if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)containerPath)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                modifiedProjects[i] = null;
                manager.containerPut(affectedProject, containerPath, newContainer);
            } else {
                oldContainer = manager.containerGet(affectedProject, containerPath);
                if (oldContainer == RubyModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                    oldContainer = null;
                }
                if (oldContainer != null && oldContainer.equals(respectiveContainers[i])) {
                    modifiedProjects[i] = null;
                } else {
                    ++remaining;
                    oldResolvedPaths[i] = affectedProject.getResolvedLoadpath(true, false, false);
                    manager.containerPut(affectedProject, containerPath, newContainer);
                }
            }
            ++i;
        }
        if (remaining == 0) {
            return;
        }
        try {
            try {
                canChangeResources = ResourcesPlugin.getWorkspace().isTreeLocked() == false;
                RubyCore.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        int i = 0;
                        while (i < projectLength) {
                            if (progressMonitor != null && progressMonitor.isCanceled()) {
                                return;
                            }
                            RubyProject affectedProject = (RubyProject)modifiedProjects[i];
                            if (affectedProject != null) {
                                if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                                    org.rubypeople.rdt.internal.core.util.Util.verbose("CPContainer SET  - updating affected project due to setting container\n\tproject: " + affectedProject.getElementName() + '\n' + "\tcontainer path: " + containerPath);
                                }
                                affectedProject.setRawLoadpath(affectedProject.getRawLoadpath(), SetLoadpathOperation.DO_NOT_SET_OUTPUT, progressMonitor, canChangeResources, oldResolvedPaths[i], false, false);
                            }
                            ++i;
                        }
                    }
                }, null, monitor);
            }
            catch (CoreException e) {
                if (RubyModelManager.CP_RESOLVE_VERBOSE) {
                    org.rubypeople.rdt.internal.core.util.Util.verbose("CPContainer SET  - FAILED DUE TO EXCEPTION\n\tcontainer path: " + containerPath, System.err);
                    e.printStackTrace();
                }
                if (e instanceof RubyModelException) {
                    throw (RubyModelException)e;
                }
                throw new RubyModelException(e);
            }
        }
        finally {
            i = 0;
            ** while (i < projectLength)
        }
lbl-1000:
        // 1 sources

        {
            if (respectiveContainers[i] == null) {
                manager.containerPut(affectedProjects[i], containerPath, null);
            }
            ++i;
            continue;
        }
lbl72:
        // 1 sources

    }

    public static void setLoadpathVariable(String variableName, IPath[] path, IProgressMonitor monitor) throws RubyModelException {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Variable path cannot be null");
        }
        RubyCore.setLoadpathVariables(new String[]{variableName}, new IPath[][]{path}, monitor);
    }

    public static void setLoadpathVariables(String[] variableNames, IPath[][] paths, IProgressMonitor monitor) throws RubyModelException {
        if (variableNames.length != paths.length) {
            Assert.isTrue((boolean)false, (String)"Variable names and paths collections should have the same size");
        }
        RubyModelManager.getRubyModelManager().updateVariableValues(variableNames, paths, true, monitor);
    }

    public static ILoadpathEntry newProjectEntry(IPath fullPath) {
        return RubyCore.newProjectEntry(fullPath, LoadpathEntry.NO_EXTRA_ATTRIBUTES, false);
    }

    public static ILoadpathEntry newVariableEntry(IPath path) {
        return RubyCore.newVariableEntry(path, LoadpathEntry.NO_EXTRA_ATTRIBUTES, false);
    }

    public static ILoadpathEntry newContainerEntry(IPath path) {
        return RubyCore.newContainerEntry(path, LoadpathEntry.NO_EXTRA_ATTRIBUTES, false);
    }

    public static ILoadpathEntry newLibraryEntry(IPath p) {
        return RubyCore.newLibraryEntry(p, LoadpathEntry.NO_EXTRA_ATTRIBUTES, false);
    }

    public static ILoadpathAttribute newLoadpathAttribute(String name, String value) {
        return new LoadpathAttribute(name, value);
    }

    public static ILoadpathEntry newLibraryEntry(IPath path, boolean isExported) {
        return RubyCore.newLibraryEntry(path, LoadpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static ILoadpathEntry newVariableEntry(IPath path, boolean isExported) {
        return RubyCore.newVariableEntry(path, LoadpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static ILoadpathEntry newProjectEntry(IPath path, boolean isExported) {
        return RubyCore.newProjectEntry(path, LoadpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static ILoadpathEntry newContainerEntry(IPath path, boolean isExported) {
        return RubyCore.newContainerEntry(path, LoadpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static IRubyElement create(String handleIdentifier) {
        return RubyCore.create(handleIdentifier, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IRubyElement create(String handleIdentifier, WorkingCopyOwner owner) {
        if (handleIdentifier == null) {
            return null;
        }
        MementoTokenizer memento = new MementoTokenizer(handleIdentifier);
        RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
        return model.getHandleFromMemento(memento, owner);
    }

    public static ILoadpathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return RubyCore.newSourceEntry(path, LoadpathEntry.INCLUDE_ALL, exclusionPatterns, LoadpathEntry.NO_EXTRA_ATTRIBUTES);
    }

    public static IRubyScript createRubyScriptFrom(IFile file) {
        return RubyModelManager.createRubyScriptFrom(file, null);
    }

    public static IRegion newRegion() {
        return new Region();
    }

    public static String[] getLoadpathVariableNames() {
        return RubyModelManager.getRubyModelManager().variableNames();
    }

    public static void initializeAfterLoad(IProgressMonitor monitor) throws CoreException {
        try {
            block10: {
                if (monitor != null) {
                    monitor.beginTask(Messages.javamodel_initialization, 100);
                }
                SearchEngine engine = new SearchEngine();
                IRubySearchScope scope = SearchEngine.createWorkspaceScope();
                try {
                    engine.searchAllTypeNames(null, "!@$#!@".toCharArray(), 10, 4, scope, new TypeNameRequestor(){

                        public void acceptType(boolean isModule, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                        }
                    }, 2, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 99)));
                }
                catch (RubyModelException rubyModelException) {
                }
                catch (OperationCanceledException e) {
                    if (monitor == null || !monitor.isCanceled()) break block10;
                    throw e;
                }
            }
            RubyModel model = RubyModelManager.getRubyModelManager().getRubyModel();
            try {
                model.refreshExternalArchives(null, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 1)));
            }
            catch (RubyModelException rubyModelException) {}
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static IPath checkSystemPath(String exe) {
        String systemPath = System.getenv("PATH");
        if (systemPath == null) {
            return null;
        }
        String[] paths = systemPath.split(File.pathSeparator);
        return RubyCore.checkDirs(exe, paths);
    }

    public static IPath checkCommonBinLocations(String exe) {
        if (Platform.getOS().equals("win32")) {
            return null;
        }
        String[] paths = new String[]{"/opt/local/bin", "/usr/local/bin", "/usr/sbin", "/usr/bin", "/sbin", "/bin"};
        return RubyCore.checkDirs(exe, paths);
    }

    private static IPath checkDirs(String exe, String[] paths) {
        int i = 0;
        while (i < paths.length) {
            IPath path = new Path(paths[i]).append(exe);
            if (path.toFile().exists()) {
                return path;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File copyToStateLocation(Plugin plugin, IPath fileName) {
        OutputStream out;
        InputStream stream;
        IPath path;
        block26: {
            path = plugin.getStateLocation().append(fileName);
            if (path.toFile().exists()) {
                return path.toFile();
            }
            stream = null;
            out = null;
            URL url = RubyCore.getFileURL(plugin, fileName);
            stream = url.openStream();
            if (path.toFile().getParentFile().exists() || path.toFile().getParentFile().mkdirs()) break block26;
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out == null) return null;
                out.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        try {
            try {
                path.toFile().createNewFile();
                byte[] bytes = Util.getInputStreamAsByteArray(stream, -1);
                out = new FileOutputStream(path.toFile());
                out.write(bytes);
            }
            catch (IOException e) {
                RubyCore.log(e);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (out == null) return path.toFile();
                    out.close();
                    return path.toFile();
                }
                catch (IOException iOException) {}
                return path.toFile();
            }
        }
        catch (Throwable throwable) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (out == null) return path.toFile();
            out.close();
            return path.toFile();
        }
        catch (IOException iOException) {}
        return path.toFile();
    }

    private static URL getFileURL(Plugin plugin, IPath fileName) {
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)fileName, null);
        if (url == null) {
            throw new RuntimeException("Expected file " + fileName + " does not exist: " + fileName.toPortableString());
        }
        return url;
    }

    private static class RubyProjectListener
    implements IResourceChangeListener {
        private RubyProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event == null) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            this.checkDelta(delta);
        }

        private void checkDelta(IResourceDelta delta) {
            if (delta == null) {
                return;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                final IProject project = (IProject)resource;
                if (!RubyProject.hasRubyNature(project)) {
                    IResourceProxyVisitor visitor = new IResourceProxyVisitor(){
                        private boolean added = false;

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getType() == 1 && RubyCore.isRubyLikeFileName(proxy.getName())) {
                                Job job = new Job("Add Ruby Nature"){

                                    protected IStatus run(IProgressMonitor monitor) {
                                        try {
                                            RubyCore.addRubyNature(project, monitor);
                                        }
                                        catch (CoreException e) {
                                            RubyCore.log((Exception)((Object)e));
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.schedule(500L);
                                this.added = true;
                            }
                            return !this.added;
                        }
                    };
                    try {
                        project.accept(visitor, 0);
                    }
                    catch (CoreException e) {
                        RubyCore.log((Exception)((Object)e));
                    }
                }
                IResourceDelta[] children = delta.getAffectedChildren();
                int i = 0;
                while (i < children.length) {
                    this.checkDelta(children[i]);
                    ++i;
                }
            }
        }
    }
}

