/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.cloud.internal;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.server.cloud.syncing.ICloudDeployer;
import com.aptana.radrails.cloud.Activator;
import com.aptana.radrails.cloud.deploy.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EndpointDialog
extends TitleAreaDialog {
    private static final String LARGE_IMAGE = "icons/deploy_large.gif";
    private ICloudDeployer.Endpoint target;
    private Combo combo;
    private Image image;
    private Text comment;
    private String commentStr;

    public EndpointDialog(Shell parentShell, ICloudDeployer.Endpoint target) {
        super(parentShell);
        this.target = target;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.setMessage(Messages.EndpointDialog_MSG_Verify_and_select_target);
        Composite container = new Composite(area, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDeployOptionSection(container);
        this.createCommentSection(container);
        if (this.target == ICloudDeployer.Endpoint.PUBLIC) {
            this.combo.setText(Messages.EndpointDialog_LBL_Public_endpoint);
        } else if (this.target == ICloudDeployer.Endpoint.STAGING) {
            this.combo.setText(Messages.EndpointDialog_LBL_Staging_endpoint);
        }
        this.setTitle(Messages.EndpointDialog_TTL_Header);
        ImageDescriptor iconDesc = Activator.imageDescriptorFromPlugin((String)"com.aptana.radrails.cloud", (String)LARGE_IMAGE);
        this.image = iconDesc.createImage();
        this.setTitleImage(this.image);
        return area;
    }

    private void createDeployOptionSection(Composite container) {
        Composite deployComp = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        deployComp.setLayout((Layout)layout);
        Label deployTo = new Label(deployComp, 0);
        deployTo.setText(Messages.EndpointDialog_LBL_Deploy_to);
        this.combo = new Combo(deployComp, 12);
        this.combo.add(Messages.EndpointDialog_LBL_Public_endpoint);
        this.combo.add(Messages.EndpointDialog_LBL_Staging_endpoint);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = EndpointDialog.this.combo.getItem(EndpointDialog.this.combo.getSelectionIndex());
                if (selection.equals(Messages.EndpointDialog_LBL_Public_endpoint)) {
                    EndpointDialog.this.target = ICloudDeployer.Endpoint.PUBLIC;
                } else {
                    EndpointDialog.this.target = ICloudDeployer.Endpoint.STAGING;
                }
                EndpointDialog.this.setTitle(MessageFormat.format(Messages.EndpointDialog_TTL_Header, selection));
            }
        });
        GridData deployLayoutData = new GridData();
        deployLayoutData.horizontalSpan = 2;
        deployComp.setLayoutData((Object)deployLayoutData);
    }

    private Composite createCommentSection(Composite parent) {
        Composite commentArea = new Composite(parent, 0);
        commentArea.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        commentArea.setLayout((Layout)layout);
        Label commentLabel = new Label(commentArea, 1);
        commentLabel.setText(Messages.EndpointDialog_MSG_Enter_deploy_comment);
        GridData commentLabelGridData = new GridData(1, 0x1000000, false, false);
        commentLabel.setLayoutData((Object)commentLabelGridData);
        Link helpLink = new Link(commentArea, 0x1000008);
        helpLink.setText(Messages.EndpointDialog_MSG_Help_link);
        GridData helpLinkGridData = new GridData(0x1000008, 0x1000000, true, false);
        helpLink.setLayoutData((Object)helpLinkGridData);
        helpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL((String)"http://www.aptana.com/docs/index.php/My_Cloud_-_Team#What_is_the_Cloud_Team_Comment_feature.3F");
            }
        });
        this.comment = new Text(commentArea, 2050);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 50;
        this.comment.setLayoutData((Object)gridData);
        this.comment.setEnabled(true);
        this.comment.setText("");
        this.comment.selectAll();
        this.comment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EndpointDialog.this.commentStr = EndpointDialog.this.comment.getText();
            }
        });
        return commentArea;
    }

    public boolean close() {
        if (this.image != null) {
            this.image.dispose();
        }
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.getButton(0).setText(Messages.EndpointDialog_LBL_Deploy_button);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EndpointDialog_TTL);
    }

    protected Point getInitialSize() {
        return new Point(500, 350);
    }

    public ICloudDeployer.Endpoint getEndpoint() {
        return this.target;
    }

    public String getComment() {
        return this.commentStr;
    }
}

