/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.radrails.cloud.internal;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.server.cloud.services.model.studio.StudioSite;
import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.Version;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CloudUtil {
    private static final String APTANA_SITE_ENV = "APTANA_SITE";
    private static final String APTANA_PASSWORD_ENV = "APTANA_PASSWORD";
    private static final String APTANA_ID_ENV = "APTANA_ID";
    private static final String MINIMUM_RUBYGEMS_VERSION = "1.3.1";
    private static final String MINIMUM_APCLOUD_GEM_VERSION = "1.0.8";
    private static final String ADD_APTANA_GEMS_SOURCE_COMMAND = "sources -a http://gems.aptana.com";
    private static final String APCLOUD_GEM_NAME = "aptana_cloud";
    public static final String CAPFILE = "Capfile";

    public static IStatus installCloudGemIfNecessary(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Installing aptana_cloud gem", 100);
        IGemManager gemManager = AptanaRDTPlugin.getDefault().getGemManager();
        if (gemManager == null) {
            return new Status(4, "com.aptana.radrails.cloud", -1, "Unable to find a gem manager.", null);
        }
        monitor.worked(5);
        if (gemManager.gemInstalled(APCLOUD_GEM_NAME)) {
            return CloudUtil.updateApcloudGem(gemManager, monitor);
        }
        monitor.worked(10);
        IStatus result = null;
        if (CloudUtil.rubygemsOutOfDate(gemManager)) {
            result = CloudUtil.upgradeRubyGems(gemManager, monitor);
        }
        monitor.worked(35);
        if (result != null && !result.isOK()) {
            return result;
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        result = CloudUtil.addAptanaSource(gemManager, monitor);
        subMonitor.done();
        if (!result.isOK()) {
            return result;
        }
        subMonitor = new SubProgressMonitor(monitor, 45);
        result = gemManager.installGem(new Gem(APCLOUD_GEM_NAME, "", null), (IProgressMonitor)subMonitor);
        subMonitor.done();
        return result;
    }

    private static boolean rubygemsOutOfDate(IGemManager gemManager) {
        Version rubygemsVersion = gemManager.getVersion();
        return rubygemsVersion == null || rubygemsVersion.isLessThan(MINIMUM_RUBYGEMS_VERSION);
    }

    private static IStatus upgradeRubyGems(IGemManager gemManager, IProgressMonitor monitor) {
        return gemManager.updateSystem(monitor);
    }

    private static IStatus updateApcloudGem(IGemManager gemManager, IProgressMonitor monitor) {
        if (CloudUtil.minimumApcloudVersionInstalled(gemManager)) {
            return Status.OK_STATUS;
        }
        IStatus result = gemManager.update(new Gem(APCLOUD_GEM_NAME, "", null), monitor);
        if (result != null && !result.isOK()) {
            return result;
        }
        if (!CloudUtil.minimumApcloudVersionInstalled(gemManager)) {
            return new Status(4, "com.aptana.radrails.cloud", -1, "Failed to update aptana_cloud gem to 1.0.8", null);
        }
        return Status.OK_STATUS;
    }

    private static boolean minimumApcloudVersionInstalled(IGemManager gemManager) {
        List versions = gemManager.getVersions(APCLOUD_GEM_NAME);
        for (Version version : versions) {
            if (!version.isGreaterThanOrEqualTo(MINIMUM_APCLOUD_GEM_VERSION)) continue;
            return true;
        }
        return false;
    }

    private static IStatus addAptanaSource(IGemManager gemManager, IProgressMonitor monitor) {
        try {
            ILaunchConfiguration config = gemManager.run(ADD_APTANA_GEMS_SOURCE_COMMAND);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, ADD_APTANA_GEMS_SOURCE_COMMAND);
            config = wc.doSave();
            ILaunch launch = config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            while (!launch.isTerminated()) {
                if (monitor.isCanceled()) {
                    launch.terminate();
                    return Status.CANCEL_STATUS;
                }
                Thread.yield();
            }
            if (launch.getProcesses() != null && launch.getProcesses()[0] != null && launch.getProcesses()[0].getExitValue() != 0) {
                return new Status(4, "com.aptana.radrails.cloud", -1, "Adding http://gems.aptana.com as a gem source failed", null);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public static Map<String, String> getEnvMap(StudioSite site) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        User user = AptanaUser.getSignedInUser();
        if (user != null) {
            envMap.put(APTANA_ID_ENV, user.getUsername());
            envMap.put(APTANA_PASSWORD_ENV, user.getPassword());
        }
        if (site != null) {
            envMap.put(APTANA_SITE_ENV, site.getId());
        }
        return envMap;
    }

    public static ILaunch run(String command, String args, IProject project, Map<String, String> envMap, boolean forceRefresh) throws CoreException {
        return CloudUtil.run(command, args, project, envMap, forceRefresh, false);
    }

    public static ILaunch run(String command, String args, IProject project, Map<String, String> envMap, boolean forceRefresh, boolean isSudo) throws CoreException {
        String commandLine = String.valueOf(command) + ' ' + args;
        String workingDirectory = null;
        if (project != null) {
            workingDirectory = project.getLocation().toFile().getAbsolutePath();
        }
        String fileName = RailsShellCommandProvider.getFileIfExists((String)command, workingDirectory, (IProject)project);
        ILaunchConfigurationType configType = CloudUtil.getRubyApplicationConfigType();
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, CloudUtil.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(commandLine));
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, fileName);
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        if (envMap != null && !envMap.isEmpty()) {
            wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
            wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envMap);
        }
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, commandLine);
        if (project != null) {
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
        if (workingDirectory != null) {
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, workingDirectory);
        }
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_IS_SUDO, false);
        wc.setAttribute("org.eclipse.debug.ui.private", true);
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        if (forceRefresh) {
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH, true);
        }
        wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
        ILaunchConfiguration config = wc.doSave();
        return config.launch("run", (IProgressMonitor)new NullProgressMonitor());
    }

    private static ILaunchConfigurationType getRubyApplicationConfigType() {
        return CloudUtil.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

