/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.launching;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.ui.RailsUIPlugin;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;

public class RailsAppLaunchHelper {
    public static void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject curSel = RailsUIPlugin.getInstance().getSelectedRailsProject();
        String defaultProject = null;
        if (curSel != null) {
            defaultProject = curSel.getName();
        } else {
            Set projects = RailsPlugin.getRailsProjects();
            if (projects.size() > 0) {
                defaultProject = ((IProject)projects.iterator().next()).getName();
            }
        }
        if (defaultProject != null) {
            configuration.setAttribute("org.radrails.server.core.launching.project_name", defaultProject);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(defaultProject);
            Collection servers = ServerManager.getInstance().getServersForProject(project);
            Server s = null;
            if (!servers.isEmpty()) {
                s = (Server)servers.iterator().next();
            }
            if (s != null) {
                configuration.setAttribute("org.radrails.server.core.launching.server_name", s.getName());
            }
        }
        configuration.setAttribute("org.radrails.server.core.launching.launch_browser", true);
        configuration.setAttribute("org.radrails.server.core.launching.internal_browser", true);
    }
}

