/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.launching;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.radrails.rails.ui.browser.BrowserUtil;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.radrails.server.internal.ui.ServerUILog;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ComboDialogField;

public class RailsAppLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project;
        Server s = this.getServerForLaunch(configuration);
        if (s == null && (project = this.getProject(configuration)) != null) {
            Collection servers = ServerManager.getInstance().getServersForProject(project);
            ServerChoiceRunnable runnable = new ServerChoiceRunnable(servers);
            Display.getDefault().syncExec((Runnable)runnable);
            s = runnable.getServer();
            if (s != null) {
                try {
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("org.radrails.server.core.launching.server_name", s.getName());
                    wc.doSave();
                }
                catch (CoreException e) {
                    ServerUILog.log((CoreException)e);
                }
            }
        }
        if (s != null) {
            if (s.isStopped()) {
                s.updateRunMode(mode);
                s.start(false);
            }
            if (configuration.getAttribute("org.radrails.server.core.launching.launch_browser", false)) {
                LaunchBrowserThread t = new LaunchBrowserThread(s, configuration);
                if (s.isStarted()) {
                    t.started();
                } else {
                    ServerManager.getInstance().addServerObserver((Observer)t);
                }
            }
        }
    }

    private Server getServerForLaunch(ILaunchConfiguration config) {
        IProject project;
        block5: {
            Server s;
            String serverName = config.getAttribute("org.radrails.server.core.launching.server_name", "");
            if (serverName != null && serverName.trim().length() > 0 && (s = ServerManager.getInstance().getServer(serverName)) != null) {
                return s;
            }
            project = this.getProject(config);
            if (project != null) break block5;
            return null;
        }
        try {
            Collection servers = ServerManager.getInstance().getServersForProject(project);
            if (servers != null && servers.size() == 1) {
                return (Server)servers.iterator().next();
            }
        }
        catch (CoreException e) {
            ServerUILog.logError((String)"error reading launch config attributes", (Throwable)e);
        }
        return null;
    }

    private IProject getProject(ILaunchConfiguration config) throws CoreException {
        String projectName = config.getAttribute("org.radrails.server.core.launching.project_name", null);
        if (projectName == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private String getLaunchUrl(Server server, ILaunchConfiguration config) throws CoreException {
        String baseUrl = "http://" + server.getBrowserHost() + ":" + server.getPort();
        String actionUrl = config.getAttribute("org.radrails.server.core.launching.action_path", "");
        if (!actionUrl.startsWith("/")) {
            actionUrl = "/" + actionUrl;
        }
        return String.valueOf(baseUrl) + actionUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChooseServerDialog
    extends Dialog {
        private Collection<Server> servers;
        private ComboDialogField serverField;

        protected ChooseServerDialog(Shell parentShell, Collection<Server> servers) {
            super(parentShell);
            this.servers = servers;
            this.serverField = new ComboDialogField(12);
            this.serverField.setLabelText("Server:");
            String[] names = new String[servers.size()];
            int i = 0;
            for (Server server : servers) {
                names[i++] = server.getName();
            }
            this.serverField.setItems(names);
            this.serverField.setText(servers.iterator().next().getName());
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Choose server");
        }

        public Server getServer() {
            String name = this.serverField.getText();
            for (Server server : this.servers) {
                if (!server.getName().equals(name)) continue;
                return server;
            }
            return null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite control = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            control.setLayout((Layout)layout);
            Label label = new Label(control, 64);
            label.setText("We are unable to find the server previously associated with this launch. Please choose one of the existing servers to use for launching this Rails Application.");
            GridData data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 300;
            label.setLayoutData((Object)data);
            this.serverField.doFillIntoGrid(control, 2);
            return composite;
        }
    }

    private class LaunchBrowserThread
    implements Observer {
        private Server server;
        private ILaunchConfiguration config;

        public LaunchBrowserThread(Server s, ILaunchConfiguration c) {
            this.server = s;
            this.config = c;
        }

        public void started() {
            try {
                this.launchBrowser(this.server, this.config);
            }
            catch (CoreException e) {
                ServerUILog.logError((String)"Error launching browser", (Throwable)e);
            }
            catch (IOException e) {
                ServerUILog.logError((String)"Error launching browser", (Throwable)e);
            }
        }

        public void update(Observable arg0, Object arg1) {
            Server serv = (Server)arg0;
            String action = (String)arg1;
            if (serv.getName().equals(this.server.getName()) && action.equals("update") && serv.getStatus().equals("Started")) {
                this.started();
            }
        }

        private void launchBrowser(Server server, ILaunchConfiguration config) throws CoreException, IOException {
            final String launchUrl = RailsAppLaunchConfigurationDelegate.this.getLaunchUrl(server, config);
            ServerUILog.logInfo((String)("launching this url: " + launchUrl), null);
            if (config.getAttribute("org.radrails.server.core.launching.external_browser", false)) {
                String browserExe = config.getAttribute("org.radrails.server.core.launching.browser_exe", "");
                if (browserExe != null && !browserExe.equals("") && new File(browserExe).exists()) {
                    if (Platform.getOS().equals("macosx")) {
                        Runtime.getRuntime().exec(new String[]{"open", browserExe, launchUrl});
                    } else {
                        Runtime.getRuntime().exec(new String[]{browserExe, launchUrl});
                    }
                }
            } else if (config.getAttribute("org.radrails.server.core.launching.internal_browser", false)) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            BrowserUtil.openOrActivateBrowser((String)launchUrl);
                        }
                        catch (PartInitException e) {
                            ServerUILog.log((CoreException)((Object)e));
                        }
                        catch (MalformedURLException e) {
                            ServerUILog.log((Exception)e);
                        }
                    }
                });
            }
            ServerManager.getInstance().deleteServerObserver((Observer)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerChoiceRunnable
    implements Runnable {
        private Collection<Server> servers;
        private Server server;

        public ServerChoiceRunnable(Collection<Server> servers) {
            this.servers = servers;
        }

        @Override
        public void run() {
            ChooseServerDialog dialog = new ChooseServerDialog(Display.getDefault().getActiveShell(), this.servers);
            if (dialog.open() == 0) {
                this.server = dialog.getServer();
            }
        }

        public Server getServer() {
            return this.server;
        }
    }
}

