/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.internal.ui.launching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.radrails.server.internal.ui.ServerUILog;
import org.radrails.server.internal.ui.launching.RailsAppLaunchHelper;

public class MainSettingsTab
extends AbstractLaunchConfigurationTab {
    private Combo fServerCombo;
    private Combo fProjectCombo;
    private Listener fDirtyListener;
    private Text fBrowserText;
    private Text fActionText;
    private Button fNoBrowserRadio;
    private Button fInternalBrowserRadio;
    private Button fExternalBrowserRadio;
    private Button fBrowserTextBrowse;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        this.createSelectProjectArea(composite);
        this.createSelectServerArea(composite);
        this.createStartActionArea(composite);
        this.createBrowserArea(composite);
        this.fBrowserTextBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(MainSettingsTab.this.getShell(), 0);
                fileDialog.setFileName(MainSettingsTab.this.fBrowserText.getText());
                String text = fileDialog.open();
                if (text != null) {
                    MainSettingsTab.this.fBrowserText.setText(text);
                }
            }
        });
        this.fProjectCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MainSettingsTab.this.loadServersCombo();
            }
        });
        this.fNoBrowserRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MainSettingsTab.this.enableExternalBrowserWidgets(false);
                MainSettingsTab.this.enableActionWidgets(false);
            }
        });
        this.fExternalBrowserRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MainSettingsTab.this.enableExternalBrowserWidgets(true);
                MainSettingsTab.this.enableActionWidgets(true);
            }
        });
        this.fInternalBrowserRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MainSettingsTab.this.enableExternalBrowserWidgets(false);
                MainSettingsTab.this.enableActionWidgets(true);
            }
        });
        this.fDirtyListener = new Listener(){

            public void handleEvent(Event event) {
                MainSettingsTab.this.setDirty(true);
                MainSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.hookListeners(true);
    }

    private void createSelectProjectArea(Composite parent) {
        Group projectGroup = new Group(parent, 0);
        projectGroup.setText("Rails Application");
        GridData gd = new GridData(4, 20, true, false);
        projectGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        projectGroup.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 120;
        Label appLabel = new Label((Composite)projectGroup, 0);
        appLabel.setText("Application root:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        appLabel.setLayoutData((Object)data);
        this.fProjectCombo = new Combo((Composite)projectGroup, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)appLabel, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.width = 200;
        this.fProjectCombo.setLayoutData((Object)data);
        this.fProjectCombo.setItems(MainSettingsTab.getRailsProjectNames());
    }

    private static String[] getRailsProjectNames() {
        Set projects = RailsPlugin.getRailsProjects();
        ArrayList<String> ret = new ArrayList<String>();
        for (IProject project : projects) {
            if (!project.isAccessible()) continue;
            ret.add(project.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    private void createSelectServerArea(Composite parent) {
        Group serverGroup = new Group(parent, 0);
        serverGroup.setText("Web Server");
        GridData gd = new GridData(4, 20, true, false);
        serverGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        serverGroup.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 120;
        Label serverLabel = new Label((Composite)serverGroup, 0);
        serverLabel.setText("Server:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        serverLabel.setLayoutData((Object)data);
        this.fServerCombo = new Combo((Composite)serverGroup, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)serverLabel, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.width = 200;
        this.fServerCombo.setLayoutData((Object)data);
    }

    private void createStartActionArea(Composite parent) {
        Group actionGroup = new Group(parent, 0);
        actionGroup.setText("Start Action");
        GridData gd = new GridData(4, 20, true, false);
        actionGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        actionGroup.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 120;
        Label actionLabel = new Label((Composite)actionGroup, 0);
        actionLabel.setText("Action URL:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        actionLabel.setLayoutData((Object)data);
        this.fActionText = new Text((Composite)actionGroup, 18432);
        data = new FormData();
        data.top = new FormAttachment((Control)actionLabel, 0, 128);
        data.left = new FormAttachment(0, column2Offset);
        data.width = 200;
        this.fActionText.setLayoutData((Object)data);
    }

    private void createBrowserArea(Composite parent) {
        Group browserGroup = new Group(parent, 0);
        browserGroup.setText("Web Browser");
        GridData gd = new GridData(4, 20, true, false);
        browserGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        browserGroup.setLayout((Layout)form);
        form.marginTop = 10;
        form.marginBottom = 10;
        form.marginLeft = 10;
        form.marginRight = 10;
        int column1Offset = 0;
        int column2Offset = 120;
        this.fNoBrowserRadio = new Button((Composite)browserGroup, 16);
        this.fNoBrowserRadio.setText("Do not launch browser");
        FormData data = new FormData();
        data.left = new FormAttachment(0, column1Offset);
        this.fNoBrowserRadio.setLayoutData((Object)data);
        this.fInternalBrowserRadio = new Button((Composite)browserGroup, 16);
        this.fInternalBrowserRadio.setText("Use internal browser");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fNoBrowserRadio, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.fInternalBrowserRadio.setLayoutData((Object)data);
        this.fExternalBrowserRadio = new Button((Composite)browserGroup, 16);
        this.fExternalBrowserRadio.setText("Use external browser");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fInternalBrowserRadio, 10, 1024);
        data.left = new FormAttachment(0, column1Offset);
        this.fExternalBrowserRadio.setLayoutData((Object)data);
        this.fBrowserText = new Text((Composite)browserGroup, 18432);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fExternalBrowserRadio, 10, 1024);
        data.left = new FormAttachment(0, column2Offset);
        data.right = new FormAttachment(100, -100);
        data.width = 100;
        this.fBrowserText.setLayoutData((Object)data);
        Label browserLabel = new Label((Composite)browserGroup, 0);
        browserLabel.setText("Browser exe:");
        data = new FormData();
        data.right = new FormAttachment((Control)this.fBrowserText, -8, 16384);
        data.top = new FormAttachment((Control)this.fExternalBrowserRadio, 15, 1024);
        browserLabel.setLayoutData((Object)data);
        this.fBrowserTextBrowse = new Button((Composite)browserGroup, 8);
        this.fBrowserTextBrowse.setText("Browse...");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fExternalBrowserRadio, 10, 1024);
        data.left = new FormAttachment((Control)this.fBrowserText, 8, 131072);
        this.fBrowserTextBrowse.setLayoutData((Object)data);
    }

    private void enableExternalBrowserWidgets(boolean enabled) {
        this.fBrowserText.setEnabled(enabled);
    }

    private void enableActionWidgets(boolean enabled) {
        this.fActionText.setEnabled(enabled);
    }

    private void hookListeners(boolean hook) {
        if (hook) {
            this.fProjectCombo.addListener(24, this.fDirtyListener);
            this.fServerCombo.addListener(24, this.fDirtyListener);
            this.fNoBrowserRadio.addListener(13, this.fDirtyListener);
            this.fInternalBrowserRadio.addListener(13, this.fDirtyListener);
            this.fExternalBrowserRadio.addListener(13, this.fDirtyListener);
            this.fBrowserText.addListener(24, this.fDirtyListener);
            this.fActionText.addListener(24, this.fDirtyListener);
        } else {
            this.fProjectCombo.removeListener(24, this.fDirtyListener);
            this.fServerCombo.removeListener(24, this.fDirtyListener);
            this.fNoBrowserRadio.removeListener(13, this.fDirtyListener);
            this.fInternalBrowserRadio.removeListener(13, this.fDirtyListener);
            this.fExternalBrowserRadio.removeListener(13, this.fDirtyListener);
            this.fBrowserText.removeListener(24, this.fDirtyListener);
            this.fActionText.removeListener(24, this.fDirtyListener);
        }
    }

    private void loadServersCombo() {
        int index = this.fProjectCombo.getSelectionIndex();
        if (index == -1) {
            return;
        }
        String projectName = this.fProjectCombo.getItem(index);
        String[] serverNames = this.getServerNamesForProject(projectName);
        this.fServerCombo.setItems(serverNames);
        if (serverNames.length > 0) {
            this.fServerCombo.setText(serverNames[0]);
        }
    }

    private String[] getServerNamesForProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        Collection servers = ServerManager.getInstance().getServersForProject(project);
        ArrayList<String> ret = new ArrayList<String>();
        for (Server server : servers) {
            ret.add(server.getName());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block9: {
            this.hookListeners(false);
            this.fNoBrowserRadio.setSelection(false);
            this.fInternalBrowserRadio.setSelection(false);
            this.fExternalBrowserRadio.setSelection(false);
            this.fActionText.setText("");
            this.fBrowserText.setText("");
            try {
                try {
                    this.fProjectCombo.select(this.fProjectCombo.indexOf(configuration.getAttribute("org.radrails.server.core.launching.project_name", "")));
                    this.loadServersCombo();
                    this.fServerCombo.select(this.fServerCombo.indexOf(configuration.getAttribute("org.radrails.server.core.launching.server_name", "")));
                    if (configuration.getAttribute("org.radrails.server.core.launching.launch_browser", false)) {
                        this.fActionText.setText(configuration.getAttribute("org.radrails.server.core.launching.action_path", ""));
                        if (configuration.getAttribute("org.radrails.server.core.launching.internal_browser", false)) {
                            this.fInternalBrowserRadio.setSelection(true);
                            this.enableExternalBrowserWidgets(false);
                            this.enableActionWidgets(true);
                        } else if (configuration.getAttribute("org.radrails.server.core.launching.external_browser", false)) {
                            this.fExternalBrowserRadio.setSelection(true);
                            this.fBrowserText.setText(configuration.getAttribute("org.radrails.server.core.launching.browser_exe", ""));
                            this.enableExternalBrowserWidgets(true);
                            this.enableActionWidgets(true);
                        }
                        break block9;
                    }
                    this.fNoBrowserRadio.setSelection(true);
                    this.enableExternalBrowserWidgets(false);
                    this.enableActionWidgets(false);
                }
                catch (CoreException e) {
                    ServerUILog.logError((String)"error accessing default attributes", (Throwable)e);
                    this.hookListeners(true);
                }
            }
            finally {
                this.hookListeners(true);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fProjectCombo.getSelectionIndex() >= 0) {
            configuration.setAttribute("org.radrails.server.core.launching.project_name", this.fProjectCombo.getItem(this.fProjectCombo.getSelectionIndex()));
        }
        if (this.fServerCombo.getSelectionIndex() >= 0) {
            configuration.setAttribute("org.radrails.server.core.launching.server_name", this.fServerCombo.getItem(this.fServerCombo.getSelectionIndex()));
        }
        if (this.fNoBrowserRadio.getSelection()) {
            configuration.setAttribute("org.radrails.server.core.launching.launch_browser", false);
        } else {
            configuration.setAttribute("org.radrails.server.core.launching.launch_browser", true);
            configuration.setAttribute("org.radrails.server.core.launching.action_path", this.fActionText.getText());
            if (this.fInternalBrowserRadio.getSelection()) {
                configuration.setAttribute("org.radrails.server.core.launching.internal_browser", true);
            } else if (this.fExternalBrowserRadio.getSelection()) {
                configuration.setAttribute("org.radrails.server.core.launching.external_browser", true);
                configuration.setAttribute("org.radrails.server.core.launching.browser_exe", this.fBrowserText.getText());
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        RailsAppLaunchHelper.setDefaults(configuration);
    }
}

