/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.ui.launcher.RubyEntryPointTab;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestunitPlugin;
import org.rubypeople.rdt.internal.ui.util.FileSelector;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.testunit.launcher.RubyClassSelector;
import org.rubypeople.rdt.testunit.launcher.TestUnitLaunchConfigurationDelegate;

public class TestUnitMainTab
extends RubyEntryPointTab
implements ILaunchConfigurationTab {
    private RubyClassSelector classSelector;
    private Label classLabel;
    private Button allClassesCheckBox;
    private Button allMethodsCheckBox;
    private Label testLabel;
    private Text testMethodEditBox;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.allClassesCheckBox = new Button(this.composite, 32);
        this.allClassesCheckBox.setText(TestUnitMessages.LaunchConfigurationTab_RubyEntryPoint_allTestCases);
        this.allClassesCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
                TestUnitMainTab.this.setControlState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.classLabel = new Label(this.composite, 0);
        this.classLabel.setText(TestUnitMessages.LaunchConfigurationTab_RubyEntryPoint_classLabel);
        this.classSelector = new RubyClassSelector(this.composite, (FileSelector)this.fileSelector, this.projectSelector);
        this.classSelector.setBrowseDialogMessage(TestUnitMessages.LaunchConfigurationTab_RubyEntryPoint_classSelectorMessage);
        this.classSelector.setLayoutData(new GridData(768));
        this.classSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.allMethodsCheckBox = new Button(this.composite, 32);
        this.allMethodsCheckBox.setText(TestUnitMessages.LaunchConfigurationTab_RubyEntryPoint_allTestMethods);
        this.allMethodsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
                TestUnitMainTab.this.setControlState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.testLabel = new Label(this.composite, 0);
        this.testLabel.setText(TestUnitMessages.LaunchConfigurationTab_RubyEntryPoint_methodLabel);
        this.testMethodEditBox = new Text(this.composite, 2048);
        this.testMethodEditBox.setLayoutData((Object)new GridData(768));
        this.testMethodEditBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestUnitMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControlState();
    }

    private void setControlState() {
        boolean allClassesChecked = this.allClassesCheckBox.getSelection();
        boolean allMethodsChecked = this.allMethodsCheckBox.getSelection();
        this.classLabel.setEnabled(!allClassesChecked);
        this.classSelector.setEnabled(!allClassesChecked);
        this.allMethodsCheckBox.setEnabled(!allClassesChecked);
        this.testLabel.setEnabled(!allClassesChecked && !allMethodsChecked);
        this.testMethodEditBox.setEnabled(!allClassesChecked && !allMethodsChecked);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "");
        configuration.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", "");
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, TestUnitLaunchConfigurationDelegate.getTestRunnerPath());
        configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
    }

    protected String handleFileName(String filename) {
        if (filename == null || filename.trim().length() == 0) {
            return "";
        }
        IRubyElement element = RubyCore.create((String)filename);
        if (element == null) {
            return "";
        }
        IPath path = element.getPath();
        if (path.segment(0).equals(this.getProject().getName())) {
            return path.removeFirstSegments(1).toPortableString();
        }
        return path.toPortableString();
    }

    protected String modifyFileToLaunch(String path) {
        IPath duh;
        if (path == null || path.trim().length() == 0) {
            return "";
        }
        IRubyProject rubyproj = RubyCore.create((IProject)this.getProject());
        IPath projPath = rubyproj.getPath();
        if (projPath.isPrefixOf(duh = Path.fromOSString((String)path))) {
            duh = duh.removeFirstSegments(projPath.segmentCount());
        }
        IFile file = this.getProject().getFile(duh);
        IRubyScript element = RubyCore.create((IFile)file);
        return element.getHandleIdentifier();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String testClass = configuration.getAttribute("org.rubypeople.rdt.testunit.TESTTYPE", "");
            this.classSelector.setSelectionText(testClass);
            if (testClass.length() == 0) {
                this.allClassesCheckBox.setSelection(true);
            } else {
                String testMethod = configuration.getAttribute("org.rubypeople.rdt.testunit.TESTNAME", "");
                this.testMethodEditBox.setText(testMethod);
                if (testMethod.length() == 0) {
                    this.allMethodsCheckBox.setSelection(true);
                }
            }
            this.setControlState();
        }
        catch (CoreException e) {
            TestunitPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String testMethod = this.testMethodEditBox.getText();
        if (this.allMethodsCheckBox.getSelection()) {
            testMethod = "";
        }
        String testCaseClass = this.classSelector.getValidatedSelectionText();
        if (this.allClassesCheckBox.getSelection()) {
            testCaseClass = "";
            testMethod = "";
        }
        configuration.setAttribute("org.rubypeople.rdt.testunit.TESTNAME", testMethod);
        configuration.setAttribute("org.rubypeople.rdt.testunit.TESTTYPE", testCaseClass);
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, TestUnitLaunchConfigurationDelegate.getTestRunnerPath());
    }

    protected String getFileToLaunchAttribute() {
        return "org.rubypeople.rdt.testunit.CONTAINER";
    }

    public String getName() {
        return TestUnitMessages.JUnitMainTab_tab_label;
    }
}

