/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.ui.util.FileSelector;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;
import org.rubypeople.rdt.testunit.launcher.TestSearchEngine;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;

public class RubyClassSelector {
    protected static final String EMPTY_STRING = "";
    private Composite composite;
    private Button browseButton;
    private Text textField;
    protected String browseDialogMessage = "";
    protected String browseDialogTitle = "";
    protected String validatedSelectionText = "";
    private FileSelector fileSelector;
    private RubyProjectSelector projectSelector;

    public RubyClassSelector(Composite parent, FileSelector fileSelector, RubyProjectSelector projectSelector) {
        this.fileSelector = fileSelector;
        this.projectSelector = projectSelector;
        this.composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginWidth = 0;
        compositeLayout.marginHeight = 0;
        compositeLayout.numColumns = 2;
        this.composite.setLayout((Layout)compositeLayout);
        this.textField = new Text(this.composite, 2052);
        this.textField.setLayoutData((Object)new GridData(768));
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyClassSelector.this.validatedSelectionText = RubyClassSelector.this.validateResourceSelection();
            }
        });
        this.browseButton = new Button(this.composite, 8);
        this.browseButton.setText("Search...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RubyClassSelector.this.handleBrowseSelected();
            }
        });
        this.browseDialogTitle = TestUnitMessages.RubyClassSelector_Title;
    }

    protected void handleBrowseSelected() {
        Object[] types = this.getTypesInSelectedFile();
        if (types == null) {
            types = this.getTypesInSelectedProject();
        }
        if (types == null) {
            types = this.getAllTypes();
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new RubyElementLabelProvider());
        dialog.setElements(types);
        dialog.setTitle(this.browseDialogTitle);
        dialog.setMessage(this.browseDialogMessage);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            this.textField.setText(((IRubyElement)dialog.getFirstResult()).getElementName());
        }
    }

    private IType[] getTypesInSelectedProject() {
        IProject rubyProject = this.projectSelector.getSelection();
        if (rubyProject == null) {
            return null;
        }
        return TestSearchEngine.findTests(rubyProject);
    }

    private IType[] getTypesInSelectedFile() {
        String relativeFilePath = this.fileSelector.getValidatedSelectionText();
        if (relativeFilePath == null || relativeFilePath.trim().length() == 0) {
            return null;
        }
        IProject rubyProject = this.projectSelector.getSelection();
        if (rubyProject == null) {
            return null;
        }
        IFile file = rubyProject.getFile(relativeFilePath);
        return TestSearchEngine.findTests(file);
    }

    private IType[] getAllTypes() {
        ArrayList typeList = new ArrayList();
        IProject[] projects = RubyCore.getRubyProjects();
        int i = 0;
        while (i < projects.length) {
            IType[] types = TestSearchEngine.findTests(projects[i]);
            typeList.addAll(Arrays.asList(types));
            ++i;
        }
        IType[] allTypes = new IType[typeList.size()];
        System.arraycopy(typeList.toArray(), 0, allTypes, 0, allTypes.length);
        return allTypes;
    }

    protected String validateResourceSelection() {
        String selection = this.textField.getText();
        return selection == null ? EMPTY_STRING : selection;
    }

    protected Shell getShell() {
        return this.composite.getShell();
    }

    public void setLayoutData(Object layoutData) {
        this.composite.setLayoutData(layoutData);
    }

    public void addModifyListener(ModifyListener aListener) {
        this.textField.addModifyListener(aListener);
    }

    public void setBrowseDialogMessage(String aMessage) {
        this.browseDialogMessage = aMessage;
    }

    public void setBrowseDialogTitle(String aTitle) {
        this.browseDialogTitle = aTitle;
    }

    public void setEnabled(boolean enabled) {
        this.composite.setEnabled(enabled);
        this.textField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public String getSelectionText() {
        return this.textField.getText();
    }

    public String getValidatedSelectionText() {
        return this.validatedSelectionText;
    }

    public void setSelectionText(String newText) {
        this.textField.setText(newText);
    }
}

