/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.testunit.ui.OpenEditorAction;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private ISourceRange fRange;

    public OpenTestAction(TestUnitView testRunner, String className, String method) {
        this(testRunner, className, method, true);
    }

    public OpenTestAction(TestUnitView testRunner, String className) {
        this(testRunner, className, null);
    }

    public OpenTestAction(TestUnitView testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        this.fMethodName = method;
    }

    protected IRubyElement findElement(IRubyProject project, String className) throws RubyModelException {
        IType type = this.findType(project, className);
        if (type == null) {
            return null;
        }
        if (this.fMethodName == null) {
            return type;
        }
        IMethod method = this.findMethod(type);
        if (method == null) {
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] types = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < types.length) {
                method = this.findMethod(types[i]);
                if (method != null) break;
                ++i;
            }
        }
        if (method == null) {
            String title = TestUnitMessages.OpenTestAction_error_title;
            String message = Messages.format((String)TestUnitMessages.OpenTestAction_error_methodNoFound, (String)this.fMethodName);
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return type;
        }
        this.fRange = method.getNameRange();
        return method;
    }

    IMethod findMethod(IType type) {
        IStatus status = RubyConventions.validateMethodName((String)this.fMethodName);
        if (!status.isOK()) {
            return null;
        }
        IMethod method = type.getMethod(this.fMethodName, new String[0]);
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fRange != null) {
            textEditor.selectAndReveal(this.fRange.getOffset(), this.fRange.getLength());
        }
    }

    public boolean isEnabled() {
        try {
            return this.findType(this.getLaunchedProject(), this.getClassName()) != null;
        }
        catch (RubyModelException rubyModelException) {
            return false;
        }
    }
}

