/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitView;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenEditorAction
extends Action {
    protected String fClassName;
    protected TestUnitView fTestRunner;
    private final boolean fActivate;

    protected OpenEditorAction(TestUnitView testRunner, String testClassName) {
        this(testRunner, testClassName, true);
    }

    public OpenEditorAction(TestUnitView testRunner, String className, boolean activate) {
        super(TestUnitMessages.OpenEditorAction_action_label);
        this.fClassName = className;
        this.fTestRunner = testRunner;
        this.fActivate = activate;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IRubyElement element = this.findElement(this.getLaunchedProject(), this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)TestUnitMessages.OpenEditorAction_error_cannotopen_title, (String)TestUnitMessages.OpenEditorAction_error_cannotopen_message);
                return;
            }
            textEditor = (ITextEditor)EditorUtility.openInEditor((Object)element, (boolean)this.fActivate);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TestUnitMessages.OpenEditorAction_error_dialog_title, (String)TestUnitMessages.OpenEditorAction_error_dialog_message, (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fTestRunner.setInfoMessage(TestUnitMessages.OpenEditorAction_message_cannotopen);
            return;
        }
        this.reveal(textEditor);
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected IRubyProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected abstract IRubyElement findElement(IRubyProject var1, String var2) throws CoreException;

    protected abstract void reveal(ITextEditor var1);

    protected IType findType(IRubyProject project, String className) throws RubyModelException {
        return this.internalFindType(project, className, new HashSet<IRubyProject>());
    }

    private IType internalFindType(IRubyProject project, String className, Set<IRubyProject> visitedProjects) throws RubyModelException {
        if (visitedProjects.contains(project)) {
            return null;
        }
        IStatus status = RubyConventions.validateRubyTypeName((String)className);
        if (!status.isOK()) {
            return null;
        }
        IType type = project.findType(className, null);
        if (type != null) {
            return type;
        }
        visitedProjects.add(project);
        IRubyModel javaModel = project.getRubyModel();
        String[] requiredProjectNames = project.getRequiredProjectNames();
        int i = 0;
        while (i < requiredProjectNames.length) {
            IRubyProject requiredProject = javaModel.getRubyProject(requiredProjectNames[i]);
            if (requiredProject.exists() && (type = this.internalFindType(requiredProject, className, visitedProjects)) != null) {
                return type;
            }
            ++i;
        }
        return null;
    }
}

