/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.testunit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.testunit.ui.FailureTrace;
import org.rubypeople.rdt.internal.testunit.ui.TestUnitMessages;

public class CopyTraceAction
extends Action {
    private FailureTrace fView;
    private final Clipboard fClipboard;

    public CopyTraceAction(FailureTrace view, Clipboard clipboard) {
        super(TestUnitMessages.CopyTrace_action_label);
        Assert.isNotNull((Object)clipboard);
        this.fView = view;
        this.fClipboard = clipboard;
    }

    public void run() {
        block4: {
            String trace = this.fView.getTrace();
            if (trace == null) {
                trace = "";
            }
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.convertLineTerminators(trace)}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getComposite().getShell(), (String)TestUnitMessages.CopyTraceAction_problem, (String)TestUnitMessages.CopyTraceAction_clipboard_busy)) break block4;
                this.run();
            }
        }
    }

    private String convertLineTerminators(String in) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(in);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                printWriter.println(line);
            }
        }
        catch (IOException iOException) {
            return in;
        }
        return stringWriter.toString();
    }
}

