/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.parser.warnings;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsDeprecationOptions {
    public static final long RailsInstanceVariables = 1L;
    public static final long DeprecatedRenderCalls = 2L;
    public static final long DeprecatedRedirectCalls = 4L;
    public static final long DeprecatedPostFormatMethods = 8L;
    public static final long StartEndFormTag = 16L;
    public static final long UpdateElementFunction = 32L;
    public static final long ImageLinkMethods = 64L;
    public static final long HumanSizeHelperAlias = 128L;
    public static final long PushWithAttributes = 256L;
    public static final long DeprecatedFindMethods = 512L;
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public long errorThreshold = 0L;
    public long warningThreshold = 1023L;

    public Map<String, String> getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsInstanceVariable", this.getSeverityString(1L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationRenderCalls", this.getSeverityString(2L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationRedirectCalls", this.getSeverityString(4L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationPostFormat", this.getSeverityString(8L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationStartEndFormTag", this.getSeverityString(16L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationUpdateElementFunction", this.getSeverityString(32L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationImageLinkMethods", this.getSeverityString(64L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationHumanSizeHelperAlias", this.getSeverityString(128L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationPushWithAttributes", this.getSeverityString(256L));
        optionsMap.put("org.radrails.rails.core.compiler.problem.railsDeprecationActiveRecordFindMethods", this.getSeverityString(512L));
        return optionsMap;
    }

    public String getSeverityString(long irritant) {
        if ((this.warningThreshold & irritant) != 0L) {
            return WARNING;
        }
        if ((this.errorThreshold & irritant) != 0L) {
            return ERROR;
        }
        return IGNORE;
    }

    public void set(Map optionsMap) {
        Object optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsInstanceVariable");
        if (optionValue != null) {
            this.updateSeverity(1L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationRenderCalls")) != null) {
            this.updateSeverity(2L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationRedirectCalls")) != null) {
            this.updateSeverity(4L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationPostFormat")) != null) {
            this.updateSeverity(8L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationStartEndFormTag")) != null) {
            this.updateSeverity(16L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationUpdateElementFunction")) != null) {
            this.updateSeverity(32L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationImageLinkMethods")) != null) {
            this.updateSeverity(64L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationHumanSizeHelperAlias")) != null) {
            this.updateSeverity(128L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationPushWithAttributes")) != null) {
            this.updateSeverity(256L, optionValue);
        }
        if ((optionValue = optionsMap.get("org.radrails.rails.core.compiler.problem.railsDeprecationActiveRecordFindMethods")) != null) {
            this.updateSeverity(512L, optionValue);
        }
    }

    void updateSeverity(long irritant, Object severityString) {
        if (ERROR.equals(severityString)) {
            this.errorThreshold |= irritant;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (WARNING.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold |= irritant;
        } else if (IGNORE.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }
}

