/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.parser.warnings;

import org.jruby.ast.FCallNode;
import org.jruby.ast.VCallNode;
import org.jruby.evaluator.Instruction;
import org.radrails.rails.internal.core.RailsPlugin;
import org.rubypeople.rdt.core.parser.warnings.RubyLintVisitor;

public abstract class DeprecationVisitor
extends RubyLintVisitor {
    private String[] deprecated;
    private String[] solutions;

    public DeprecationVisitor(String[] deprecated, String solution) {
        super(RailsPlugin.getInstance().getOptions(), "");
        this.deprecated = deprecated;
        this.solutions = new String[deprecated.length];
        int i = 0;
        while (i < this.solutions.length) {
            this.solutions[i] = solution;
            ++i;
        }
    }

    public DeprecationVisitor(String[] deprecated, String[] solutions) {
        super(RailsPlugin.getInstance().getOptions(), "");
        this.deprecated = deprecated;
        this.solutions = solutions;
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String name = iVisited.getName();
        int i = 0;
        while (i < this.deprecated.length) {
            if (name.equals(this.deprecated[i])) {
                this.createProblem(iVisited.getPosition(), this.solutions[i]);
                break;
            }
            ++i;
        }
        return super.visitFCallNode(iVisited);
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        String name = iVisited.getName();
        int i = 0;
        while (i < this.deprecated.length) {
            if (name.equals(this.deprecated[i])) {
                this.createProblem(iVisited.getPosition(), this.solutions[i]);
                break;
            }
            ++i;
        }
        return super.visitVCallNode(iVisited);
    }
}

