/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.core;

import com.aptana.rdt.rake.RakePlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.radrails.rails.core.IRailsConstants;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RailsRuntime {
    public static Process railsExec(String[] cmds, File workingDir) throws CoreException {
        ArrayList<String> cmdsList = new ArrayList<String>();
        String railsPath = RailsPlugin.getInstance().getRailsPath();
        if (railsPath != null && !railsPath.equals("")) {
            cmdsList.add(railsPath);
            cmdsList.addAll((Collection)Arrays.asList(cmds));
            return RailsRuntime.rubyExec(cmdsList.toArray(new String[0]), workingDir);
        }
        if (Platform.getOS().equals("win32")) {
            cmdsList.add("cmd.exe");
            cmdsList.add("/C");
        }
        cmdsList.add("rails");
        cmdsList.addAll((Collection)Arrays.asList(cmds));
        return DebugPlugin.exec((String[])cmdsList.toArray(new String[0]), (File)workingDir);
    }

    public static Process rubyExec(String[] preCmds, String[] cmds, File workingDir, boolean cmdPrompt) throws CoreException {
        int allCmdsCount = 0;
        int cmdsCount = 0;
        int preCmdsCount = 0;
        int syncCmdsCount = IRailsConstants.OUTPUT_SYNC.length;
        if (preCmds != null) {
            preCmdsCount = preCmds.length;
        }
        if (cmds != null) {
            cmdsCount = cmds.length;
        }
        Object[] allCmds = new String[preCmdsCount + syncCmdsCount + cmdsCount + 1];
        IVMInstall interp = RubyRuntime.getDefaultVMInstall();
        if (interp != null) {
            File rubyParentFile;
            String rubyPath = interp.getInstallLocation().getAbsolutePath();
            String command = null;
            if (interp.getVMInstallType().getId().equals("org.rubypeople.rdt.launching.JRubyVMType")) {
                command = "jruby";
                if (Platform.getOS().equals("win32")) {
                    command = String.valueOf(command) + ".bat";
                }
            } else {
                command = "ruby";
            }
            rubyPath = rubyPath.substring((rubyParentFile = new File(rubyPath).getParentFile()).getAbsolutePath().length() + 1).equals("bin") ? String.valueOf(rubyPath) + File.separator + command : String.valueOf(rubyPath) + File.separator + "bin" + File.separator + command;
            allCmds[allCmdsCount] = rubyPath;
            ++allCmdsCount;
        } else {
            if (cmdPrompt && Platform.getOS().equals("win32")) {
                allCmds = new String[preCmdsCount + syncCmdsCount + cmdsCount + 3];
                allCmds[allCmdsCount] = "cmd.exe";
                allCmds[++allCmdsCount] = "/C";
                ++allCmdsCount;
            }
            allCmds[allCmdsCount] = "ruby";
            ++allCmdsCount;
        }
        if (preCmdsCount > 0) {
            System.arraycopy(preCmds, 0, allCmds, allCmdsCount, preCmdsCount);
            allCmdsCount += preCmdsCount;
        }
        System.arraycopy(IRailsConstants.OUTPUT_SYNC, 0, allCmds, allCmdsCount, syncCmdsCount);
        System.arraycopy(cmds, 0, allCmds, allCmdsCount += syncCmdsCount, cmdsCount);
        RailsLog.logInfo("RailsRuntime.rubyExec: executing: " + Arrays.toString(allCmds), null);
        try {
            return DebugPlugin.exec((String[])allCmds, (File)workingDir);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static Process rubyExec(String[] cmds, File workingDir, boolean cmdPrompt) throws CoreException {
        return RailsRuntime.rubyExec(null, cmds, workingDir, cmdPrompt);
    }

    public static Process rubyExec(String[] cmds, File workingDir) throws CoreException {
        return RailsRuntime.rubyExec(null, cmds, workingDir, true);
    }

    public static Process exec(String[] cmds, File workingDir) throws CoreException {
        return RailsRuntime.exec(cmds, workingDir, true);
    }

    public static Process exec(String[] cmds, File workingDir, boolean cmdPrompt) throws CoreException {
        ArrayList<String> cmdsList = new ArrayList<String>();
        if (cmdPrompt && Platform.getOS().equals("win32")) {
            cmdsList.add("cmd.exe");
            cmdsList.add("/C");
        }
        cmdsList.addAll((Collection)Arrays.asList(cmds));
        return DebugPlugin.exec((String[])cmdsList.toArray(new String[0]), (File)workingDir);
    }

    public static Process rakeExec(String[] cmds, File workingDir) throws CoreException {
        ArrayList<String> cmdsList = new ArrayList<String>();
        String rakePath = RakePlugin.getDefault().getRakePath();
        if (rakePath != null) {
            cmdsList.add(rakePath);
            cmdsList.addAll((Collection)Arrays.asList(cmds));
            return RailsRuntime.rubyExec(cmdsList.toArray(new String[0]), workingDir);
        }
        if (Platform.getOS().equals("win32")) {
            cmdsList.add("cmd.exe");
            cmdsList.add("/C");
        }
        cmdsList.add("rake");
        cmdsList.addAll((Collection)Arrays.asList(cmds));
        return DebugPlugin.exec((String[])cmdsList.toArray(new String[0]), (File)workingDir);
    }

    public static ILaunchConfigurationWorkingCopy createInternalLaunch(String file, String args, IProject project) throws CoreException {
        return RailsRuntime.createInternalLaunch(file, args, project, project.getLocation().toOSString());
    }

    public static ILaunchConfigurationWorkingCopy createInternalLaunch(String file, String args, IProject project, String workingDirectory) throws CoreException {
        return RubyRuntime.createBasicLaunch((String)file, (String)args, (IProject)project, (String)workingDirectory);
    }
}

