/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.core.railsplugins;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;

public class RailsPluginDescriptor {
    public static final String REPOSITORY = "repository";
    public static final String RATING = "rating";
    public static final String NAME = "name";
    public static final String HOME = "home";
    public static final String LICENSE = "license";
    private Map<String, String> fContents = new HashMap<String, String>();

    public String getProperty(String key) {
        return this.fContents.get(key);
    }

    public void setProperty(String key, String value) {
        this.fContents.put(key, value);
    }

    public String getName() {
        String guessed = RailsPluginDescriptor.guessName(this.getRepository());
        if (guessed != null) {
            return guessed;
        }
        return this.getRawName();
    }

    String getRepository() {
        String raw = this.getProperty(REPOSITORY);
        if (raw != null && raw.startsWith("svn checkout ")) {
            raw = raw.substring("svn checkout ".length());
        }
        return raw;
    }

    private static String guessName(String url) {
        String name;
        Path path;
        block5: {
            if (url == null || url.trim().length() == 0) {
                return null;
            }
            try {
                URI u = new URI(url);
                path = new Path(u.getPath());
                name = path.lastSegment();
                if (name != null) break block5;
                return null;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (name.equals("trunk") || name.trim().length() == 0) {
            name = path.removeLastSegments(1).lastSegment();
        }
        return RailsPluginDescriptor.normalize(name);
    }

    private static String normalize(String string) {
        if (string == null) {
            return string;
        }
        return string.replace(' ', '_');
    }

    public float getRating() {
        String raw = this.getProperty(RATING);
        if (raw == null || raw.trim().length() == 0) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(raw);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    private String getRawHome() {
        return this.getProperty(HOME);
    }

    public String getHome() {
        String home = this.getRawHome();
        if (home == null) {
            return "";
        }
        if (home.trim().length() == 0) {
            return home;
        }
        if (home.startsWith("svn://")) {
            home = "http://" + home.substring("svn://".length());
        } else if (!home.startsWith("http")) {
            home = "http://" + home;
        }
        return home;
    }

    public String toString() {
        return this.fContents.toString();
    }

    public String getRawName() {
        return this.getProperty(NAME);
    }

    public String getLicense() {
        return this.getProperty(LICENSE);
    }

    public String getRawRating() {
        return this.getProperty(RATING);
    }
}

