/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private static List<Replacement> plurals = new ArrayList<Replacement>();
    private static List<Replacement> singulars = new ArrayList<Replacement>();
    private static List<String> uncountables = new ArrayList<String>();

    static {
        Inflector.plural(Pattern.compile("$"), "s");
        Inflector.plural(Pattern.compile("s$", 2), "s");
        Inflector.plural(Pattern.compile("(ax|test)is$", 2), "$1es");
        Inflector.plural(Pattern.compile("(octop|vir)us$", 2), "$1i");
        Inflector.plural(Pattern.compile("(alias|status)$", 2), "$1es");
        Inflector.plural(Pattern.compile("(bu)s$", 2), "$1ses");
        Inflector.plural(Pattern.compile("(buffal|tomat)o$", 2), "$1oes");
        Inflector.plural(Pattern.compile("([ti])um$", 2), "$1a");
        Inflector.plural(Pattern.compile("sis$", 2), "ses");
        Inflector.plural(Pattern.compile("(?:([^f])fe|([lr])f)$", 2), "$1$2ves");
        Inflector.plural(Pattern.compile("(hive)$", 2), "$1s");
        Inflector.plural(Pattern.compile("([^aeiouy]|qu)y$", 2), "$1ies");
        Inflector.plural(Pattern.compile("(x|ch|ss|sh)$", 2), "$1es");
        Inflector.plural(Pattern.compile("(matr|vert|ind)ix|ex$", 2), "$1ices");
        Inflector.plural(Pattern.compile("([m|l])ouse$", 2), "$1ice");
        Inflector.plural(Pattern.compile("^(ox)$", 2), "$1en");
        Inflector.plural(Pattern.compile("(quiz)$", 2), "$1zes");
        Inflector.singular(Pattern.compile("s$", 2), "");
        Inflector.singular(Pattern.compile("(n)ews$", 2), "$1ews");
        Inflector.singular(Pattern.compile("([ti])a$", 2), "$1um");
        Inflector.singular(Pattern.compile("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", 2), "$1$2sis");
        Inflector.singular(Pattern.compile("(^analy)ses$", 2), "$1sis");
        Inflector.singular(Pattern.compile("([^f])ves$", 2), "$1fe");
        Inflector.singular(Pattern.compile("(hive)s$", 2), "$1");
        Inflector.singular(Pattern.compile("(tive)s$", 2), "$1");
        Inflector.singular(Pattern.compile("([lr])ves$", 2), "$1f");
        Inflector.singular(Pattern.compile("([^aeiouy]|qu)ies$", 2), "$1y");
        Inflector.singular(Pattern.compile("(s)eries$", 2), "$1eries");
        Inflector.singular(Pattern.compile("(m)ovies$", 2), "$1ovie");
        Inflector.singular(Pattern.compile("(x|ch|ss|sh)es$", 2), "$1");
        Inflector.singular(Pattern.compile("([m|l])ice$", 2), "$1ouse");
        Inflector.singular(Pattern.compile("(bus)es$", 2), "$1");
        Inflector.singular(Pattern.compile("(o)es$", 2), "$1");
        Inflector.singular(Pattern.compile("(shoe)s$", 2), "$1");
        Inflector.singular(Pattern.compile("(cris|ax|test)es$", 2), "$1is");
        Inflector.singular(Pattern.compile("(octop|vir)i$", 2), "$1us");
        Inflector.singular(Pattern.compile("(alias|status)es$", 2), "$1");
        Inflector.singular(Pattern.compile("^(ox)en", 2), "$1");
        Inflector.singular(Pattern.compile("(vert|ind)ices$", 2), "$1ex");
        Inflector.singular(Pattern.compile("(matr)ices$", 2), "$1ix");
        Inflector.singular(Pattern.compile("(quiz)zes$", 2), "$1");
        Inflector.irregular("person", "people");
        Inflector.irregular("man", "men");
        Inflector.irregular("child", "children");
        Inflector.irregular("sex", "sexes");
        Inflector.irregular("move", "moves");
        Inflector.uncountable(new String[]{"equipment", "information", "rice", "money", "species", "series", "fish", "sheep"});
    }

    public static String singularize(String plural) {
        if (uncountables.contains(plural.toLowerCase())) {
            return plural;
        }
        for (Replacement replacement : singulars) {
            Matcher matcher = replacement.rule.matcher(plural);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(replacement.replacement);
        }
        return plural;
    }

    public static String pluralize(String singular) {
        if (uncountables.contains(singular.toLowerCase())) {
            return singular;
        }
        for (Replacement replacement : plurals) {
            Matcher matcher = replacement.rule.matcher(singular);
            if (!matcher.find()) continue;
            return matcher.replaceFirst(replacement.replacement);
        }
        return singular;
    }

    public static void plural(Pattern rule, String replacement) {
        plurals.add(0, new Replacement(rule, replacement));
    }

    public static void singular(Pattern rule, String replacement) {
        singulars.add(0, new Replacement(rule, replacement));
    }

    public static void irregular(String singular, String plural) {
        Inflector.plural(Pattern.compile("(" + singular.charAt(0) + ")" + singular.substring(1) + "$", 2), "$1" + plural.substring(1));
        Inflector.singular(Pattern.compile("(" + plural.charAt(0) + ")" + plural.substring(1) + "$", 2), "$1" + singular.substring(1));
    }

    public static void uncountable(String[] words) {
        int i = 0;
        while (i < words.length) {
            uncountables.add(words[i]);
            ++i;
        }
    }

    private static class Replacement {
        private Pattern rule;
        private String replacement;

        Replacement(Pattern rule, String replacement) {
            this.rule = rule;
            this.replacement = replacement;
        }
    }
}

