/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ui.PlatformUI;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerLog;
import org.radrails.server.core.ServerManagerContentHandler;
import org.radrails.server.core.ServerPlugin;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerManager
implements IResourceChangeListener {
    private static final String SERVERS_XML = "servers.xml";
    private static ServerManager instance;
    private Set<Server> fServers = new HashSet<Server>();
    private List<Observer> serverObservers = new ArrayList<Observer>();

    private ServerManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void stopAll() {
        for (Server s : this.fServers) {
            if (!s.isStarted()) continue;
            s.stop();
            s.updateStatus("Stopped");
        }
    }

    public String getNextAvailablePort() {
        String port = "3000";
        boolean found = false;
        while (!found) {
            if (!this.portInUse(port)) {
                found = true;
                continue;
            }
            port = String.valueOf(Integer.parseInt(port) + 1);
        }
        return port;
    }

    public boolean portInUse(String port) {
        boolean taken = false;
        Iterator<Server> i = this.fServers.iterator();
        while (i.hasNext() && !taken) {
            Server s = i.next();
            taken = port.equals(s.getPort());
        }
        return taken;
    }

    public boolean projectHasServer(String projectName, String type) {
        for (Server s : this.fServers) {
            if (!s.getProject().getName().equals(projectName) || !s.getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addServer(Server server) {
        this.fServers.add(server);
        this.saveServers();
        for (Observer o : this.serverObservers) {
            server.addServerObserver(o);
        }
        server.touch();
        server.notifyServerObservers("add");
    }

    public synchronized void removeServer(Server server) {
        this.fServers.remove(server);
        this.saveServers();
        server.touch();
        server.notifyServerObservers("remove");
    }

    public Collection<Server> getServers() {
        return Collections.unmodifiableCollection(this.fServers);
    }

    public Collection<Server> getServersForProject(IProject project) {
        ArrayList<Server> ret = new ArrayList<Server>();
        for (Server s : this.fServers) {
            if (!s.getProject().equals((Object)project)) continue;
            ret.add(s);
        }
        return ret;
    }

    public Server getServer(String name) {
        for (Server s : this.fServers) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Server findByProcess(IProcess process) {
        for (Server server : this.fServers) {
            if (!process.equals(server.getProcess())) continue;
            return server;
        }
        return null;
    }

    public void addServerObserver(Observer ob) {
        this.serverObservers.add(ob);
        for (Server s : this.fServers) {
            s.addServerObserver(ob);
        }
    }

    public void deleteServerObserver(Observer ob) {
        this.serverObservers.remove(ob);
        for (Server s : this.fServers) {
            s.deleteServerObserver(ob);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block5: {
            block4: {
                if (event.getType() != 4) break block4;
                IProject project = (IProject)event.getResource();
                ArrayList<Server> servers = new ArrayList<Server>(this.fServers);
                int i = 0;
                while (i < servers.size()) {
                    final Server s = (Server)servers.get(i);
                    if (project.equals((Object)s.getProject())) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                s.stop();
                                long start = System.currentTimeMillis();
                                while (!s.getStatus().equals("Stopped")) {
                                    Thread.yield();
                                    if (System.currentTimeMillis() > start + 10000L) break;
                                }
                                ServerManager.this.removeServer(s);
                            }
                        });
                    }
                    ++i;
                }
                break block5;
            }
            if (event.getType() != 2) break block5;
            IProject project = (IProject)event.getResource();
            ArrayList<Server> servers = new ArrayList<Server>(this.fServers);
            int i = 0;
            while (i < servers.size()) {
                final Server s = (Server)servers.get(i);
                if (project.equals((Object)s.getProject())) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            s.stop();
                        }
                    });
                }
                ++i;
            }
        }
    }

    public synchronized void saveServers() {
        File f = this.getConfigFile();
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new FileWriter(f));
                this.writeXML(out);
            }
            catch (FileNotFoundException e) {
                ServerLog.logError((String)"Servers config file not found", (Throwable)e);
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                ServerLog.logError((String)"Error opening servers config", (Throwable)e);
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void loadServers() {
        try {
            FileReader fileReader = new FileReader(this.getConfigFile());
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            ServerManagerContentHandler handler = new ServerManagerContentHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(fileReader));
            this.fServers.clear();
            Collection servers = handler.getServers();
            for (Server s : servers) {
                s.checkIfLeftHanging();
                this.fServers.add(s);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException e) {
            ServerLog.logError((String)"Error parsing servers config file", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            ServerLog.logError((String)"Error configuring XML parser", (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            ServerLog.logError((String)"Error configuring parser factory", (Throwable)e);
        }
        catch (IOException e) {
            ServerLog.logError((String)"Error reading servers config file", (Throwable)e);
        }
    }

    private void writeXML(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<server-manager>");
        for (Server s : this.fServers) {
            out.println("<server type=\"" + s.getType() + "\">");
            out.println("<project>" + s.getProject().getLocation().toPortableString() + "</project>");
            out.println("<name>" + s.getName() + "</name>");
            out.println("<host>" + s.getHost() + "</host>");
            out.println("<port>" + s.getPort() + "</port>");
            out.println("<environment>" + s.getEnvironment() + "</environment>");
            out.println("<runMode>" + s.getRunMode() + "</runMode>");
            out.println("</server>");
        }
        out.println("</server-manager>");
        out.flush();
    }

    private File getConfigFile() {
        return ServerPlugin.getInstance().getStateLocation().append(SERVERS_XML).toFile();
    }
}

