/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.server.core;

import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.core.RailsRuntime;
import org.radrails.server.core.ServerLog;
import org.radrails.server.core.ServerManager;
import org.radrails.server.core.ServerPlugin;
import org.rubypeople.rdt.core.SocketUtil;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.RubyRuntime;

public class Server
extends Observable {
    private static final int THIRTY_SECONDS = 30000;
    public static final String DEFAULT_RAILS_HOST = "0.0.0.0";
    public static final String DEFAULT_RADRAILS_HOST = "127.0.0.1";
    private IProject project;
    private String name;
    private String type;
    private String port;
    private String host = "127.0.0.1";
    private String environment;
    private String runMode;
    private String status;
    private IProcess serverProcess;
    private int pid = -1;
    private boolean keepStarting;
    private Set<Observer> observers = new HashSet<Observer>();

    public Server(IProject project, String name, String type, String host, String portNumber, String environment) {
        Assert.isNotNull((Object)project, (String)"Server must have a non-null project");
        this.project = project;
        this.name = name;
        this.type = type;
        if (this.type == null || this.type.trim().length() == 0) {
            this.type = "WEBrick";
        }
        this.host = host;
        if (this.host == null) {
            this.host = DEFAULT_RADRAILS_HOST;
        }
        this.port = portNumber;
        if (this.port == null || this.port.trim().length() == 0) {
            this.port = ServerManager.getInstance().getNextAvailablePort();
        }
        this.environment = environment;
        if (this.environment == null || this.environment.trim().length() == 0) {
            this.environment = "development";
        }
        this.status = "Stopped";
        this.runMode = "run";
    }

    public Server(IProject project, String type) {
        this(project, String.valueOf(project.getName()) + "Server", type, DEFAULT_RADRAILS_HOST, ServerManager.getInstance().getNextAvailablePort(), "development");
    }

    public Server(IProject project, String serverName, String serverType, String port) {
        this(project, serverName, serverType, DEFAULT_RADRAILS_HOST, port, "development");
    }

    public File getProjectFile() {
        return this.project.getLocation().toFile();
    }

    public String getName() {
        return this.name;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortInt() {
        return Integer.parseInt(this.port);
    }

    public String getType() {
        return this.type;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getStatus() {
        return this.status;
    }

    public void updatePort(String port) {
        this.port = port;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    public void updateName(String name) {
        this.name = name;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    public void updateEnvironment(String environment) {
        this.environment = environment;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    public void updateRunMode(String runMode) {
        this.runMode = runMode;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    public void updateStatus(String status) {
        this.status = status;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    public void updateHost(String newHost) {
        if (newHost == null) {
            newHost = DEFAULT_RAILS_HOST;
        }
        this.host = newHost;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    protected void syncUpdateStatus(final String status) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Server.this.updateStatus(status);
            }
        });
    }

    public void touch() {
        this.setChanged();
    }

    public boolean isStarted() {
        return this.status.equals("Started");
    }

    public boolean isStarting() {
        return this.status.equals("Starting...");
    }

    public boolean isStopped() {
        return !this.isStarted() && !this.isStarting() && !this.isStopping();
    }

    public boolean isStopping() {
        return this.status.equals("Stopping...");
    }

    public void start() {
        this.start(true);
    }

    private boolean isMongrel() {
        return this.getType().equals("Mongrel");
    }

    public void stop() {
        if (this.serverProcess != null || this.pid != -1) {
            this.keepStarting = false;
            Job j = new Job("Stopping server"){

                protected IStatus run(IProgressMonitor monitor) {
                    Server.this.stopServer();
                    return Status.OK_STATUS;
                }
            };
            j.schedule();
        }
    }

    public void restart() {
        Job j = new Job("Restarting server"){

            protected IStatus run(IProgressMonitor monitor) {
                Server.this.keepStarting = false;
                Server.this.stopServer();
                Server.this.startServer(false);
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    private void stopServer() {
        this.syncUpdateStatus("Stopping...");
        if (this.getRunMode().equals("debug")) {
            IDebugTarget debugtarget = this.serverProcess.getLaunch().getDebugTarget();
            try {
                debugtarget.terminate();
            }
            catch (DebugException e) {
                RailsLog.log((CoreException)((Object)e));
                this.syncUpdateStatus("Started");
                return;
            }
        }
        if (this.serverProcess != null) {
            int tries = 0;
            while (!this.serverProcess.isTerminated() && tries < 10) {
                try {
                    this.serverProcess.terminate();
                    Thread.sleep(10L);
                    ++tries;
                }
                catch (DebugException e) {
                    ServerLog.logError((String)"Error terminating server process", (Throwable)e);
                }
                catch (InterruptedException e) {
                    ServerLog.logError((String)"Error sleeping", (Throwable)e);
                }
            }
        }
        if (!Platform.getOS().equals("win32")) {
            if (this.pid < 0) {
                this.grabPid();
            }
            try {
                if (this.pid > 0 && this.killProcess()) {
                    this.pid = -1;
                    this.syncUpdateStatus("Stopped");
                    return;
                }
            }
            catch (CoreException coreException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.serverProcess != null && this.serverProcess.isTerminated()) {
            this.pid = -1;
        }
        this.syncUpdateStatus("Stopped");
    }

    private void grabPid() {
        block22: {
            BufferedReader reader = null;
            try {
                String[] allCmds = new String[]{"ps", "wwwx"};
                Process p = DebugPlugin.exec((String[])allCmds, null);
                reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                String args = this.getProgramArguments();
                while ((line = reader.readLine()) != null) {
                    String modified;
                    int index;
                    if (line.indexOf(args) == -1 || (index = (modified = line.trim()).indexOf(32)) == -1) continue;
                    String pid = modified.substring(0, index);
                    try {
                        this.pid = Integer.parseInt(pid);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (CoreException e) {
                ServerLog.log((CoreException)e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
            }
            catch (IOException e) {
                try {
                    ServerLog.log((Exception)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    break block22;
                }
                catch (IOException iOException) {}
                break block22;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean killProcess() throws CoreException, InterruptedException {
        ArrayList<String> killCommands = new ArrayList<String>();
        killCommands.add(this.getRubyScriptPath("kill.rb"));
        killCommands.add("INT");
        killCommands.add("" + this.pid);
        Process p = RailsRuntime.rubyExec((String[])killCommands.toArray(new String[0]), (File)this.getProjectFile(), (boolean)false);
        return p.exitValue() == 0;
    }

    private boolean isWebrick() {
        return this.getType().equals("WEBrick");
    }

    public void started(IProcess process) {
        try {
            this.serverProcess = process;
            IStreamMonitor stdOut = null;
            IStreamMonitor stdErr = null;
            if (this.serverProcess.getStreamsProxy() != null) {
                stdOut = this.serverProcess.getStreamsProxy().getOutputStreamMonitor();
                stdErr = this.serverProcess.getStreamsProxy().getErrorStreamMonitor();
            }
            DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

                public void handleDebugEvents(DebugEvent[] events) {
                    if (events == null) {
                        return;
                    }
                    int i = 0;
                    while (i < events.length) {
                        if (events[i].getKind() == 8 && Server.this.serverProcess.equals(events[i].getSource())) {
                            Server.this.pid = -1;
                            Server.this.syncUpdateStatus("Stopped");
                        }
                        ++i;
                    }
                }
            });
            this.keepStarting = true;
            if (stdOut != null) {
                stdOut.addListener(new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        if (Server.this.pid != -1) {
                            return;
                        }
                        if (text == null) {
                            return;
                        }
                        String[] lines = text.split("\n");
                        String num = lines[0].trim();
                        if (num.startsWith("\"")) {
                            num = num.substring(1);
                        }
                        if (num.endsWith("\"")) {
                            num = num.substring(0, num.length() - 1);
                        }
                        try {
                            Server.this.pid = Integer.parseInt(num.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            Server.this.pid = -2;
                        }
                        monitor.removeListener((IStreamListener)this);
                    }
                });
            }
            if (stdErr != null) {
                stdErr.addListener(new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        if (text == null) {
                            return;
                        }
                        String[] lines = text.split("\n");
                        int i = 0;
                        while (i < lines.length) {
                            if (Server.this.isWebrick() && lines[i].indexOf("WEBrick::HTTPServer#start") != -1) {
                                Server.this.keepStarting = false;
                                monitor.removeListener((IStreamListener)this);
                                return;
                            }
                            if (Server.this.isMongrel() && lines[i].indexOf("available at") != -1) {
                                Server.this.keepStarting = false;
                                monitor.removeListener((IStreamListener)this);
                                return;
                            }
                            ++i;
                        }
                    }
                });
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy h:mm:ss aa");
            String date = dateFormat.format(new Date());
            this.serverProcess.setAttribute(IProcess.ATTR_PROCESS_LABEL, String.valueOf(this.project.getName()) + " - " + this.getDisplayName() + " Server - (" + date + ")");
            long start = System.currentTimeMillis();
            while (this.keepStarting && !this.serverProcess.isTerminated()) {
                Thread.yield();
                if (start + 30000L < System.currentTimeMillis()) break;
            }
            if (this.serverProcess.isTerminated()) {
                this.syncUpdateStatus("Stopped");
            }
            if (this.status.equals("Starting...")) {
                this.syncUpdateStatus("Started");
            }
        }
        catch (Exception e) {
            ServerLog.logError((String)"Error running the server command", (Throwable)e);
            this.syncUpdateStatus(String.valueOf(e.getLocalizedMessage()) + "  See the log for details.");
        }
    }

    private void startServer(boolean publicLaunchConfig) {
        if (!SocketUtil.portFree((int)Integer.parseInt(this.getPort()))) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Port not free", (String)"The selected port for this server is not free. Perhaps the server is already running, or another server has the same port?");
                }
            });
            return;
        }
        try {
            ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(publicLaunchConfig);
            int port = Integer.parseInt(this.getPort());
            if (port < 1024) {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_IS_SUDO, true);
                config = wc.doSave();
            }
            config.launch(this.runMode, null);
        }
        catch (CoreException e) {
            ServerLog.logError((String)"Error running the server command", (Throwable)e);
            this.syncUpdateStatus(String.valueOf(e.getLocalizedMessage()) + "  See the log for details.");
        }
    }

    protected String getDisplayName() {
        return this.getType();
    }

    protected ILaunchConfiguration findOrCreateLaunchConfiguration(boolean publicLaunchConfig) throws CoreException {
        ILaunchConfigurationType configType = this.getRubyApplicationConfigType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            boolean argumentsSame;
            ILaunchConfiguration config = configs[i];
            boolean projectsEqual = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(this.getProject().getName());
            if (projectsEqual && (argumentsSame = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "").equals(this.getProgramArguments()))) {
                String vmName = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, "");
                String vmType = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, "");
                IVMInstall vm = RubyRuntime.getDefaultVMInstall();
                if (vmName.equals(vm.getName()) && vm.getVMInstallType().getId().equals(vmType)) {
                    candidateConfigs.add(config);
                }
            }
            ++i;
        }
        switch (candidateConfigs.size()) {
            case 0: {
                return this.createServerLaunchConfiguration(publicLaunchConfig);
            }
        }
        return (ILaunchConfiguration)candidateConfigs.get(0);
    }

    private ILaunchConfiguration createServerLaunchConfiguration(boolean publicLaunchConfig) {
        IPath railsRoot = RailsPlugin.findRailsRoot((IProject)this.project);
        railsRoot = railsRoot == null || railsRoot.segmentCount() == 0 ? this.project.getLocation() : this.project.getLocation().append(railsRoot);
        String fileName = null;
        if (this.isMongrel() && this.isOldRails()) {
            fileName = this.getMongrelRailsScript();
        } else {
            IPath serverScript = railsRoot.append("script").append("server");
            fileName = this.project.getLocation().isPrefixOf(serverScript) ? serverScript.toPortableString().substring(this.project.getLocation().toPortableString().length() + 1) : serverScript.toPortableString();
        }
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getRubyApplicationConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.getName()));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.getProject().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, fileName);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, railsRoot.toFile().getAbsolutePath());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, "org.rubypeople.rdt.debug.ui.rubySourceLocator");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getProgramArguments());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-e p(Process.pid.to_s) -e load(ARGV.shift)");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND, "ruby");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, map);
            wc.setAttribute("org.eclipse.debug.ui.private", !publicLaunchConfig);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            config = wc.doSave();
        }
        catch (CoreException coreException) {}
        return config;
    }

    private boolean isOldRails() {
        return this.doIsOldRails(RailsPlugin.getRailsVersion((IProject)this.project));
    }

    private boolean doIsOldRails(String version) {
        int third;
        block18: {
            String[] numbers;
            block17: {
                block16: {
                    int second;
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        if (version != null) break block11;
                                        return true;
                                    }
                                    numbers = version.split("\\.");
                                    if (numbers != null && numbers.length != 0) break block12;
                                    return true;
                                }
                                if (!numbers[0].equals("0")) break block13;
                                return true;
                            }
                            if (numbers[0].equals("1")) break block14;
                            return false;
                        }
                        second = Integer.parseInt(numbers[1]);
                        if (second <= 1) break block15;
                        return false;
                    }
                    if (second != 0) break block16;
                    return true;
                }
                if (numbers.length != 2) break block17;
                return true;
            }
            third = Integer.parseInt(numbers[2]);
            if (third != 6) break block18;
            return true;
        }
        try {
            if (third >= 3) {
                return false;
            }
        }
        catch (Exception e) {
            ServerLog.log((Exception)e);
        }
        return true;
    }

    private String getMongrelRailsScript() {
        return RailsPlugin.getInstance().getMongrelPath();
    }

    private ILaunchConfigurationType getRubyApplicationConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public String getProgramArguments() {
        StringBuffer args = new StringBuffer();
        if (this.isMongrel() && this.isOldRails()) {
            args.append("start");
            args.append(" -l ");
            args.append(this.getMongrelLogPath());
        } else {
            args.append(this.getServerArg());
        }
        args.append(" --port=");
        args.append(this.getPort());
        args.append(" --environment=");
        args.append(this.getEnvironment());
        if (!this.getHost().equals(DEFAULT_RAILS_HOST)) {
            if (args.toString().startsWith("start")) {
                args.append(" --address=");
                args.append(this.host);
            } else {
                args.append(" --binding=");
                args.append(this.host);
            }
        }
        return args.toString();
    }

    private String getMongrelLogPath() {
        IPath path = this.getProject().getLocation().append(RailsPlugin.findRailsRoot((IProject)this.getProject()));
        path = path.append("log").append("mongrel.log");
        return String.valueOf('\"') + path.toOSString() + '\"';
    }

    protected String getServerArg() {
        if (this.isWebrick()) {
            return "webrick";
        }
        if (this.isMongrel()) {
            return "mongrel";
        }
        if (this.isLighttpd()) {
            return "lighttpd";
        }
        throw new IllegalStateException("Server has a type that isn't Mongrel, WEBrick or Lighttpd!");
    }

    private boolean isLighttpd() {
        return this.getType().equals("LightTPD");
    }

    protected String getRubyScriptPath(String rubyFile) {
        File pluginDirFile;
        block27: {
            String directoryFile = String.valueOf(ServerPlugin.getInstance().getStateLocation().toOSString()) + File.separator + rubyFile;
            pluginDirFile = new File(directoryFile);
            if (!pluginDirFile.exists()) {
                BufferedReader input = null;
                OutputStreamWriter output = null;
                try {
                    try {
                        String line;
                        pluginDirFile.createNewFile();
                        URL u = ServerPlugin.getInstance().getBundle().getEntry("/ruby/" + rubyFile);
                        input = new BufferedReader(new InputStreamReader(u.openStream()));
                        output = new FileWriter(pluginDirFile);
                        while ((line = input.readLine()) != null) {
                            output.write(line);
                            output.write(10);
                        }
                        output.flush();
                    }
                    catch (IOException e) {
                        ServerLog.logError((String)"Error copying script file from jar to metadata", (Throwable)e);
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        String path = "";
        try {
            path = pluginDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            ServerLog.logError((String)"Error getting script file path", (Throwable)e);
        }
        return path;
    }

    public String getRunMode() {
        return this.runMode;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Server)) {
            return false;
        }
        Server other = (Server)arg0;
        return this.getType().equals(other.getType()) && this.getPort().equals(other.getPort()) && this.getProject().equals((Object)other.getProject()) && this.getEnvironment().equals(other.getEnvironment());
    }

    public void updateType(String newType) {
        this.type = newType;
        this.setChanged();
        this.notifyServerObservers("update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerObserver(Observer ob) {
        Set<Observer> set = this.observers;
        synchronized (set) {
            this.observers.add(ob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServerObservers(Object arg) {
        HashSet<Observer> copy;
        Set<Observer> set = this.observers;
        synchronized (set) {
            copy = new HashSet<Observer>(this.observers);
        }
        for (Observer observer : copy) {
            observer.update(this, arg);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public IProcess getProcess() {
        return this.serverProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServerObserver(Observer ob) {
        Set<Observer> set = this.observers;
        synchronized (set) {
            this.observers.remove(ob);
        }
    }

    public String getHost() {
        if (this.host == null) {
            return DEFAULT_RADRAILS_HOST;
        }
        return this.host;
    }

    public String getBrowserHost() {
        String host = this.getHost();
        if (Platform.getOS().equals("win32") && host.equals(DEFAULT_RAILS_HOST)) {
            return DEFAULT_RADRAILS_HOST;
        }
        return host;
    }

    public void start(final boolean publicLaunchConfig) {
        IGemManager gemManager;
        if (this.isMongrel() && (gemManager = RailsPlugin.getInstance().getGemManager()) != null && gemManager.isInitialized() && !gemManager.gemInstalled("mongrel") && RailsPlugin.getInstance().getMongrelPath() == null && MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Mongrel is not installed", (String)"It appears that you do not have the mongrel gem installed. Would you like us to install it?")) {
            Job job = new Job("Installing mongrel"){

                protected IStatus run(IProgressMonitor monitor) {
                    return gemManager.installGem(new Gem("mongrel", "", null), monitor);
                }
            };
            job.setUser(true);
            job.schedule();
            return;
        }
        Job j = new Job("Starting server"){

            protected IStatus run(IProgressMonitor monitor) {
                Server.this.startServer(publicLaunchConfig);
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    public boolean isLocalhost() {
        return this.getHost() != null && (this.getHost().equals(DEFAULT_RADRAILS_HOST) || this.getHost().equals(DEFAULT_RAILS_HOST) || this.getHost().equals("localhost"));
    }

    void checkIfLeftHanging() {
        if (Platform.getOS().equals("win32")) {
            return;
        }
        this.grabPid();
        if (this.pid != -1) {
            this.status = "Started";
        }
    }
}

