/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.ui.internal;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.dltk.console.ScriptConsoleHistory;
import org.python.pydev.dltk.console.ui.IConsoleStyleProvider;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.internal.ClipboardHandler;
import org.python.pydev.dltk.console.ui.internal.IScriptConsoleContentHandler;
import org.python.pydev.dltk.console.ui.internal.IScriptConsoleViewer2ForDocumentListener;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleDocumentListener;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleHistorySelector;
import org.python.pydev.dltk.console.ui.internal.actions.HandleBackspaceAction;
import org.python.pydev.dltk.console.ui.internal.actions.HandleDeletePreviousWord;
import org.python.pydev.dltk.console.ui.internal.actions.HandleLineStartAction;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.plugin.KeyBindingHelper;
import org.python.pydev.plugin.PydevPlugin;

public class ScriptConsoleViewer
extends TextConsoleViewer
implements IScriptConsoleViewer,
IScriptConsoleViewer2ForDocumentListener {
    private boolean inCompletion = false;
    private ScriptConsoleHistory history;
    private ScriptConsoleDocumentListener listener;
    IConsoleStyleProvider styleProvider;
    protected ScriptConsole console;
    private boolean isMainViewer;
    volatile int inHistoryRequests = 0;
    volatile boolean changedAfterLastHistoryRequest = false;
    private final boolean focusOnStart;

    public IConsoleStyleProvider getStyleProvider() {
        return this.styleProvider;
    }

    public int getCaretOffset() {
        return this.getTextWidget().getCaretOffset();
    }

    public IInterpreterInfo getInterpreterInfo() {
        return this.console.getInterpreterInfo();
    }

    public void setCaretOffset(final int offset, boolean async) {
        final StyledText textWidget = this.getTextWidget();
        if (textWidget != null) {
            if (async) {
                Display display = textWidget.getDisplay();
                if (display != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            textWidget.setCaretOffset(offset);
                        }
                    });
                }
            } else {
                textWidget.setCaretOffset(offset);
            }
        }
    }

    protected boolean isSelectedRangeEditable() {
        Point range = this.getSelectedRange();
        int commandLineOffset = this.getCommandLineOffset();
        if (range.x < commandLineOffset) {
            return false;
        }
        return range.x + range.y >= commandLineOffset;
    }

    protected boolean isCaretInLastLine() throws BadLocationException {
        return this.getTextWidget().getCaretOffset() >= this.listener.getLastLineOffset();
    }

    protected boolean isCaretInEditableRange() {
        return this.getTextWidget().getCaretOffset() >= this.getCommandLineOffset();
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new ScriptConsoleStyledText(parent, styles);
    }

    public ScriptConsoleViewer(Composite parent, ScriptConsole console, final IScriptConsoleContentHandler contentHandler, IConsoleStyleProvider styleProvider, String initialCommands, boolean focusOnStart) {
        super(parent, (TextConsole)console);
        this.focusOnStart = focusOnStart;
        this.console = console;
        this.getTextWidget().setBackground(console.getPydevConsoleBackground());
        ScriptConsoleViewer existingViewer = this.console.getViewer();
        if (existingViewer == null) {
            this.isMainViewer = true;
            this.console.setViewer(this);
            this.styleProvider = styleProvider;
            this.history = console.getHistory();
            this.listener = new ScriptConsoleDocumentListener(this, console, console.getPrompt(), console.getHistory(), console.getLineTrackers(), initialCommands);
            this.listener.setDocument(this.getDocument());
        } else {
            this.isMainViewer = false;
            this.styleProvider = existingViewer.styleProvider;
            this.history = existingViewer.history;
            this.listener = existingViewer.listener;
            this.listener.addViewer(this);
        }
        final StyledText styledText = this.getTextWidget();
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (ScriptConsoleViewer.this.inHistoryRequests == 0) {
                    ScriptConsoleViewer.this.changedAfterLastHistoryRequest = true;
                }
            }
        });
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScriptConsoleViewer.this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength(), true);
                styledText.removeFocusListener((FocusListener)this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        styledText.addVerifyKeyListener((VerifyKeyListener)new KeyChecker());
        styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (KeyBindingHelper.matchesContentAssistKeybinding((KeyEvent)event) || KeyBindingHelper.matchesQuickAssistKeybinding((KeyEvent)event)) {
                    event.doit = false;
                    return;
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (ScriptConsoleViewer.this.getCaretOffset() >= ScriptConsoleViewer.this.getCommandLineOffset()) {
                    if (KeyBindingHelper.matchesContentAssistKeybinding(e)) {
                        contentHandler.contentAssistRequired();
                    } else if (KeyBindingHelper.matchesQuickAssistKeybinding(e)) {
                        contentHandler.quickAssistRequired();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        ICompletionListener completionListener = new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                ScriptConsoleViewer.this.inCompletion = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                ScriptConsoleViewer.this.inCompletion = false;
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        };
        if (this.fContentAssistant != null) {
            ((IContentAssistantExtension2)this.fContentAssistant).addCompletionListener(completionListener);
        }
        if (this.fQuickAssistAssistant != null) {
            this.fQuickAssistAssistant.addCompletionListener(completionListener);
        }
        if (this.isMainViewer) {
            this.clear(true);
        }
        if (this.focusOnStart) {
            this.getTextWidget().setFocus();
        }
    }

    public String getCommandLine() {
        return this.listener.getCommandLine();
    }

    public int getCommandLineOffset() {
        try {
            return this.listener.getCommandLineOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void clear(boolean addInitialCommands) {
        this.listener.clear(addInitialCommands);
    }

    public long getLastChangeMillis() {
        return this.listener.getLastChangeMillis();
    }

    public void revealEndOfDocument() {
        super.revealEndOfDocument();
    }

    private final class KeyChecker
    implements VerifyKeyListener {
        private KeyChecker() {
        }

        public void verifyKey(VerifyEvent event) {
            try {
                if (event.character != '\u0000') {
                    if (Character.isLetter(event.character) && (event.stateMask == 0 || (event.stateMask & 0x20000) != 0) && !ScriptConsoleViewer.this.isSelectedRangeEditable()) {
                        ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                    }
                    if (!ScriptConsoleViewer.this.isSelectedRangeEditable()) {
                        event.doit = false;
                        return;
                    }
                    if (event.character == '\r') {
                        if (ScriptConsoleViewer.this.inCompletion && (event.stateMask & 0x20000) != 0) {
                            ((PyContentAssistant)ScriptConsoleViewer.this.fContentAssistant).hide();
                        }
                        if (!ScriptConsoleViewer.this.inCompletion) {
                            ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                        }
                        return;
                    }
                    if (event.character == '\u001b') {
                        if (!ScriptConsoleViewer.this.inCompletion) {
                            ScriptConsoleViewer.this.listener.setCommandLine("");
                        }
                        return;
                    }
                } else if (ScriptConsoleViewer.this.isCaretInEditableRange() && !ScriptConsoleViewer.this.inCompletion && event.keyCode == 0x1000005) {
                    event.doit = false;
                    List<String> commands = ScriptConsoleViewer.this.history.getAsList();
                    List<String> commandsToExecute = ScriptConsoleHistorySelector.select(commands);
                    if (commandsToExecute != null) {
                        ScriptConsoleViewer.this.listener.setCommandLine("");
                        IDocument d = ScriptConsoleViewer.this.getDocument();
                        d.replace(d.getLength(), 0, String.valueOf(StringUtils.join((String)"\n", commandsToExecute)) + "\n");
                    }
                    return;
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }

    private class ScriptConsoleStyledText
    extends StyledText {
        private HandleBackspaceAction handleBackspaceAction;
        private HandleDeletePreviousWord handleDeletePreviousWord;
        private HandleLineStartAction handleLineStartAction;
        private volatile int internalCaretSet;

        public ScriptConsoleStyledText(Composite parent, int style) {
            super(parent, style);
            this.internalCaretSet = -1;
            this.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    ScriptConsoleStyledText.this.internalCaretSet = -1;
                }
            });
            this.addExtendedModifyListener(new ExtendedModifyListener(){

                public void modifyText(ExtendedModifyEvent event) {
                    if (ScriptConsoleStyledText.this.internalCaretSet != -1) {
                        if (ScriptConsoleStyledText.this.internalCaretSet != ScriptConsoleStyledText.this.getCaretOffset()) {
                            ScriptConsoleStyledText.this.setCaretOffset(ScriptConsoleStyledText.this.internalCaretSet);
                        }
                        ScriptConsoleStyledText.this.internalCaretSet = -1;
                    }
                }
            });
            this.handleBackspaceAction = new HandleBackspaceAction();
            this.handleDeletePreviousWord = new HandleDeletePreviousWord();
            this.handleLineStartAction = new HandleLineStartAction();
        }

        public void setCaretOffset(int offset) {
            this.internalCaretSet = offset;
            super.setCaretOffset(offset);
        }

        public void invokeAction(int action) {
            switch (action) {
                case 0x1000007: {
                    if (this.handleLineStartAction.execute(ScriptConsoleViewer.this.getDocument(), this.getCaretOffset(), ScriptConsoleViewer.this.getCommandLineOffset(), ScriptConsoleViewer.this)) {
                        return;
                    }
                    super.invokeAction(action);
                }
            }
            if (ScriptConsoleViewer.this.isSelectedRangeEditable()) {
                block19: {
                    try {
                        boolean didChange;
                        int historyChange = 0;
                        switch (action) {
                            case 0x1000001: {
                                historyChange = 1;
                                break;
                            }
                            case 0x1000002: {
                                historyChange = 2;
                                break;
                            }
                            case 8: {
                                this.handleBackspaceAction.execute(ScriptConsoleViewer.this.getDocument(), (ITextSelection)ScriptConsoleViewer.this.getSelection(), ScriptConsoleViewer.this.getCommandLineOffset());
                                return;
                            }
                            case 262152: {
                                this.handleDeletePreviousWord.execute(ScriptConsoleViewer.this.getDocument(), this.getCaretOffset(), ScriptConsoleViewer.this.getCommandLineOffset());
                                return;
                            }
                        }
                        if (historyChange == 0) break block19;
                        if (ScriptConsoleViewer.this.changedAfterLastHistoryRequest) {
                            ScriptConsoleViewer.this.history.setMatchStart(ScriptConsoleViewer.this.getCommandLine());
                        }
                        if (didChange = historyChange == 1 ? ScriptConsoleViewer.this.history.prev() : ScriptConsoleViewer.this.history.next()) {
                            ++ScriptConsoleViewer.this.inHistoryRequests;
                            try {
                                ScriptConsoleViewer.this.listener.setCommandLine(ScriptConsoleViewer.this.history.get());
                                this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            }
                            finally {
                                --ScriptConsoleViewer.this.inHistoryRequests;
                            }
                        }
                        ScriptConsoleViewer.this.changedAfterLastHistoryRequest = false;
                        return;
                    }
                    catch (BadLocationException e) {
                        PydevPlugin.log(e);
                        return;
                    }
                }
                super.invokeAction(action);
            } else {
                super.invokeAction(action);
            }
        }

        public void cut() {
            this.changeSelectionToEditableRange();
            super.cut();
        }

        public void paste() {
            this.changeSelectionToEditableRange();
            super.paste();
        }

        public void copy() {
            this.copy(1);
        }

        public void copy(int clipboardType) {
            this.checkWidget();
            Point selectedRange = ScriptConsoleViewer.this.getSelectedRange();
            if (selectedRange.y > 0) {
                IDocument doc = ScriptConsoleViewer.this.getDocument();
                new ClipboardHandler().putIntoClipboard(doc, selectedRange, clipboardType, this.getDisplay());
            }
        }

        protected void changeSelectionToEditableRange() {
            Point range = ScriptConsoleViewer.this.getSelectedRange();
            int commandLineOffset = ScriptConsoleViewer.this.getCommandLineOffset();
            int minOffset = range.x;
            int maxOffset = range.x + range.y;
            boolean changed = false;
            if (minOffset < commandLineOffset) {
                minOffset = commandLineOffset;
                changed = true;
            }
            if (maxOffset < commandLineOffset) {
                maxOffset = commandLineOffset;
                changed = true;
            }
            if (changed) {
                ScriptConsoleViewer.this.setSelectedRange(minOffset, maxOffset - minOffset);
            }
            if (this.getCaretOffset() <= ScriptConsoleViewer.this.getCommandLineOffset()) {
                this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
            }
        }
    }
}

