/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.ui.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.debug.ui.launching.AbstractLaunchShortcut;
import org.python.pydev.debug.ui.launching.FileOrResource;
import org.python.pydev.plugin.PydevPlugin;

public class PydevdServerLaunchShortcut
extends AbstractLaunchShortcut {
    public ILaunchConfiguration createDefaultLaunchConfiguration(FileOrResource[] resources) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.getLaunchConfigurationType());
        if (type == null) {
            PydevdServerLaunchShortcut.reportError((String)"Python launch configuration not found", null);
            return null;
        }
        StringBuffer buffer = new StringBuffer("Debug Server");
        String name = buffer.toString().trim();
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_PROJECT", "Pydevd Debug Server");
            workingCopy.setAttribute("org.python.pydev.debug.ATTR_RESOURCE_TYPE", 1);
            workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            ILaunchConfiguration ret = workingCopy.doSave();
            return ret;
        }
        catch (CoreException e) {
            PydevdServerLaunchShortcut.reportError(null, (Throwable)e);
            return null;
        }
    }

    public void launch(FileOrResource[] file, String mode) {
        ILaunchConfiguration conf = this.createDefaultLaunchConfiguration(file);
        DebugUITools.launch((ILaunchConfiguration)conf, (String)mode);
    }

    protected String getLaunchConfigurationType() {
        return "com.python.pydev.debug.pydevdServerLaunchConfigurationType";
    }

    protected IInterpreterManager getInterpreterManager(IProject project) {
        return PydevPlugin.getPythonInterpreterManager();
    }
}

