/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.plugin.PydevPlugin;

final class PyUnitSortListener
implements Listener {
    private PyUnitView view;

    PyUnitSortListener(PyUnitView view) {
        this.view = view;
    }

    public void handleEvent(Event e) {
        TreeColumn oldSortColumn;
        int col;
        Tree tree = this.view.getTree();
        TreeItem[] items = tree.getItems();
        TreeColumn column = (TreeColumn)e.widget;
        Comparator<TreeItem> comparator = null;
        if (column == this.view.colIndex) {
            col = -1;
            comparator = new Comparator<TreeItem>(){

                @Override
                public int compare(TreeItem o1, TreeItem o2) {
                    int number1;
                    int number0;
                    block4: {
                        String txt0 = o1.getText(0);
                        String txt1 = o2.getText(0);
                        try {
                            number0 = Integer.parseInt(txt0.trim());
                            number1 = Integer.parseInt(txt1.trim());
                            if (number0 >= number1) break block4;
                            return -1;
                        }
                        catch (NumberFormatException e) {
                            PydevPlugin.log((Throwable)e);
                            return txt0.compareTo(txt1);
                        }
                    }
                    if (number1 < number0) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.compare((TreeItem)object, (TreeItem)object2);
                }
            };
        } else if (column == this.view.colResult) {
            col = 1;
        } else if (column == this.view.colTest) {
            col = 2;
        } else if (column == this.view.colFile) {
            col = 3;
        } else if (column == this.view.colTime) {
            col = -1;
            comparator = new Comparator<TreeItem>(){

                @Override
                public int compare(TreeItem o1, TreeItem o2) {
                    float float1;
                    float float0;
                    block4: {
                        String txt0 = o1.getText(4);
                        String txt1 = o2.getText(4);
                        try {
                            float0 = Float.parseFloat(txt0.trim());
                            float1 = Float.parseFloat(txt1.trim());
                            if (!(float0 < float1)) break block4;
                            return -1;
                        }
                        catch (NumberFormatException e) {
                            PydevPlugin.log((Throwable)e);
                            return txt0.compareTo(txt1);
                        }
                    }
                    if (float1 < float0) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.compare((TreeItem)object, (TreeItem)object2);
                }
            };
        } else {
            PydevPlugin.log((String)("Could not recognize column clicked: " + column));
            return;
        }
        if (comparator == null) {
            comparator = new Comparator<TreeItem>(){

                @Override
                public int compare(TreeItem o1, TreeItem o2) {
                    return o1.getText(col).compareTo(o2.getText(col));
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.compare((TreeItem)object, (TreeItem)object2);
                }
            };
        }
        if ((oldSortColumn = tree.getSortColumn()) == column) {
            int sortDirection = tree.getSortDirection();
            if (sortDirection == 1024) {
                tree.setSortDirection(128);
                final Comparator<TreeItem> oldComparator = comparator;
                comparator = new Comparator<TreeItem>(){

                    @Override
                    public int compare(TreeItem o1, TreeItem o2) {
                        return -oldComparator.compare(o1, o2);
                    }

                    @Override
                    public /* synthetic */ int compare(Object object, Object object2) {
                        return this.compare((TreeItem)object, (TreeItem)object2);
                    }
                };
            } else {
                tree.setSortDirection(1024);
            }
        } else {
            tree.setSortDirection(1024);
        }
        Arrays.sort(items, comparator);
        String[][] strings = new String[items.length][5];
        PyUnitTestResult[][] results = new PyUnitTestResult[items.length][2];
        int i = 0;
        while (i < items.length) {
            TreeItem it = items[i];
            int j = 0;
            while (j < 5) {
                strings[i][j] = it.getText(j);
                ++j;
            }
            results[i][0] = it.getData("TIP_DATA");
            results[i][1] = it.getData("RESULT");
            ++i;
        }
        tree.setRedraw(false);
        try {
            Color errorColor = this.view.getErrorColor();
            int i2 = 0;
            while (i2 < strings.length) {
                TreeItem item = tree.getItem(i2);
                item.setText(strings[i2]);
                item.setData("TIP_DATA", (Object)results[i2][0]);
                PyUnitTestResult result = results[i2][1];
                item.setData("RESULT", (Object)result);
                if (!result.isOk()) {
                    item.setForeground(errorColor);
                } else {
                    item.setForeground(null);
                }
                ++i2;
            }
        }
        finally {
            tree.setRedraw(true);
        }
        tree.setSortColumn(column);
    }
}

