/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.env;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.newconsole.env.ChooseProcessTypeDialog;
import org.python.pydev.debug.newconsole.env.JythonEclipseProcess;
import org.python.pydev.debug.newconsole.env.PydevSpawnedInterpreterProcess;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.SocketUtil;
import org.python.pydev.runners.SimpleIronpythonRunner;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IProcessFactory {
    private List<IPythonNature> naturesUsed;
    public static final String INTERACTIVE_LAUNCH_PORT = "INTERACTIVE_LAUNCH_PORT";

    public List<IPythonNature> getNaturesUsed() {
        return this.naturesUsed;
    }

    public Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public PydevConsoleLaunchInfo createInteractiveLaunch() throws UserCanceledException, Exception {
        ChooseProcessTypeDialog dialog;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        PyEdit edit = null;
        if (activeEditor instanceof PyEdit) {
            edit = (PyEdit)activeEditor;
        }
        if ((dialog = new ChooseProcessTypeDialog(this.getShell(), edit)).open() == 0) {
            IInterpreterInfo[] interpreters;
            IInterpreterManager interpreterManager = dialog.getInterpreterManager();
            if (interpreterManager == null) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"No interpreter manager for creating console", (String)"No interpreter manager was available for creating a console.");
            }
            if ((interpreters = interpreterManager.getInterpreterInfos()) == null || interpreters.length == 0) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"No interpreters for creating console", (String)"No interpreter available for creating a console.");
                return null;
            }
            IInterpreterInfo interpreter = null;
            if (interpreters.length == 1) {
                interpreter = interpreters[0];
            }
            if (interpreter == null) {
                SelectionDialog listDialog = AbstractInterpreterPreferencesPage.createChooseIntepreterInfoDialog((IWorkbenchWindow)workbenchWindow, (IInterpreterInfo[])interpreters, (String)"Select interpreter to be used.", (boolean)false);
                int open = listDialog.open();
                if (open != 0 || listDialog.getResult().length > 1) {
                    return null;
                }
                Object[] result = listDialog.getResult();
                interpreter = result == null || result.length == 0 ? interpreters[0] : (IInterpreterInfo)result[0];
            }
            if (interpreter == null) {
                return null;
            }
            Tuple<Collection<String>, IPythonNature> pythonpathAndNature = dialog.getPythonpathAndNature(interpreter);
            if (pythonpathAndNature == null) {
                return null;
            }
            return this.createLaunch(interpreterManager, interpreter, (Collection)pythonpathAndNature.o1, (IPythonNature)pythonpathAndNature.o2, dialog.getNatures());
        }
        return null;
    }

    public PydevConsoleLaunchInfo createLaunch(IInterpreterManager interpreterManager, IInterpreterInfo interpreter, Collection<String> pythonpath, IPythonNature nature, List<IPythonNature> naturesUsed) throws Exception {
        String[] commandLine;
        Process process = null;
        this.naturesUsed = naturesUsed;
        Integer[] ports = SocketUtil.findUnusedLocalPorts((int)2);
        int port = ports[0];
        int clientPort = ports[1];
        Launch launch = new Launch(null, "interactive", null);
        launch.setAttribute("org.eclipse.debug.core.capture_output", "false");
        launch.setAttribute(INTERACTIVE_LAUNCH_PORT, new StringBuffer().append(port).toString());
        File scriptWithinPySrc = PydevPlugin.getScriptWithinPySrc((String)"pydevconsole.py");
        String pythonpathEnv = SimpleRunner.makePythonPathEnvFromPaths(pythonpath);
        switch (interpreterManager.getInterpreterType()) {
            case 0: {
                commandLine = SimplePythonRunner.makeExecutableCommandStr((String)interpreter.getExecutableOrJar(), (String)scriptWithinPySrc.getAbsolutePath(), (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                break;
            }
            case 2: {
                commandLine = SimpleIronpythonRunner.makeExecutableCommandStr((String)interpreter.getExecutableOrJar(), (String)scriptWithinPySrc.getAbsolutePath(), (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                break;
            }
            case 1: {
                String vmArgs = PydevDebugPlugin.getDefault().getPreferenceStore().getString("INTERACTIVE_CONSOLE_VM_ARGS");
                commandLine = SimpleJythonRunner.makeExecutableCommandStrWithVMArgs((String)interpreter.getExecutableOrJar(), (String)scriptWithinPySrc.getAbsolutePath(), (String)pythonpathEnv, (String)vmArgs, (String[])new String[]{String.valueOf(port), String.valueOf(clientPort)});
                break;
            }
            case 3: {
                commandLine = null;
                break;
            }
            default: {
                throw new RuntimeException("Expected interpreter manager to be python or jython or iron python related.");
            }
        }
        if (interpreterManager.getInterpreterType() == 3) {
            process = new JythonEclipseProcess(scriptWithinPySrc.getAbsolutePath(), port, clientPort);
        } else {
            String[] env = SimpleRunner.createEnvWithPythonpath((String)pythonpathEnv, (String)interpreter.getExecutableOrJar(), (IInterpreterManager)interpreterManager, (IPythonNature)nature);
            process = SimpleRunner.createProcess((String[])commandLine, (String[])env, null);
        }
        PydevSpawnedInterpreterProcess spawnedInterpreterProcess = new PydevSpawnedInterpreterProcess(process, (ILaunch)launch);
        launch.addProcess((IProcess)spawnedInterpreterProcess);
        return new PydevConsoleLaunchInfo(launch, process, clientPort, interpreter);
    }

    public static final class PydevConsoleLaunchInfo {
        public final Launch launch;
        public final Process process;
        public final int clientPort;
        public final IInterpreterInfo interpreter;

        public PydevConsoleLaunchInfo(Launch launch, Process process, int clientPort, IInterpreterInfo interpreter) {
            this.launch = launch;
            this.process = process;
            this.clientPort = clientPort;
            this.interpreter = interpreter;
        }
    }
}

