/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.DeferredWorkbenchAdapter;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.GetFrameCommand;
import org.python.pydev.debug.model.remote.GetVariableCommand;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyStackFrame
extends PlatformObject
implements IStackFrame,
IVariableLocator {
    private String name;
    private PyThread thread;
    private String id;
    private IPath path;
    private int line;
    private IVariable[] variables;
    private IVariableLocator localsLocator;
    private IVariableLocator globalsLocator;
    private IVariableLocator frameLocator;
    private AbstractDebugTarget target;

    public PyStackFrame(PyThread in_thread, String in_id, String name, IPath file, int line, AbstractDebugTarget target) {
        this.id = in_id;
        this.name = name;
        this.path = file;
        this.line = line;
        this.thread = in_thread;
        this.localsLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tLOCAL";
            }
        };
        this.frameLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tFRAME";
            }
        };
        this.globalsLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tGLOBAL";
            }
        };
        this.target = target;
    }

    public AbstractDebugTarget getTarget() {
        return this.target;
    }

    public String getId() {
        return this.id;
    }

    public String getThreadId() {
        return this.thread.getId();
    }

    public IVariableLocator getLocalsLocator() {
        return this.localsLocator;
    }

    public IVariableLocator getFrameLocator() {
        return this.frameLocator;
    }

    public IVariableLocator getGlobalLocator() {
        return this.globalsLocator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public IPath getPath() {
        return this.path;
    }

    public IThread getThread() {
        return this.thread;
    }

    public void setVariables(IVariable[] locals) {
        this.variables = locals;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.variables == null) {
            this.variables = new IVariable[0];
            DeferredWorkbenchAdapter adapter = new DeferredWorkbenchAdapter(this);
            IVariable[] vars = (IVariable[])adapter.getChildren(this);
            this.target.getModificationChecker().verifyModified(this, vars);
            this.variables = vars;
        }
        return this.variables;
    }

    public Map<String, IVariable> getVariablesAsMap() throws DebugException {
        HashMap<String, IVariable> map = new HashMap<String, IVariable>();
        IVariable[] iVariableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            map.put(var.getName(), var);
            ++n2;
        }
        return map;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public int getLineNumber() throws DebugException {
        return this.line;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return new StringBuffer(String.valueOf(this.name)).append(" [").append(this.path.lastSegment()).append(":").append(Integer.toString(this.line)).append("]").toString();
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public String getModelIdentifier() {
        return this.thread.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.thread.getLaunch();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public Object getAdapter(Class adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/core/ILaunch")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"))) {
            return this.thread.getAdapter(adapter);
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/tasklist/ITaskListResourceAdapter"))) {
            return null;
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/core/model/IDebugTarget"))) {
            return this.thread.getDebugTarget();
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IRunToLineTarget"))) {
            return this.target.getRunToLineTarget();
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/properties/IPropertySource")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/views/tasklist/ITaskListResourceAdapter")) || adapter.equals(ClassLiteral.getClass((String)"org/eclipse/debug/ui/actions/IToggleBreakpointsTarget"))) {
            return super.getAdapter(adapter);
        }
        if (adapter.equals(ClassLiteral.getClass((String)"org/eclipse/ui/progress/IDeferredWorkbenchAdapter"))) {
            return new DeferredWorkbenchAdapter(this);
        }
        AdapterDebug.printDontKnow(this, adapter);
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PyStackFrame) {
            PyStackFrame sf = (PyStackFrame)obj;
            return this.id.equals(sf.id) && this.path.toString().equals(sf.path.toString()) && this.line == sf.line && this.getThreadId().equals(sf.getThreadId());
        }
        return false;
    }

    public GetVariableCommand getFrameCommand(AbstractDebugTarget dbg) {
        return new GetFrameCommand(dbg, this.frameLocator.getPyDBLocation());
    }

    @Override
    public String getPyDBLocation() {
        return this.frameLocator.getPyDBLocation();
    }

    public AbstractRemoteDebugger getDebugger() {
        return this.target.getDebugger();
    }

    public String toString() {
        return new StringBuffer("PyStackFrame: ").append(this.id).toString();
    }
}

