/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.CallbackWithListeners;
import org.python.pydev.core.callbacks.ICallbackWithListeners;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.codecoverage.ErrorFileNode;
import org.python.pydev.debug.codecoverage.FileNode;
import org.python.pydev.debug.codecoverage.FolderNode;
import org.python.pydev.debug.codecoverage.ICoverageLeafNode;
import org.python.pydev.debug.codecoverage.ICoverageNode;
import org.python.pydev.debug.codecoverage.NodeNotFoudException;
import org.python.pydev.debug.codecoverage.PyCoveragePreferences;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageCache {
    public Map<File, ICoverageNode> folders = new HashMap<File, ICoverageNode>();
    public Map<File, ICoverageNode> files = new HashMap<File, ICoverageNode>();
    public static final ICallbackWithListeners<StyleRange> onStyleCreated = new CallbackWithListeners();

    public void addFolder(File node) {
        FolderNode c = new FolderNode();
        c.node = node;
        this.folders.put(node, c);
    }

    public void addFolder(File node, File parent) {
        FolderNode parentNode = this.getFolder(parent);
        FolderNode newNode = new FolderNode();
        newNode.node = node;
        if (parentNode == null) {
            throw new RuntimeException(new StringBuffer("The folder being added:").append(node.toString()).append(" didn't have its parent found.").toString());
        }
        parentNode.subFolders.put(node, newNode);
        this.folders.put(node, newNode);
    }

    public FolderNode getFolder(File obj) {
        return (FolderNode)this.getIt(obj, this.folders);
    }

    public ICoverageNode getFile(File obj) {
        return this.getIt(obj, this.files);
    }

    private ICoverageNode getIt(File obj, Map<File, ICoverageNode> m) {
        ICoverageNode object = m.get(obj);
        if (object == null) {
            for (File element : m.keySet()) {
                if (!((Object)element).equals(obj)) continue;
                return m.get(element);
            }
        }
        return object;
    }

    public void addFile(File node, File parent, int stmts, int miss, String notExecuted) {
        FolderNode folderNode = this.getFolder(parent);
        if (folderNode == null) {
            throw new RuntimeException(new StringBuffer("A file node (").append(node.toString()).append(")MUST have a related folder node.").toString());
        }
        FileNode fileNode = new FileNode();
        fileNode.miss = miss;
        fileNode.node = node;
        fileNode.notExecuted = notExecuted;
        fileNode.stmts = stmts;
        folderNode.files.put(node, fileNode);
        this.files.put(node, fileNode);
    }

    public void addFile(File node, File parent, String desc) {
        FolderNode folderNode = this.getFolder(parent);
        if (folderNode == null) {
            throw new RuntimeException(new StringBuffer("A file node (").append(node.toString()).append(")MUST have a related folder node.").toString());
        }
        ErrorFileNode fileNode = new ErrorFileNode();
        fileNode.node = node;
        fileNode.desc = desc;
        folderNode.files.put(node, fileNode);
        this.files.put(node, fileNode);
    }

    public List<ICoverageNode> getFiles(File node) throws NodeNotFoudException {
        FolderNode folderNode = this.getFolder(node);
        if (folderNode == null) {
            ICoverageNode fileNode = this.getFile(node);
            if (fileNode == null) {
                throw new NodeNotFoudException(new StringBuffer("The node has not been found: ").append(node.toString()).toString());
            }
            ArrayList<ICoverageNode> list = new ArrayList<ICoverageNode>();
            list.add(fileNode);
            return list;
        }
        ArrayList<ICoverageNode> list = new ArrayList<ICoverageNode>();
        this.recursivelyFillList(folderNode, list);
        return list;
    }

    private void recursivelyFillList(FolderNode folderNode, ArrayList<ICoverageNode> list) {
        list.addAll(this.sortCollectionWithCoverageLeafNodes(folderNode.files.values()));
        Iterator<ICoverageNode> it = this.sortCollectionWithToString(folderNode.subFolders.values()).iterator();
        while (it.hasNext()) {
            this.recursivelyFillList((FolderNode)it.next(), list);
        }
    }

    private List<ICoverageLeafNode> sortCollectionWithCoverageLeafNodes(Collection<ICoverageLeafNode> collection) {
        ArrayList<ICoverageLeafNode> vals = new ArrayList<ICoverageLeafNode>(collection);
        Collections.sort(vals, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return vals;
    }

    private List<ICoverageNode> sortCollectionWithToString(Collection<ICoverageNode> collection) {
        ArrayList<ICoverageNode> vals = new ArrayList<ICoverageNode>(collection);
        Collections.sort(vals, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return vals;
    }

    public Tuple<String, List<StyleRange>> getStatistics(String baseLocation, File node) {
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        if (baseLocation == null) {
            baseLocation = "";
        }
        FastStringBuffer buffer = new FastStringBuffer();
        try {
            List<ICoverageNode> list = this.getFiles(node);
            int nameNumberOfColumns = PyCoveragePreferences.getNameNumberOfColumns();
            buffer.append("Name").appendN(' ', nameNumberOfColumns - 4).append("  Stmts     Miss      Cover  Missing\n");
            buffer.appendN('-', nameNumberOfColumns);
            buffer.append("-------------------------------------\n");
            int totalMiss = 0;
            int totalStmts = 0;
            for (ICoverageNode element : list) {
                if (element instanceof FileNode) {
                    FileNode fileNode = (FileNode)element;
                    int start = buffer.length();
                    fileNode.appendToBuffer(buffer, baseLocation, nameNumberOfColumns).append("\n");
                    int len = buffer.indexOf(' ', start) - start;
                    StyleRange styleRange = new StyleRange(start, len, null, null);
                    styleRange.underline = true;
                    try {
                        styleRange.underlineStyle = 4;
                    }
                    catch (Throwable throwable) {}
                    onStyleCreated.call((Object)styleRange);
                    ranges.add(styleRange);
                    styleRange.data = element;
                    totalMiss += fileNode.miss;
                    totalStmts += fileNode.stmts;
                    continue;
                }
                buffer.append(element.toString()).append("\n");
            }
            buffer.appendN('-', nameNumberOfColumns);
            buffer.append("-------------------------------------\n");
            FileNode.appendToBuffer(buffer, "TOTAL", totalStmts, totalMiss, "", nameNumberOfColumns).append("\n");
        }
        catch (NodeNotFoudException nodeNotFoudException) {
            buffer.append("File has no statistics.");
        }
        return new Tuple((Object)buffer.toString(), ranges);
    }

    public void clear() {
        this.folders.clear();
        this.files.clear();
    }
}

