/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractlocal.edit;

import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.scope.GetNodeForExtractLocalVisitor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.refactoring.coderefactoring.extractlocal.request.ExtractLocalRequest;
import org.python.pydev.refactoring.core.base.RefactoringInfo;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

public class CreateLocalVariableEdit
extends AbstractInsertEdit {
    private RefactoringInfo info;
    private String variableName;
    private exprType expression;
    private int lineForLocal = -1;

    public CreateLocalVariableEdit(ExtractLocalRequest req) {
        super(req);
        this.info = req.info;
        this.variableName = req.variableName;
        this.expression = (exprType)req.expression.createCopy();
    }

    protected SimpleNode getEditNode() {
        Name variable = new Name(this.variableName, 2, false);
        exprType[] target = new exprType[]{variable};
        return new Assign(target, this.expression);
    }

    private int calculateLineForLocal() {
        if (this.lineForLocal == -1) {
            Module module;
            ITextSelection userSelection = this.info.getUserSelection();
            PySelection selection = new PySelection(this.info.getDocument(), userSelection);
            int startLineIndex = selection.getStartLineIndex();
            ++startLineIndex;
            Module currentScope = module = (Module)this.info.getModuleAdapter().getASTNode();
            try {
                FindScopeVisitor scopeVisitor = new FindScopeVisitor(startLineIndex, selection.getCursorColumn() + 1);
                module.accept((VisitorIF)scopeVisitor);
                ILocalScope scope = scopeVisitor.scope;
                FastStack scopeStack = scope.getScopeStack();
                currentScope = (SimpleNode)scopeStack.peek();
            }
            catch (Exception e1) {
                PydevPlugin.log((Throwable)e1);
            }
            GetNodeForExtractLocalVisitor visitor = new GetNodeForExtractLocalVisitor(startLineIndex);
            try {
                currentScope.accept((VisitorIF)visitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            SimpleNode lastNodeBeforePassedLine = visitor.getLastInContextBeforePassedLine();
            this.lineForLocal = lastNodeBeforePassedLine != null ? lastNodeBeforePassedLine.beginLine - 1 : selection.getStartLineIndex();
        }
        return this.lineForLocal;
    }

    public int getOffset() {
        PySelection selection = new PySelection(this.info.getDocument(), this.calculateLineForLocal(), 0);
        return selection.getStartLineOffset();
    }

    public int getOffsetStrategy() {
        return 0;
    }

    protected String getIndentation(int indent) {
        PySelection selection = new PySelection(this.info.getDocument(), this.calculateLineForLocal(), 0);
        return selection.getIndentationFromLine();
    }
}

