/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.PythonAbstractPathPage;

public class PythonPackageWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonPackageWizard";

    public PythonPackageWizard() {
        super("Create a new Python package");
    }

    protected PythonAbstractPathPage createPathPage() {
        return new PythonAbstractPathPage(this.description, this.selection){

            protected boolean shouldCreatePackageSelect() {
                return false;
            }
        };
    }

    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        String[] packageParts;
        IContainer validatedSourceFolder = this.filePage.getValidatedSourceFolder();
        IFile lastFile = null;
        if (validatedSourceFolder == null) {
            return null;
        }
        IContainer parent = validatedSourceFolder;
        String validatedName = this.filePage.getValidatedName();
        String[] stringArray = packageParts = StringUtils.dotSplit((String)validatedName);
        int n = packageParts.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String packagePart = stringArray[n2];
            IFolder folder = parent.getFolder((IPath)new Path(packagePart));
            if (!folder.exists()) {
                folder.create(true, true, monitor);
            }
            if (!(file = (parent = folder).getFile((IPath)new Path("__init__" + FileTypesPreferencesPage.getDefaultDottedPythonExtension()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
            }
            lastFile = file;
            ++n2;
        }
        return lastFile;
    }
}

